/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.Sound;
import com.iplanet.im.client.iIM;
import com.iplanet.im.client.jni.DesktopIndicator;
import com.iplanet.im.client.jni.DesktopIndicatorListener;
import com.iplanet.im.client.jni.JNILink;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.StorageManager;
import com.iplanet.im.client.swing.Client;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.util.NetUtility;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.PlatformUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.SwingUtilities;

public class BuddyList {
    static SafeResourceBundle buddyListBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    static SafeResourceBundle brandBundle = null;
    private Communicator communicator;
    private Client parent;
    private DesktopIndicator _trayIcon = null;
    private int _trayIconInage = -1;
    private TrayIconListener _trayIconListener = null;

    public BuddyList(Client c) {
        this.parent = c;
    }

    public void init() {
        if (this.communicator != null) {
            Manager.Out("DEBUG: BuddyList.<init>: communicator is not null");
            this.communicator.reLoad();
            Manager.Out("in BuddyList/init()");
            this.communicator.resetLocalStatus();
        }
        if (this._trayIcon == null && PlatformUtil.isWin() && iIMPropsUtil.getShowTrayIcon(CurrentUserManager.getCurrentUserProperties())) {
            this.initTrayIcon();
        }
    }

    public void connectionLost() {
        BuddyListManager.clear();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BuddyList.this.update(false);
            }
        });
        if (this.communicator != null) {
            this.communicator.changeStatusReconnecting();
        }
    }

    public void updateReconnectStatusLabel(String countStr) {
        if (this.communicator != null) {
            this.communicator.updateReconnectStatusLabel(countStr);
        }
    }

    public void revertPreviousStatus() {
        if (this.communicator != null) {
            Manager.Out("in revertPreviousStatus");
            this.communicator.resetLocalStatus();
        }
    }

    public void changeFont() {
        if (this.communicator != null) {
            this.communicator.changeFont();
        }
    }

    public void close() {
        if (this.communicator != null) {
            this.communicator.saveBuddyListSettings();
        }
        this.removeTrayIcon();
        if (this.communicator != null) {
            this.communicator.close();
        }
    }

    public final boolean addRoom(String name, int access, boolean showUserList) {
        BuddyList buddyList = this;
        if (!buddyList.parent.isConnected()) {
            return false;
        }
        try {
            Conference c = RoomManager.createConferenceRoomAndUpdate(name, access, null, Communicator.getRoomListPanel());
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            ApplicationManager.showMessageBox(buddyListBundle.getString("BuddyList_Room_already_exists"));
            return false;
        }
        this.updateChatRoomModels();
        return true;
    }

    public final void showBuddyList(boolean min) {
        Manager.Out("   DEBUG: showBuddyList()");
        if (Manager.ALLOW_PRESENCE_ACCESS || Manager.ALLOW_ROOM_ACCESS) {
            boolean play_sound = false;
            if (this.communicator == null) {
                Manager.Out("   DEBUG: new Communicator()");
                this.communicator = new Communicator();
                play_sound = true;
            }
            ApplicationManager.refreshFrame(this.communicator, min, true);
            if (play_sound) {
                Sound.play(2);
            }
        }
    }

    public final void updateChatRoomModels() {
        SwingUtilities.invokeLater(new UpdateRoomRunnable());
    }

    public void addUsersToBuddyListGroup(String[] ids, String group) {
        this.communicator.addElementsToBuddyListGroup(ids, group);
    }

    public void addUsersToBuddyListGroup(CollaborationPrincipal[] ids, String group) {
        this.communicator.addElementsToBuddyListGroup(ids, group);
    }

    public void update(boolean b) {
        if (this.communicator != null) {
            this.communicator.updateBuddylist(b);
        }
    }

    public Communicator getCommunicator() {
        return this.communicator;
    }

    public final void refreshRooms() {
        Manager.worker.addRunnable((Runnable)new refreshRoomsRunnable());
    }

    public void initTrayIcon() {
        if (this._trayIcon != null || Manager._is_applet || !JNILink.JNI_LOADED) {
            return;
        }
        URL u = this.getClass().getResource("/com/sun/im/desktop/brand/tray_icon.ico");
        if (u == null) {
            u = this.getClass().getResource("/com/sun/im/desktop/default/brand/tray_icon.ico");
        }
        byte[] b = NetUtility.loadUrlBytes(u, false);
        File f = new File(StorageManager.USER_CACHE);
        f = new File(f, "tray_icon.ico");
        FileUtility.save((File)f, (byte[])b);
        Manager.Out("BuddyList.initTrayIcon(): tray icon absolute path: " + f.getAbsolutePath());
        this._trayIconInage = DesktopIndicator.loadImage(f.getAbsolutePath());
        if (this._trayIconInage == -1) {
            System.err.println("Could not load the image file " + f.getAbsolutePath());
            return;
        }
        Manager.Out("BuddyList.initTrayIcon(): image loaded: " + f.getAbsolutePath());
        String indicatorName = brandBundle != null ? brandBundle.getString("messenger.name") : buddyListBundle.getString("IPlanet_Instant_Messenger");
        Manager.Out("BuddyList.initTrayIcon(): Creating _trayIcon");
        this._trayIcon = new DesktopIndicator(this._trayIconInage, indicatorName);
        Manager.Out("BuddyList.initTrayIcon(): Adding _trayIcon");
        this._trayIconListener = new TrayIconListener();
        this._trayIcon.addDesktopIndicatorListener(this._trayIconListener);
        Manager.Out("BuddyList.initTrayIcon(): _trayIcon added");
        String[] menuLabels = new String[]{"", "", "", "", ""};
        menuLabels[0] = buddyListBundle.getString("mi_traypopup_ShowMessenger");
        menuLabels[2] = buddyListBundle.getString("mi_traypopup_Settings");
        menuLabels[4] = buddyListBundle.getString("mi_traypopup_Exit");
        int[] menuTypes = new int[]{0, 0, 0, 0, 0};
        for (int i = 0; i < menuTypes.length; ++i) {
            menuTypes[i] = menuLabels[i].length() > 0 ? 1 : 2;
        }
        Manager.Out("BuddyList.initTrayIcon(): Calling setPopupMenu");
        this._trayIcon.setPopupMenu(menuLabels, menuTypes, 0);
        Manager.Out("BuddyList.initTrayIcon(): setPopupMenu returned");
    }

    public final boolean isTrayIconPresent() {
        return this._trayIcon != null;
    }

    public final void setTrayIconVisible(boolean b) {
        if (PlatformUtil.isWin()) {
            if (b) {
                if (this._trayIcon == null) {
                    Manager.Out("BuddyList.setTrayIconVisible(): Try to show tray icon");
                    this.initTrayIcon();
                }
            } else if (this._trayIcon != null) {
                Manager.Out("BuddyList.setTrayIconVisible(): Try to hide tray icon");
                this.removeTrayIcon();
            }
        }
    }

    public final void removeTrayIcon() {
        if (this._trayIcon != null) {
            DesktopIndicator.freeImage(this._trayIconInage);
            this._trayIcon.hide();
            this._trayIcon.removeDesktopIndicatorListener(this._trayIconListener);
            this._trayIcon = null;
        }
    }

    static {
        try {
            brandBundle = new SafeResourceBundle("com.sun.im.desktop.brand.brand", "com.sun.im.desktop.default.brand.brand");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class TrayIconListener
    implements DesktopIndicatorListener {
        private static final int MI_TRAYPOPUP_SHOWMESSENGER = 0;
        private static final int MI_TRAYPOPUP_SETTINGS = 2;
        private static final int MI_TRAYPOPUP_EXIT = 4;

        public final void onDesktopIndicatorMousePressed(ActionEvent event) {
            if (event.getActionCommand().equals("Right")) {
                // empty if block
            }
        }

        public void onDesktopIndicatorMouseDblClicked(ActionEvent event) {
            if (event.getActionCommand().equals("Left")) {
                BuddyList.this.communicator.show();
                BuddyList.this.communicator.setState(0);
            }
        }

        public void onDesktopIndicatorPopupClicked(int menuItemID) {
            if (menuItemID == 0) {
                BuddyList.this.communicator.show();
                if (BuddyList.this.communicator.getState() == 1) {
                    BuddyList.this.communicator.setState(0);
                }
            } else if (menuItemID == 2) {
                BuddyList.this.communicator.show();
                if (BuddyList.this.communicator.getState() == 1) {
                    BuddyList.this.communicator.setState(0);
                }
                iIM.showSettings(CurrentUserManager.getCurrentPrincipal(), null);
            } else if (menuItemID == 4 && iIM.canExit(BuddyList.this.communicator)) {
                BuddyList.this.communicator.close(false);
                iIM.exit(BuddyList.this.communicator);
            }
        }
    }

    private static final class refreshRoomsRunnable
    implements Runnable {
        private refreshRoomsRunnable() {
        }

        public void run() {
            RoomManager.refreshRooms();
        }
    }

    private final class UpdateRoomRunnable
    implements Runnable {
        private UpdateRoomRunnable() {
        }

        public void run() {
            if (BuddyList.this.communicator != null) {
                BuddyList.this.communicator.refresh();
            }
        }
    }
}

