/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.FileStreaming;
import com.iplanet.im.client.swing.iIMFrame;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.StickyFileChooser;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.Message;
import com.sun.im.service.util.FileUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttachmentPanel
implements ActionListener,
MouseListener,
ListSelectionListener {
    private JPanel pnlAttachments;
    private JPanel pnlAttachmentActions;
    private JScrollPane attachmentScroller;
    private JButton btnOpenAttachment;
    private JButton btnSaveAttachment;
    private JList attachmentList;
    private JMenuItem miOpenAttachment;
    private JMenuItem miSaveAttachment;
    private SmartJPopupMenu popup;
    private static SafeResourceBundle bundle = new SafeResourceBundle("com/iplanet/im/client/swing/swing");
    private iIMFrame theFrame;
    private Vector attachmentNames = new Vector(1);
    private iIMListModel attachmentModel;
    private iIMListRenderer attachmentRenderer;
    private File selectedFile = null;

    public AttachmentPanel() {
    }

    public AttachmentPanel(iIMFrame frame) {
        this.theFrame = frame;
        this.pnlAttachments = new JPanel();
        this.pnlAttachments.setLayout(new GridBagLayout());
        this.attachmentScroller = new JScrollPane();
        this.pnlAttachments.add((Component)this.attachmentScroller, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlAttachmentActions = new JPanel();
        this.pnlAttachmentActions.setLayout(new GridBagLayout());
        this.btnOpenAttachment = new JButton();
        SwingUtils.setupButton(this.btnOpenAttachment, bundle, "AttachmentPanel_btnOpen_text", "AttachmentPanel_btnOpen_text_M", null, null);
        this.btnOpenAttachment.setEnabled(false);
        this.pnlAttachmentActions.add((Component)this.btnOpenAttachment, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.btnSaveAttachment = new JButton();
        SwingUtils.setupButton(this.btnSaveAttachment, bundle, "AttachmentPanel_btnSave_text", "AttachmentPanel_btnSave_text_M", null, null);
        this.btnSaveAttachment.setEnabled(false);
        this.pnlAttachmentActions.add((Component)this.btnSaveAttachment, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.pnlAttachments.add((Component)this.pnlAttachmentActions, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.attachmentList = new JList();
        this.attachmentList.setSelectionMode(0);
        this.attachmentModel = new iIMListModel(this.attachmentList, this.attachmentNames);
        this.attachmentRenderer = new iIMListRenderer(this.attachmentModel);
        this.attachmentList.setCellRenderer(this.attachmentRenderer);
        this.attachmentList.setModel(this.attachmentModel);
        this.attachmentModel.changed(this.attachmentNames);
        this.attachmentScroller.setViewportView(this.attachmentList);
        this.pnlAttachments.setPreferredSize(new Dimension(385, 65));
        this.attachmentScroller.setMinimumSize(new Dimension(200, 60));
        this.attachmentScroller.setPreferredSize(new Dimension(200, 60));
        this.miOpenAttachment = SwingUtils.menuItem(this, bundle, "AttachmentPanel_miOpen_text", "AttachmentPanel_miOpen_text_M", null);
        this.miOpenAttachment.setFont(this.miOpenAttachment.getFont().deriveFont(1));
        this.miSaveAttachment = SwingUtils.menuItem(this, bundle, "AttachmentPanel_miSave_text", "AttachmentPanel_miSave_text_M", null);
        this.btnOpenAttachment.addActionListener(this);
        this.btnSaveAttachment.addActionListener(this);
        this.attachmentList.addListSelectionListener(this);
        this.attachmentList.addMouseListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        Manager.Out("DEBUG: In AttachmentPanel, actionPerformed");
        if (o == this.btnOpenAttachment || o == this.miOpenAttachment) {
            this.openSelectedAttachment();
        } else if (o == this.btnSaveAttachment || o == this.miSaveAttachment) {
            this.saveSelectedAttachment();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.attachmentList.isSelectionEmpty()) {
            this.btnOpenAttachment.setEnabled(false);
            this.btnSaveAttachment.setEnabled(false);
        } else {
            this.selectedFile = (File)this.attachmentList.getSelectedValue();
            if (this.selectedFile != null) {
                this.btnOpenAttachment.setEnabled(Manager.isFileLaunchable(this.selectedFile.getName()) && !FileStreaming.getInstance().isBadFile(this.selectedFile.getName()));
                this.btnSaveAttachment.setEnabled(true);
            } else {
                System.err.println("attachmentPanel: Attachment list selection listener: Unknown error: can't do nothing with attachment");
            }
        }
    }

    private void openSelectedAttachment() {
        if (this.selectedFile != null && this.attachmentNames.contains(this.selectedFile) && Manager.isFileLaunchable(this.selectedFile.getName())) {
            try {
                Manager.launchFile(this.selectedFile);
            }
            catch (Exception x) {
                System.out.println("AttachmentListener.mouseClicked(): Exception thrown while trying to execute a file: " + x);
            }
        }
    }

    private void saveSelectedAttachment() {
        if (this.selectedFile != null && this.attachmentNames.contains(this.selectedFile)) {
            File f = StickyFileChooser.chooseSaveFile(this.theFrame, this.selectedFile.getName(), null, null);
            if (f == null) {
                return;
            }
            FileUtility.copyFile((File)this.selectedFile, (File)f);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o == this.attachmentList && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1 && this.selectedFile != null && this.attachmentNames.contains(this.selectedFile)) {
            if (Manager.isFileLaunchable(this.selectedFile.getName())) {
                try {
                    Manager.launchFile(this.selectedFile);
                }
                catch (Exception x) {
                    System.out.println("AttachmentListener.mouseClicked(): Exception thrown while trying to execute a file: " + x);
                }
            } else {
                File f = StickyFileChooser.chooseSaveFile(this.theFrame, this.selectedFile.getName(), null, null);
                if (f == null) {
                    return;
                }
                FileUtility.copyFile((File)this.selectedFile, (File)f);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent e) {
        Object o = e.getSource();
        if (o == this.attachmentList) {
            if (!this.attachmentList.isSelectedIndex(this.attachmentList.locationToIndex(e.getPoint()))) {
                this.attachmentList.setSelectedIndex(this.attachmentList.locationToIndex(e.getPoint()));
                this.selectedFile = (File)this.attachmentList.getSelectedValue();
            }
            if (this.selectedFile != null && (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger())) {
                if (this.popup == null) {
                    this.popup = new SmartJPopupMenu();
                }
                this.popup.removeAll();
                this.popup.add(this.miOpenAttachment);
                this.popup.add(this.miSaveAttachment);
                this.miOpenAttachment.setEnabled(Manager.isFileLaunchable(this.selectedFile.getName()));
                this.popup.show(e.getComponent(), new Point(e.getX(), e.getY()));
            }
        }
    }

    public boolean attachmentsPresent() {
        return this.attachmentNames != null && this.attachmentNames.size() > 0;
    }

    public JPanel getAttachmentPanel() {
        return this.pnlAttachments;
    }

    public void updateAttachmentPanelForMessage(Message m) {
        this.btnOpenAttachment.setEnabled(false);
        this.btnSaveAttachment.setEnabled(false);
        List list = ClientMessageFactory.getAttachmentList(m);
        if (list == null) {
            return;
        }
        FileStreaming fs = FileStreaming.getInstance();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            this.attachmentNames.add(fs.getFile((String)itr.next()));
        }
        this.attachmentModel.changed(this.attachmentNames);
    }

    public final void dispose() {
        this.btnOpenAttachment.removeActionListener(this);
        this.btnSaveAttachment.removeActionListener(this);
        this.attachmentList.removeListSelectionListener(this);
        this.attachmentList.removeMouseListener(this);
        this.miOpenAttachment.removeActionListener(this);
        this.miSaveAttachment.removeActionListener(this);
    }
}

