/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceInfoListener;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.util.StringUtility;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class UserStatusManager
extends Manager {
    public static final int WATCHED_ANY = 0;
    public static final int WATCHED_ON = 1;
    public static final int WATCHED_OFF = 2;
    static SafeResourceBundle userStatusManagerBundle = new SafeResourceBundle("com.iplanet.im.client.manager.manager");
    public static final String OFFLINE_MSG = userStatusManagerBundle.getString("Offline");
    public static final String AWAY_MSG = userStatusManagerBundle.getString("Away");
    public static final String IDLE_MSG = userStatusManagerBundle.getString("Idle");
    public static final String ONLINE_MSG = userStatusManagerBundle.getString("Online");
    public static final String UNKNOWN_MSG = userStatusManagerBundle.getString("Unknown");
    static final int MAX_PRIORITY = 256;
    public static final String STATUS_INVISIBLE = "Invisible";
    private static Hashtable htWatchedUsers = new Hashtable(10);
    static UserInfo.ResourceInfo currUserPrevResourceInfo;

    public static final void reload(boolean clear) {
        if (clear) {
            UserStatusManager.clearCache();
        }
    }

    public static final void clearCache() {
        htWatchedUsers.clear();
    }

    public static final void clearStatusWatch(String uid) {
        UserInfo u = UserStatusManager.getUserInfoObject(uid);
        if (u != null) {
            u.setWatched(-1);
        }
    }

    public static final void setUserWatchedAny(String uid) {
        UserInfo u = UserStatusManager.getUserInfoObject(uid);
        if (u != null) {
            u.setWatched(0);
        }
    }

    public static final void setUserWatchedOff(String uid) {
        UserInfo u = UserStatusManager.getUserInfoObject(uid);
        if (u != null) {
            u.setWatched(2);
        }
    }

    public static final void setUserWatchedOn(String uid) {
        UserInfo u = UserStatusManager.getUserInfoObject(uid);
        if (u != null) {
            u.setWatched(1);
        }
    }

    public static final boolean isUserSetForAlertOn(String uid) {
        UserInfo u = UserStatusManager.getUserInfoObject(uid);
        if (u != null) {
            return u.isWatchedOn();
        }
        return false;
    }

    public static final boolean isUserSetForAlertOff(String uid) {
        UserInfo u = UserStatusManager.getUserInfoObject(uid);
        if (u != null) {
            return u.isWatchedOff();
        }
        return false;
    }

    public static final boolean isUserSetForAlertAny(String uid) {
        UserInfo u = UserStatusManager.getUserInfoObject(uid);
        if (u != null) {
            return u.isWatchedAny();
        }
        return false;
    }

    public static final boolean isFirstUpdate(String uid) {
        UserInfo u = UserStatusManager.getUserInfoObject(uid);
        if (u != null) {
            return u.isFirstUpdate();
        }
        return false;
    }

    public static final void storeUserStatus(String id, String status, String reason, float priority) {
        if (status == null) {
            return;
        }
        String uid = StringUtility.removeResource((String)id);
        UserStatusManager.Out("Storing presence info for " + uid);
        UserInfo ui = (UserInfo)htWatchedUsers.get(uid);
        if (ui == null) {
            ui = new UserInfo(id, status, reason, status, reason, priority);
        } else {
            ui.setCurrentStatus(id, status, reason, priority);
        }
        htWatchedUsers.put(uid, ui);
    }

    public static final void storePrevUserStatus(String id, String status, String reason) {
        String uid = StringUtility.removeResource((String)id);
        UserStatusManager.Out("Storing Previous presence info for " + uid);
        UserInfo ui = (UserInfo)htWatchedUsers.get(uid);
        if (ui == null) {
            ui = new UserInfo(uid, status, reason, status, reason, 0.0f);
        } else {
            ui.setPrevStatus(status, reason);
        }
        htWatchedUsers.put(uid, ui);
    }

    public static final void setCurrentUserStatusToServerNow(String uid, String status, String reason) {
        UserStatusManager.setCurrentUserStatusToServerNow(uid, status, reason, null);
    }

    public static final void setCurrentUserStatusToServerNow(String uid, String status, String reason, String[] rcpt) {
        if (uid == null || status == null) {
            return;
        }
        try {
            PresenceTuple pt = new PresenceTuple(uid);
            pt.setStatus(status);
            pt.addNote(reason);
            pt.setPriority(UserStatusManager.getCurrentUserPriority(status));
            Presence p = new Presence(uid);
            p.addTuple(pt);
            if (rcpt != null) {
                for (int i = 0; i < rcpt.length; ++i) {
                    _presenceSession.publish(p, rcpt[i]);
                }
            } else {
                _presenceSession.publish(p);
                UserStatusManager.storeUserStatus(uid, status, reason, pt.getPriority());
            }
        }
        catch (CollaborationException ne) {
            System.out.println((Object)ne);
        }
    }

    public static final void setCurrentUserStatus(String type, String msg) {
        String uid = CurrentUserManager.getCurrentUserID();
        UserInfo ui = UserStatusManager.getUserInfoObject(uid);
        Object curStatus = null;
        if (ui == null) {
            ui = new UserInfo(CurrentUserManager.getCurrUsrUIDWithResource(), type, msg, type, msg, UserStatusManager.getCurrentUserPriority(type));
        } else {
            ui.setCurrentStatus(CurrentUserManager.getCurrUsrUIDWithResource(), type, msg, UserStatusManager.getCurrentUserPriority(type));
        }
        htWatchedUsers.put(uid, ui);
    }

    public static final void setCurrentUserStatusToServer(String uid, String status, String reason) {
        worker.addRunnable((Runnable)new SetStatusThread(uid, status, reason));
    }

    public static final void setCurrentUserStatusToServer(String uid, String status, String reason, String[] rcpt) {
        worker.addRunnable((Runnable)new SetStatusThread(uid, status, reason, rcpt));
    }

    public static final UserInfo getUserInfoObject(String id) {
        return (UserInfo)htWatchedUsers.get(id);
    }

    public static final void removeUserInfoObject(String id) {
        htWatchedUsers.remove(id);
    }

    public static final float getCurrentUserPriority(String status) {
        int priority = Manager.getSessionPriority();
        if ("OPEN".equals(status) && iIMPropsUtil.isOnlinePriorityEnabled(CurrentUserManager.getCurrentUserProperties())) {
            priority = iIMPropsUtil.getOnlinePriority(CurrentUserManager.getCurrentUserProperties());
        } else if ("AWAY".equals(status) && iIMPropsUtil.isAwayPriorityEnabled(CurrentUserManager.getCurrentUserProperties())) {
            priority = iIMPropsUtil.getAwayPriority(CurrentUserManager.getCurrentUserProperties());
        } else if ("BUSY".equals(status) && iIMPropsUtil.isDNDPriorityEnabled(CurrentUserManager.getCurrentUserProperties())) {
            priority = iIMPropsUtil.getDNDPriority(CurrentUserManager.getCurrentUserProperties());
        } else if ("IDLE".equals(status) && iIMPropsUtil.isIdlePriorityEnabled(CurrentUserManager.getCurrentUserProperties())) {
            priority = iIMPropsUtil.getIdlePriority(CurrentUserManager.getCurrentUserProperties());
        }
        float pri = 0.5f;
        if (priority != -1) {
            pri = (float)(priority + 128) / 256.0f;
        }
        return pri;
    }

    public static final String getUserStatusString(String id) {
        UserInfo i = (UserInfo)htWatchedUsers.get(id);
        StringBuffer ret = new StringBuffer();
        if (i == null) {
            // empty if block
        }
        return i.curMsg;
    }

    public static final String[] getWatchedUsers() {
        Vector v = Manager.getVectorFromEnumeration(htWatchedUsers.keys());
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public static final String[] getOnlineWatchedUsers() {
        Vector v = Manager.getVectorFromEnumeration(htWatchedUsers.keys());
        ArrayList<String> onlineIDs = new ArrayList<String>();
        String id = "";
        for (int i = 0; i < v.size(); ++i) {
            id = (String)v.get(i);
            if (((UserInfo)htWatchedUsers.get(id)).isOffLine()) continue;
            onlineIDs.add(id);
        }
        String[] toReturn = new String[onlineIDs.size()];
        toReturn = onlineIDs.toArray(toReturn);
        return toReturn;
    }

    public static final boolean isWatchedUser(String id) {
        return htWatchedUsers.containsKey(id);
    }

    public static final boolean isStatusInvisible() {
        UserInfo.ResourceInfo ri;
        String uid = CurrentUserManager.getCurrentUserID();
        UserInfo ui = UserStatusManager.getUserInfoObject(uid);
        return ui != null && (ri = ui.getResourceInfo(CurrentUserManager.getCurrUsrUIDWithResource())) != null && STATUS_INVISIBLE.equals(ri.getStatus());
    }

    public static final void cancelSubscription(String uid) {
        try {
            _presenceSession.cancel(uid);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final void getUsersStatusFromServer(String[] ids, boolean watch, PresenceInfoListener listener) {
        if (ids == null || ids.length == 0) {
            return;
        }
        try {
            if (!watch) {
                _presenceSession.unsubscribe(ids);
                for (int i = 0; i < ids.length; ++i) {
                    htWatchedUsers.remove(ids[i]);
                }
                return;
            }
            Presence[] p = _presenceSession.fetchPresence(ids);
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == null) {
                    return;
                }
                Object[] o = p[i].getTuples().toArray();
                PresenceTuple pt = (PresenceTuple)o[0];
                UserStatusManager.storeUserStatus(pt.getContact(), pt.getStatus(), pt.getNote(), pt.getPriority());
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final ImageIcon getIcon(String status, Object obj) {
        if (status == null) {
            return null;
        }
        if ("OPEN".equals(status)) {
            return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_online.png", "/com/sun/im/desktop/default/presenceicons/sb_online.png", obj);
        }
        if ("CLOSED".equals(status)) {
            return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_offline.png", "/com/sun/im/desktop/default/presenceicons/sb_offline.png", obj);
        }
        if ("AWAY".equals(status)) {
            return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_away.png", "/com/sun/im/desktop/default/presenceicons/sb_away.png", obj);
        }
        if ("BUSY".equals(status)) {
            return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_dnd.png", "/com/sun/im/desktop/default/presenceicons/sb_dnd.png", obj);
        }
        if ("CHAT".equals(status)) {
            return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_online.png", "/com/sun/im/desktop/default/presenceicons/sb_online.png", obj);
        }
        if ("IDLE".equals(status)) {
            return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_idle.png", "/com/sun/im/desktop/default/presenceicons/sb_idle.png", obj);
        }
        if ("FORWARDED".equals(status)) {
            return SwingImageManager.getIcon(4, obj);
        }
        if ("PENDING".equals(status)) {
            return SwingImageManager.getIcon(10, obj);
        }
        if ("OTHER".equals(status)) {
            return null;
        }
        return null;
    }

    public static void setCurrUsersPrevResourceInfo(UserInfo.ResourceInfo ri) {
        UserInfo ui = UserStatusManager.getUserInfoObject(CurrentUserManager.getCurrentUserID());
        if (currUserPrevResourceInfo == null) {
            UserInfo userInfo = ui;
            userInfo.getClass();
            currUserPrevResourceInfo = userInfo.new UserInfo.ResourceInfo(CurrentUserManager.getCurrUsrUIDWithResource(), ri.getStatus(), ri.getReason(), ri.getPriority(), ri.getTimestamp());
        } else {
            currUserPrevResourceInfo.setStatus(ri.getStatus());
            currUserPrevResourceInfo.setReason(ri.getReason());
            currUserPrevResourceInfo.setPriority(ri.getPriority());
            currUserPrevResourceInfo.setTimestamp(ri.getTimestamp());
        }
    }

    public static UserInfo.ResourceInfo getCurrUsersPrevResourceInfo() {
        return currUserPrevResourceInfo;
    }

    static class SetStatusThread
    implements Runnable {
        private String uid;
        private String status;
        private String reason;
        private String[] rcpt;

        public SetStatusThread(String uid, String status, String reason) {
            this.uid = uid;
            this.status = status;
            this.reason = reason;
        }

        public SetStatusThread(String uid, String status, String reason, String[] rcpt) {
            this.uid = uid;
            this.status = status;
            this.reason = reason;
            this.rcpt = rcpt;
        }

        public void run() {
            UserStatusManager.setCurrentUserStatusToServerNow(this.uid, this.status, this.reason, this.rcpt);
        }
    }
}

