/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserCache;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalProfile;
import com.sun.im.service.util.StringUtility;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class UserPropsManager
extends Manager {
    private static ArrayList _listeners = new ArrayList();

    public static void saveUserSettingsNow(PersonalProfile nu, Properties p, boolean merge) {
        try {
            if (!merge) {
                Object[] set = nu.getPropertyNames().toArray();
                for (int i = 0; i < set.length; ++i) {
                    nu.removeProperty((String)set[i]);
                }
            }
            Enumeration<?> enumeration = p.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = p.getProperty(key);
                nu.setProperty(key, value);
            }
            nu.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UserPropsManager.firePropertyChangeEvent();
    }

    public static void saveUserSettings(PersonalProfile pp, Properties p, boolean merge) {
        if (worker != null) {
            worker.addRunnable((Runnable)new SaveUserSettingsRunnable(pp, p, merge));
        } else {
            UserPropsManager.saveUserSettingsNow(pp, p, merge);
        }
    }

    public static final Properties loadUserProperties(PersonalProfile pp) {
        if (pp == null) {
            return null;
        }
        UserPropsManager.Out("Loading properties for user " + pp.getEntryId());
        Properties props = new Properties();
        Map m = pp.getProperties();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = m.get(key);
            if (value instanceof Set) {
                value = StringUtility.getFirstAttr(value);
            }
            if (value == null) continue;
            props.setProperty(key, (String)value);
        }
        return props;
    }

    public static final Properties loadUserProperties(String uid) {
        try {
            CollaborationPrincipal cp = UserCache.getPrincipal(uid);
            return UserPropsManager.loadUserProperties(_personalStoreSession.getProfile(cp));
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String substituteMacros(String in, CollaborationPrincipal p, String header, String trailer) {
        String out = in;
        Enumeration e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            out = StringUtility.substitute((String)out, (String)(header + key + trailer), (String)p.getProperty(key));
        }
        return out;
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        if (!_listeners.contains(l)) {
            _listeners.add(l);
        }
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        _listeners.remove(l);
    }

    private static void firePropertyChangeEvent() {
        int count = _listeners.size();
        PropertyChangeEvent e = new PropertyChangeEvent(_listeners, null, null, null);
        for (int i = 0; i < count; ++i) {
            PropertyChangeListener l = (PropertyChangeListener)_listeners.get(i);
            l.propertyChange(e);
        }
    }

    static final class SaveUserSettingsRunnable
    implements Runnable {
        private PersonalProfile pp;
        private Properties p;
        private boolean merge;

        public SaveUserSettingsRunnable(PersonalProfile pp, Properties p, boolean merge) {
            this.p = p;
            this.pp = pp;
            this.merge = merge;
        }

        public void run() {
            UserPropsManager.saveUserSettingsNow(this.pp, this.p, this.merge);
        }
    }
}

