/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationPrincipal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class UserInfo {
    static SafeResourceBundle userInfoBundle = new SafeResourceBundle("com.iplanet.im.client.manager.manager");
    public String curStatus = "CLOSED";
    public String prevStatus = "CLOSED";
    public String curMsg = userInfoBundle.getString("unknown");
    public String prevMsg = userInfoBundle.getString("unknown");
    private String uid = "";
    private int WATCH = -1;
    private boolean _firstUpdate;
    private String tooltip = null;
    private HashMap _resources = new HashMap();

    public UserInfo(String uid, String status, String reason, String prevStatus, String prevReason, float priority) {
        this.uid = uid;
        this.setCurrentStatus(uid, status, reason, priority);
        this.prevStatus = prevStatus;
        this._firstUpdate = true;
    }

    private ResourceInfo getEvalResourceInfo() {
        int size = this._resources.size();
        if (size == 0) {
            return null;
        }
        Iterator itr = this._resources.values().iterator();
        if (size == 1) {
            return (ResourceInfo)itr.next();
        }
        int count = 1;
        ResourceInfo highPriRes = (ResourceInfo)itr.next();
        ResourceInfo temp = null;
        while (itr.hasNext()) {
            temp = (ResourceInfo)itr.next();
            if (temp.getPriority() > highPriRes.getPriority()) {
                highPriRes = temp;
                count = 1;
                continue;
            }
            if (temp.getPriority() != highPriRes.getPriority()) continue;
            ++count;
        }
        if (count == 1) {
            return highPriRes;
        }
        ResourceInfo[] resInfos = new ResourceInfo[count];
        itr = this._resources.values().iterator();
        int i = 0;
        float pri = highPriRes.getPriority();
        while (itr.hasNext()) {
            temp = (ResourceInfo)itr.next();
            if (temp.getPriority() != pri) continue;
            resInfos[i++] = temp;
        }
        temp = resInfos[0];
        for (i = 1; i < resInfos.length; ++i) {
            temp = temp.getTimestamp().after(resInfos[i].getTimestamp()) ? temp : resInfos[i];
        }
        return temp;
    }

    public final synchronized void setCurrentStatus(String uid, String status, String reason, float priority) {
        if (status == null) {
            return;
        }
        this._firstUpdate = false;
        this.tooltip = null;
        if (status == "CLOSED") {
            this._resources.remove(uid);
        } else if (status != "PENDING") {
            ResourceInfo resInfo = (ResourceInfo)this._resources.get(uid);
            if (resInfo != null) {
                resInfo.setPriority(priority);
                resInfo.setStatus(status);
                resInfo.setReason(reason);
                resInfo.setTimestamp(new Date(System.currentTimeMillis()));
            } else {
                this._resources.put(uid, new ResourceInfo(uid, status, reason, priority, new Date(System.currentTimeMillis())));
            }
        }
        ResourceInfo r = this.getEvalResourceInfo();
        if (r != null) {
            status = r.getStatus();
            reason = r.getReason();
        }
        this.prevStatus = this.curStatus;
        this.prevMsg = this.curMsg;
        this.curStatus = status;
        if (reason == null || reason.equals("")) {
            if (status.equals("OPEN")) {
                reason = userInfoBundle.getString("Online");
            } else if (status.equals("AWAY")) {
                reason = userInfoBundle.getString("Away");
            } else if (status.equals("IDLE")) {
                reason = userInfoBundle.getString("Idle");
            } else if (status.equals("CLOSED")) {
                reason = userInfoBundle.getString("Offline");
            } else if (status.equals("PENDING")) {
                reason = userInfoBundle.getString("Pending");
            } else if (status.equals("CHAT")) {
                reason = userInfoBundle.getString("Chat");
            } else if (status.equals("BUSY")) {
                reason = userInfoBundle.getString("Busy");
            }
        } else if (reason.equalsIgnoreCase("notfound")) {
            reason = userInfoBundle.getString("notfound");
        }
        this.curMsg = reason;
        Manager.Out("Current status = " + status + "Reason = " + reason);
    }

    public final void setPrevStatus(String status, String reason) {
        if (status == null) {
            return;
        }
        this.prevStatus = status;
        this.prevMsg = reason;
    }

    public String getPrevStatus() {
        return this.prevStatus;
    }

    public String getPrevStatusMsg() {
        return this.prevMsg;
    }

    public String getCurrentStatus() {
        return this.curStatus;
    }

    public boolean isFirstUpdate() {
        return this._firstUpdate;
    }

    public void cleanResources() {
        this._resources.clear();
    }

    public final CollaborationPrincipal getPrincipal() {
        return UserCache.getPrincipal(this.uid);
    }

    public final boolean isAway() {
        return this.curStatus.equals("AWAY");
    }

    public boolean isOnLine() {
        return this.curStatus.equals("OPEN");
    }

    public boolean isIdle() {
        return this.curStatus.equals("IDLE");
    }

    public boolean isBusy() {
        return this.curStatus.equals("BUSY");
    }

    public boolean isChat() {
        return this.curStatus.equals("CHAT");
    }

    public boolean isPending() {
        return this.curStatus.equals("PENDING");
    }

    public final boolean isOffLine() {
        return this.curStatus.equals("CLOSED") || this.curStatus.equals("FORWARDED") || this.curStatus.equals("Invisible");
    }

    public final boolean isOffLineFwd() {
        return this.curStatus.equals("FORWARDED");
    }

    public final boolean isWatchedOn() {
        return this.WATCH == 1;
    }

    public final boolean isWatchedOff() {
        return this.WATCH == 2;
    }

    public final boolean isWatchedAny() {
        return this.WATCH == 0;
    }

    public final void setWatched(int n) {
        this.WATCH = n;
    }

    public final String getTooltip() {
        return this.tooltip;
    }

    public final void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public ResourceInfo getResourceInfo(String uid) {
        return (ResourceInfo)this._resources.get(uid);
    }

    public class ResourceInfo {
        private String _uid;
        private String _status;
        private String _reason;
        private Date _timestamp;
        private float _priority;

        ResourceInfo(String uid, String status, String reason, float priority, Date timestamp) {
            this._uid = uid;
            this._status = status;
            this._reason = reason;
            this._timestamp = timestamp;
            this._priority = priority;
        }

        public String getUID() {
            return this._uid;
        }

        public void setStatus(String status) {
            this._status = status;
        }

        public String getStatus() {
            return this._status;
        }

        public void setTimestamp(Date timestamp) {
            this._timestamp = timestamp;
        }

        public Date getTimestamp() {
            return this._timestamp;
        }

        public void setPriority(float priority) {
            this._priority = priority;
        }

        public float getPriority() {
            return this._priority;
        }

        public void setReason(String reason) {
            this._reason = reason;
        }

        public String getReason() {
            return this._reason;
        }

        public String toString() {
            return "UID: " + this._uid + " Status: " + this._status + " Reason: " + this._reason + " Timestamp: " + this._timestamp + " priority: " + this._priority;
        }
    }
}

