/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserPropsManager;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGroup;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.util.StringUtility;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class UserCache
extends Manager {
    private static Hashtable _primaryCache = new Hashtable(20);
    private static Hashtable _principals = new Hashtable(20);

    public static final void addToPrimaryCache(CollaborationPrincipal p) {
        _primaryCache.put(p.getUID().toLowerCase(), p);
    }

    public static final void clearPrimaryCache() {
        _primaryCache.clear();
    }

    public static final void clearCache() {
        _principals.clear();
    }

    public static final void addPrincipalToCache(CollaborationPrincipal p) {
        if (p == null) {
            return;
        }
        _principals.put(p.getUID().toLowerCase(), p);
    }

    public static final void addPrincipalToCache(CollaborationPrincipal[] p) {
        if (p == null) {
            return;
        }
        for (int n = 0; n < p.length; ++n) {
            UserCache.addPrincipalToCache(p[n]);
        }
    }

    public static final CollaborationPrincipal getPrincipal(String uid) {
        try {
            CollaborationPrincipal element = (CollaborationPrincipal)_primaryCache.get(uid.toLowerCase());
            if (element == null) {
                element = (CollaborationPrincipal)_principals.get(uid.toLowerCase());
            }
            if (element != null) {
                return element;
            }
            PersonalContact pc = (PersonalContact)_personalStoreSession.getEntry("contact", StringUtility.removeResource((String)uid));
            if (pc != null) {
                element = pc.getPrincipal();
            } else {
                PersonalGroup pg = (PersonalGroup)_personalStoreSession.getEntry("group", uid);
                if (pg != null) {
                    element = pg.getGroup();
                } else {
                    CollaborationPrincipal[] users;
                    String pattern = uid;
                    String localDomain = CurrentUserManager.getCurrentUserServer();
                    if (StringUtility.getDomainFromAddress((String)uid, (String)localDomain).equalsIgnoreCase(localDomain)) {
                        pattern = StringUtility.getLocalPartFromAddress((String)uid);
                    }
                    if ((users = _personalStoreSession.searchPrincipals(0, pattern)) != null) {
                        element = users[0];
                    }
                    if (element == null) {
                        element = _session.createPrincipal(uid);
                    }
                }
            }
            _principals.put(uid, element);
            return element;
        }
        catch (ServiceUnavailableException sue) {
            try {
                CollaborationPrincipal p = _session.createPrincipal(uid);
                _principals.put(uid, p);
                return p;
            }
            catch (CollaborationException e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final CollaborationPrincipal[] search(String pattern, int searchType) throws CollaborationException {
        CollaborationPrincipal[] users = null;
        try {
            users = _personalStoreSession.searchPrincipals(searchType, pattern);
            UserCache.addPrincipalToCache(users);
            return users;
        }
        catch (ServiceUnavailableException sue) {
            if (searchType == 0) {
                users = new CollaborationPrincipal[]{_session.createPrincipal(pattern)};
            }
            _principals.put(pattern, users[0]);
            return users;
        }
    }

    public static final CollaborationPrincipal[] getPrincipal(String[] uid) {
        if (uid == null) {
            return null;
        }
        CollaborationPrincipal[] ret = new CollaborationPrincipal[uid.length];
        for (int n = 0; n < uid.length; ++n) {
            ret[n] = UserCache.getPrincipal(uid[n]);
        }
        return ret;
    }

    public static final Vector getPrincipalVectorFromUids(String[] uid) throws CollaborationException {
        if (uid == null) {
            return null;
        }
        Vector<CollaborationPrincipal> ret = new Vector<CollaborationPrincipal>(5);
        for (int n = 0; n < uid.length; ++n) {
            CollaborationPrincipal element = UserCache.getPrincipal(uid[n]);
            if (element == null || ret.contains(element)) continue;
            ret.addElement(element);
        }
        return ret;
    }

    public static final String getDisplayName(String uid) {
        CollaborationPrincipal element = UserCache.getPrincipal(uid);
        return element.getDisplayName();
    }

    public static final String[] getUIDsFromUsers(Collection u) {
        String[] ret = new String[u.size()];
        int n = 0;
        Iterator i = u.iterator();
        while (i.hasNext()) {
            ret[n++] = ((CollaborationPrincipal)i.next()).getUID();
        }
        return ret;
    }

    public static final String[] getUIDsFromUsers(PersonalStoreEntry[] nu) {
        String[] ret = new String[nu.length];
        for (int n = 0; n < nu.length; ++n) {
            ret[n] = nu[n].getEntryId();
        }
        return ret;
    }

    public static boolean isActiveUser(CollaborationPrincipal principal) {
        String ret = principal.getProperty("last");
        return ret == null ? true : !ret.equalsIgnoreCase("never");
    }

    public static boolean isRegularUser(String uid) {
        try {
            PersonalContact pc = (PersonalContact)Manager._personalStoreSession.getEntry("contact", uid);
            if (pc != null) {
                return pc.getInboundSubscriptionStatus() == 1;
            }
            return false;
        }
        catch (CollaborationException collaborationException) {
            return true;
        }
    }

    public static String formatUserGroupDisplay(CollaborationPrincipal cp, String searchResultUserFormat, String searchResultGroupFormat) {
        StringBuffer ret = new StringBuffer();
        if (UserCache.belongsToPrimaryCache(cp.getUID())) {
            ret.append(cp.getDisplayName());
        } else if (!(cp instanceof CollaborationGroup)) {
            UserCache.format(ret, cp, searchResultUserFormat);
        } else {
            UserCache.format(ret, cp, searchResultGroupFormat);
        }
        return ret.toString();
    }

    private static void format(StringBuffer ret, CollaborationPrincipal cp, String format) {
        if (format == null) {
            return;
        }
        String tmp = UserPropsManager.substituteMacros(format, cp, "${attr:", "}");
        tmp = StringUtility.substituteMacros((String)tmp, (String)"${attr:", (String)"}", (String)"");
        tmp = StringUtility.substitute((String)tmp, (String)"{displayname}", (String)cp.getDisplayName());
        tmp = StringUtility.substitute((String)tmp, (String)"{domainname}", (String)cp.getDomainName());
        ret.append(" ").append(tmp);
    }

    public static boolean belongsToPrimaryCache(String uid) {
        CollaborationPrincipal element = (CollaborationPrincipal)_primaryCache.get(uid.toLowerCase());
        return element != null;
    }
}

