/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.PrivacyItem;
import com.sun.im.service.PrivacyList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class UserAccessControl
extends Manager {
    static Map dummyPrivProfiles;
    public static String visibleToAllPrivListName;
    public static String invisibleToAllPrivListName;
    public static String migratedPrivListName;
    public static String localizedInvisibleToAll;
    public static String localizedVisibleToAll;
    public static String localizedMigrated;
    static String prevActivePrivList;

    public static final boolean canOpenControlPanel() {
        return iIMPropsUtil.getConfigAccess(Manager.userSettings);
    }

    static final int getAccess(Conference c) {
        try {
            return c.getPrivilege();
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static final boolean canChangeSettings() {
        return Manager.ALLOW_SETTINGS_CHANGES;
    }

    public static final boolean canSendAlerts() {
        return Manager.ALLOW_SEND_ALERTS;
    }

    public static final boolean canUseCommunicator() {
        return Manager.ALLOW_PRESENCE_ACCESS;
    }

    public static final boolean isAdmin() {
        return false;
    }

    public static final boolean canCreateTopic() {
        return Manager.ALLOW_NEWS_MANAGEMENT;
    }

    public static final boolean canCreateRoom() {
        return Manager.ALLOW_ROOM_MANAGEMENT;
    }

    public static final boolean hasPrivilege(Conference c, int permission) {
        try {
            if (c == null) {
                return false;
            }
            Manager.Out("destination = " + c.getDestination() + " check for = " + permission);
            return c.hasPrivilege(permission);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final PrivacyList createNewPrivacyList(String name) {
        try {
            return Manager._session.createPrivacyList(name);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final boolean deletePrivacyList(String name) throws CollaborationException {
        if (name == null || name.equals(localizedVisibleToAll) || name.equals(localizedInvisibleToAll)) {
            return false;
        }
        if (name.equals(localizedMigrated)) {
            name = migratedPrivListName;
        }
        Manager._session.removePrivacyList(name);
        return true;
    }

    public static final void renamePrivacyList(String name, String newName) throws CollaborationException {
        PrivacyList plist;
        if (name.equals(localizedMigrated)) {
            name = migratedPrivListName;
        }
        if ((plist = Manager._session.getPrivacyList(name)) != null) {
            UserAccessControl.deletePrivacyList(name);
            plist.setName(newName);
            Manager._session.addPrivacyList(plist);
        }
    }

    public static final void setPrivacyList(String name, PrivacyList plist) throws CollaborationException {
        if (localizedInvisibleToAll.equals(name)) {
            plist = UserAccessControl.createInvisibleToAllPrivacyList();
            name = invisibleToAllPrivListName;
        } else if (localizedMigrated.equals(name)) {
            name = migratedPrivListName;
        }
        plist.setName(name);
        Manager._session.addPrivacyList(plist);
    }

    public static final void setActivePrivacyList(String name) throws CollaborationException {
        String currActivePrivList;
        prevActivePrivList = currActivePrivList = UserAccessControl.getActivePrivacyList();
        if (localizedVisibleToAll.equals(name)) {
            UserAccessControl.inactivateDummyProfile();
            UserAccessControl.declineActivePrivacyList();
            UserAccessControl.setVisibleToAllProfileActive(true);
        } else if (localizedInvisibleToAll.equals(name)) {
            UserAccessControl.inactivateDummyProfile();
            UserAccessControl.setInvisibleToAllProfileActive(true);
            UserAccessControl.setActivePrivacyListToServer(invisibleToAllPrivListName);
        } else {
            UserAccessControl.inactivateDummyProfile();
            if (localizedMigrated.equals(name)) {
                name = migratedPrivListName;
            }
            UserAccessControl.setActivePrivacyListToServer(name);
        }
    }

    private static final void setActivePrivacyListToServer(String name) throws CollaborationException {
        Manager._session.setActivePrivacyListName(name);
    }

    public static final void setDefaultPrivacyList(String name) throws CollaborationException {
        String dList = UserAccessControl.getDefaultPrivacyList();
        if (localizedVisibleToAll.equals(name)) {
            if (dList != null && !dList.equals(localizedVisibleToAll)) {
                UserAccessControl.undefaultDummyProfile();
                UserAccessControl.declineDefaultPrivacyList();
            }
            UserAccessControl.setVisibleToAllProfileDefault(true);
        } else if (localizedInvisibleToAll.equals(name)) {
            if (dList != null) {
                UserAccessControl.undefaultDummyProfile();
                UserAccessControl.setInvisibleToAllProfileDefault(true);
            }
            UserAccessControl.setDefaultPrivacyListToServer(invisibleToAllPrivListName);
        } else {
            UserAccessControl.undefaultDummyProfile();
            if (localizedMigrated.equals(name)) {
                name = migratedPrivListName;
            }
            UserAccessControl.setDefaultPrivacyListToServer(name);
        }
    }

    private static final void setDefaultPrivacyListToServer(String name) throws CollaborationException {
        Manager._session.setDefaultPrivacyListName(name);
    }

    public static final PrivacyList getPrivacyList(String name) throws CollaborationException {
        PrivacyList pl = null;
        if (localizedVisibleToAll.equals(name)) {
            pl = ((DummyPrivacyProfile)dummyPrivProfiles.get(name)).getPrivList();
        } else if (localizedInvisibleToAll.equals(name)) {
            name = invisibleToAllPrivListName;
        } else if (localizedMigrated.equals(name)) {
            name = migratedPrivListName;
        }
        pl = Manager._session.getPrivacyList(name);
        return pl;
    }

    public static final Vector getAllPrivacyLists() throws CollaborationException {
        Manager.Out("UserAccessControl#getAllPrivacyLists getting invoked");
        List l = Manager._session.listPrivacyLists();
        if (l.contains(invisibleToAllPrivListName)) {
            l.remove(invisibleToAllPrivListName);
            l.add(localizedInvisibleToAll);
        }
        if (l.contains(migratedPrivListName)) {
            l.remove(migratedPrivListName);
            l.add(localizedMigrated);
        }
        return new Vector(l);
    }

    public static final void showPresenceToAllUsers(PrivacyList list) throws CollaborationException {
        PrivacyItem pitem = list.createPrivacyItem(null, 1);
        pitem.setResource(2);
        list.addPrivacyItem(pitem);
    }

    public static final void showPresenceToUsersInContactList(PrivacyList list) throws CollaborationException {
        PrivacyItem pitem = list.createPrivacyItem("subscription", 1);
        pitem.setSubject("to");
        pitem.setResource(2);
        list.addPrivacyItem(pitem);
        pitem = list.createPrivacyItem("subscription", 1);
        pitem.setSubject("both");
        pitem.setResource(2);
        list.addPrivacyItem(pitem);
        pitem = list.createPrivacyItem(null, 2);
        pitem.setResource(2);
        list.addPrivacyItem(pitem);
    }

    public static final void showPresenceToUsersInContactFolders(String[] folders, PrivacyList list) throws CollaborationException {
        PrivacyItem pitem;
        for (int i = 0; i < folders.length; ++i) {
            pitem = list.createPrivacyItem("group", 1);
            pitem.setResource(2);
            pitem.setSubject(folders[i]);
            list.addPrivacyItem(pitem);
        }
        pitem = list.createPrivacyItem(null, 2);
        pitem.setResource(2);
        list.addPrivacyItem(pitem);
    }

    public static final void showPresenceToUsers(String[] users, PrivacyList list) throws CollaborationException {
        PrivacyItem pitem;
        for (int i = 0; i < users.length; ++i) {
            pitem = list.createPrivacyItem("jid", 1);
            pitem.setResource(2);
            pitem.setSubject(users[i]);
            list.addPrivacyItem(pitem);
        }
        pitem = list.createPrivacyItem(null, 2);
        pitem.setResource(2);
        list.addPrivacyItem(pitem);
    }

    public static final void blockMessagesFromNonBuddy(PrivacyList list) throws CollaborationException {
        PrivacyItem pitem = list.createPrivacyItem("subscription", 1);
        pitem.setSubject("to");
        pitem.setResource(4);
        list.addPrivacyItem(pitem);
        pitem = list.createPrivacyItem("subscription", 1);
        pitem.setSubject("both");
        pitem.setResource(4);
        list.addPrivacyItem(pitem);
        pitem = list.createPrivacyItem(null, 2);
        pitem.setResource(4);
        list.addPrivacyItem(pitem);
    }

    public static final void blockMessagesExceptContactFolders(String[] folders, PrivacyList list) throws CollaborationException {
        PrivacyItem pitem;
        for (int i = 0; i < folders.length; ++i) {
            pitem = list.createPrivacyItem("group", 1);
            pitem.setResource(4);
            pitem.setSubject(folders[i]);
            list.addPrivacyItem(pitem);
        }
        pitem = list.createPrivacyItem(null, 2);
        pitem.setResource(4);
        list.addPrivacyItem(pitem);
    }

    public static final void blockMessageFromUsers(String[] users, PrivacyList list) throws CollaborationException {
        PrivacyItem pitem;
        for (int i = 0; i < users.length; ++i) {
            pitem = list.createPrivacyItem("jid", 2);
            pitem.setResource(4);
            pitem.setSubject(users[i]);
            list.addPrivacyItem(pitem);
        }
        pitem = list.createPrivacyItem(null, 1);
        pitem.setResource(4);
        list.addPrivacyItem(pitem);
    }

    public static final void allowMessageFromEveryOne(PrivacyList list) throws CollaborationException {
        PrivacyItem pitem = list.createPrivacyItem(null, 1);
        pitem.setResource(4);
        list.addPrivacyItem(pitem);
    }

    public static final boolean isDummyPrivacyProfile(String listName) {
        return dummyPrivProfiles.get(listName) != null;
    }

    private static final void setInvisibleToAllProfileActive(boolean active) throws CollaborationException {
        DummyPrivacyProfile dprofile = (DummyPrivacyProfile)dummyPrivProfiles.get(localizedInvisibleToAll);
        dprofile.setActive(active);
    }

    public static final void setPrevActiveProfileActive() throws CollaborationException {
        String currActivePrivList = UserAccessControl.getActivePrivacyList();
        UserAccessControl.inactivateDummyProfile();
        if (prevActivePrivList == null) {
            prevActivePrivList = localizedVisibleToAll;
        }
        UserAccessControl.setActivePrivacyList(prevActivePrivList);
        prevActivePrivList = currActivePrivList;
    }

    private static final void setVisibleToAllProfileActive(boolean active) throws CollaborationException {
        DummyPrivacyProfile dprofile = (DummyPrivacyProfile)dummyPrivProfiles.get(localizedVisibleToAll);
        dprofile.setActive(active);
    }

    private static final void setInvisibleToAllProfileDefault(boolean def) throws CollaborationException {
        DummyPrivacyProfile dprofile = (DummyPrivacyProfile)dummyPrivProfiles.get(localizedInvisibleToAll);
        dprofile.setDefault(def);
    }

    private static final void inactivateDummyProfile() {
        Iterator i = dummyPrivProfiles.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            DummyPrivacyProfile dprofile = (DummyPrivacyProfile)entry.getValue();
            if (!dprofile.isActive()) continue;
            dprofile.setActive(false);
        }
    }

    private static final void undefaultDummyProfile() {
        Iterator i = dummyPrivProfiles.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            DummyPrivacyProfile dprofile = (DummyPrivacyProfile)entry.getValue();
            if (!dprofile.isDefault()) continue;
            dprofile.setDefault(false);
        }
    }

    private static final void setVisibleToAllProfileDefault(boolean def) throws CollaborationException {
        DummyPrivacyProfile dprofile = (DummyPrivacyProfile)dummyPrivProfiles.get(localizedVisibleToAll);
        dprofile.setDefault(def);
    }

    public static final String getActivePrivacyList() throws CollaborationException {
        Iterator i = dummyPrivProfiles.keySet().iterator();
        while (i.hasNext()) {
            String listName = (String)i.next();
            if (!((DummyPrivacyProfile)dummyPrivProfiles.get(listName)).isActive()) continue;
            return listName;
        }
        String activePrivList = Manager._session.getActivePrivacyListName();
        if (activePrivList == null || activePrivList.equals("")) {
            ((DummyPrivacyProfile)dummyPrivProfiles.get(localizedVisibleToAll)).setActive(true);
            activePrivList = localizedVisibleToAll;
        } else if (activePrivList.equals(migratedPrivListName)) {
            activePrivList = localizedMigrated;
        } else if (activePrivList.equals(invisibleToAllPrivListName)) {
            activePrivList = localizedInvisibleToAll;
        }
        return activePrivList;
    }

    public static final void declineActivePrivacyList() throws CollaborationException {
        Manager._session.setActivePrivacyListName(null);
    }

    public static final String getDefaultPrivacyList() throws CollaborationException {
        if (((DummyPrivacyProfile)dummyPrivProfiles.get(localizedVisibleToAll)).isDefault()) {
            return localizedVisibleToAll;
        }
        String defaultPrivListName = Manager._session.getDefaultPrivacyListName();
        if (defaultPrivListName == null) {
            defaultPrivListName = localizedVisibleToAll;
        } else if (defaultPrivListName.equals(invisibleToAllPrivListName)) {
            defaultPrivListName = localizedInvisibleToAll;
        } else if (defaultPrivListName.equals(migratedPrivListName)) {
            defaultPrivListName = localizedMigrated;
        }
        if (dummyPrivProfiles.get(defaultPrivListName) != null) {
            ((DummyPrivacyProfile)dummyPrivProfiles.get(defaultPrivListName)).setDefault(true);
        }
        return defaultPrivListName;
    }

    public static final void declineDefaultPrivacyList() throws CollaborationException {
        Manager._session.setDefaultPrivacyListName(null);
    }

    public static final boolean isDefaultPrivacyList(String name) throws CollaborationException {
        if (name == null) {
            return false;
        }
        return name.equals(UserAccessControl.getDefaultPrivacyList());
    }

    public static final boolean isActivePrivacyList(String name) throws CollaborationException {
        if (name == null) {
            return false;
        }
        return name.equals(UserAccessControl.getActivePrivacyList());
    }

    private static final PrivacyList createInvisibleToAllPrivacyList() throws CollaborationException {
        PrivacyList invisible = Manager._session.createPrivacyList(localizedInvisibleToAll);
        PrivacyItem item = invisible.createPrivacyItem(null, 2);
        item.setResource(2);
        invisible.addPrivacyItem(item);
        return invisible;
    }

    public static Vector initPrivacyLists() throws CollaborationException {
        String pList;
        String dList;
        Vector plistNames = UserAccessControl.getAllPrivacyLists();
        if (plistNames.size() == 0) {
            UserAccessControl.setDefaultPrivacyList(localizedVisibleToAll);
            UserAccessControl.setActivePrivacyList(localizedVisibleToAll);
        }
        if (!plistNames.contains(localizedVisibleToAll)) {
            plistNames.add(localizedVisibleToAll);
        }
        if ((dList = UserAccessControl.getDefaultPrivacyList()) == null || dList.equals("")) {
            UserAccessControl.setDefaultPrivacyList(localizedVisibleToAll);
            dList = localizedVisibleToAll;
        }
        if ((pList = UserAccessControl.getActivePrivacyList()) == null || pList.equals("")) {
            UserAccessControl.setActivePrivacyList(dList);
        }
        if (!plistNames.contains(localizedInvisibleToAll)) {
            UserAccessControl.setPrivacyList(localizedInvisibleToAll, null);
            plistNames.add(localizedInvisibleToAll);
        }
        return plistNames;
    }

    static {
        visibleToAllPrivListName = "visible";
        invisibleToAllPrivListName = "invisible";
        migratedPrivListName = "migrated";
        try {
            SafeResourceBundle privacySettingBundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");
            dummyPrivProfiles = new HashMap();
            localizedVisibleToAll = privacySettingBundle.getString("Privacy_Visible");
            PrivacyList dummyPrivList = null;
            if (Manager._session != null) {
                dummyPrivList = Manager._session.createPrivacyList(visibleToAllPrivListName);
            } else {
                System.out.println("MANAGER._SESSION is NULL and not initialized");
            }
            PrivacyItem item = dummyPrivList.createPrivacyItem(null, 1);
            dummyPrivList.addPrivacyItem(item);
            dummyPrivProfiles.put(localizedVisibleToAll, new DummyPrivacyProfile(dummyPrivList, true));
            localizedInvisibleToAll = privacySettingBundle.getString("Privacy_InVisible");
            dummyPrivList = UserAccessControl.createInvisibleToAllPrivacyList();
            dummyPrivProfiles.put(localizedInvisibleToAll, new DummyPrivacyProfile(dummyPrivList, false));
            localizedMigrated = privacySettingBundle.getString("Privacy_Migrated");
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
    }

    static class DummyPrivacyProfile {
        private boolean _visible;
        private boolean _active;
        private boolean _default;
        private PrivacyList _list;

        DummyPrivacyProfile(PrivacyList list, boolean isVisible) {
            this._visible = isVisible;
            this._list = list;
        }

        boolean isVisible() {
            return this._visible;
        }

        void setActive(boolean active) {
            this._active = active;
        }

        void setDefault(boolean def) {
            this._default = def;
        }

        boolean isActive() {
            return this._active;
        }

        boolean isDefault() {
            return this._default;
        }

        PrivacyList getPrivList() {
            return this._list;
        }

        void setPrivList(PrivacyList privList) {
            this._list = privList;
        }
    }
}

