/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.TopicMessageHolder;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannel;
import java.text.Collator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public final class TopicManager
extends Manager {
    private static boolean _isTopicAlertChannelEnabled = true;
    private static LinkedList subscribedTopicIDs = new LinkedList();
    private static Hashtable topicObjectsHT = new Hashtable(10);
    private static Hashtable htTopics = new Hashtable(10);
    static SafeResourceBundle topicManagerBundle = new SafeResourceBundle("com.iplanet.im.client.manager.manager");
    public static String ID_TOPIC_ALERT_ID = topicManagerBundle.getString("Alerts");
    public static final String ID_ALERT_ID = topicManagerBundle.getString("Alerts");
    public static final String ID_LOCAL_TOPIC = "local";
    private static final Collator collator = Collator.getInstance();

    public static final void reload() {
        TopicManager.clearCache();
        TopicManager.init();
    }

    public static final void init() {
        TopicManager.getSubscribedTopicsFromServer("");
    }

    private static final void addTopics(NewsChannel[] t) {
        if (t == null) {
            return;
        }
        for (int i = 0; i < t.length; ++i) {
            TopicManager.addTopic(t[i]);
        }
    }

    private static final void addSubscribedTopics(NewsChannel[] t) {
        if (t == null) {
            return;
        }
        for (int i = 0; i < t.length; ++i) {
            TopicManager.addTopic(t[i]);
            TopicManager.insertSubscribedTopic(t[i].getDestination());
        }
    }

    public static final int getTopicCount() {
        return htTopics.size();
    }

    public static final void addTopic(NewsChannel t) {
        TopicManager.createTopicHolder(t, false);
    }

    public static final void refreshTopicHolders(NewsChannel[] t) {
        if (t == null) {
            return;
        }
        for (int n = 0; n < t.length; ++n) {
            TopicManager.refreshTopicHolder(t[n]);
        }
    }

    public static final void refreshTopicHolder(NewsChannel t) {
        if (t == null) {
            return;
        }
        TopicManager.createTopicHolder(t, true);
    }

    public static final void createTopicHolder(NewsChannel t, boolean overwrite) {
        if (!overwrite && htTopics.containsKey(t.getDestination())) {
            return;
        }
        htTopics.put(t.getDestination(), t);
        TopicMessageHolder h = new TopicMessageHolder();
        topicObjectsHT.put(t.getDestination(), h);
    }

    public static final void createAlertTopicHolder() {
        TopicMessageHolder h = new TopicMessageHolder();
        topicObjectsHT.put(ID_TOPIC_ALERT_ID, h);
    }

    public static final void refreshTopics() {
        NewsChannel[] t = TopicManager.getTopicsFromServer("");
        TopicManager.getSubscribedTopicsFromServer("");
        t = null;
    }

    public static final void clearCachedTopic(String uid) {
        htTopics.remove(uid);
    }

    public static final boolean isStoredTopic(String t) {
        return htTopics.containsKey(t);
    }

    private static void insertSubscribedTopic(String id) {
        if (id.equals(ID_TOPIC_ALERT_ID) && !subscribedTopicIDs.contains(id)) {
            subscribedTopicIDs.add(0, id);
        } else {
            boolean n = false;
            String next = null;
            Iterator i = subscribedTopicIDs.iterator();
            while (i.hasNext()) {
                String cur = (String)i.next();
                if (cur.equals(ID_TOPIC_ALERT_ID) || collator.compare(cur, id) != 0) continue;
                next = cur;
            }
            if (next != null) {
                int index = subscribedTopicIDs.indexOf(next);
                if (index != -1) {
                    subscribedTopicIDs.add(index, id);
                } else {
                    subscribedTopicIDs.add(id);
                }
            } else {
                subscribedTopicIDs.add(id);
            }
        }
    }

    public static final void addSubscribedTopic(String destination) throws CollaborationException {
        if (!subscribedTopicIDs.contains(destination)) {
            if (!destination.equals(ID_TOPIC_ALERT_ID)) {
                // empty if block
            }
            TopicManager.insertSubscribedTopic(destination);
        }
    }

    public static final void removeSubscribedTopic(String id) {
        if (subscribedTopicIDs.contains(id)) {
            NewsChannel t;
            subscribedTopicIDs.remove(id);
            if (ID_TOPIC_ALERT_ID.equals(id)) {
                iIMPropsUtil.setTopicAlertChannelEnabled(CurrentUserManager.getCurrentUserProperties(), false);
                try {
                    UserPropsManager.saveUserSettings(_personalStoreSession.getProfile(), CurrentUserManager.getCurrentUserProperties(), true);
                }
                catch (CollaborationException e) {
                    e.printStackTrace();
                }
            }
            if ((t = TopicManager.getTopic(id)) != null) {
                t.leave();
            }
        }
        TopicManager.clearTopicMessages(id);
    }

    public static final boolean isTopicSubscribed(String t) {
        return subscribedTopicIDs.contains(t);
    }

    public static final String[] getSubscribedTopicIDs() {
        String[] tsa = new String[subscribedTopicIDs.size()];
        int n = 0;
        Iterator i = subscribedTopicIDs.iterator();
        while (i.hasNext()) {
            tsa[n++] = (String)i.next();
        }
        return tsa;
    }

    public static final NewsChannel[] getTopics() {
        Vector v = Manager.getVectorFromEnumeration(htTopics.elements());
        Object[] ret = new NewsChannel[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public static final NewsChannel getTopic(String id) {
        return (NewsChannel)htTopics.get(id);
    }

    public static final String[] getTopicIds() {
        String[] ret = new String[htTopics.size() + 1];
        int i = 0;
        ret[i] = ID_TOPIC_ALERT_ID;
        Enumeration enumeration = htTopics.keys();
        while (enumeration.hasMoreElements()) {
            ret[++i] = (String)enumeration.nextElement();
        }
        return ret;
    }

    public static final void clearCache() {
        topicObjectsHT.clear();
        subscribedTopicIDs.clear();
        htTopics.clear();
    }

    public static final boolean addTopicToServer(NewsChannel t) {
        TopicManager.addTopic(t);
        return true;
    }

    public static final NewsChannel[] getTopicsFromServer(String server) {
        try {
            Collection c = _newsSession.listNewsChannels();
            NewsChannel[] topics = new NewsChannel[c.size()];
            topics = c.toArray(topics);
            TopicManager.addTopics(topics);
            return topics;
        }
        catch (CollaborationException ne) {
            ne.printStackTrace();
            return null;
        }
    }

    public static final NewsChannel[] getManagedTopics() {
        try {
            Collection c = _newsSession.listNewsChannels(30);
            NewsChannel[] topics = new NewsChannel[c.size()];
            topics = c.toArray(topics);
            return topics;
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
            return null;
        }
    }

    public static final NewsChannel[] getSubscribedTopicsFromServer(String server) {
        try {
            subscribedTopicIDs.clear();
            if (_isTopicAlertChannelEnabled) {
                TopicManager.insertSubscribedTopic(ID_TOPIC_ALERT_ID);
                TopicManager.createAlertTopicHolder();
            }
            NewsChannel[] topics = new NewsChannel[]{};
            if (_newsSession != null) {
                Collection c = _newsSession.getSubscribedNewsChannels();
                topics = new NewsChannel[c.size()];
                topics = c.toArray(topics);
                TopicManager.addSubscribedTopics(topics);
            }
            return topics;
        }
        catch (CollaborationException ne) {
            ne.printStackTrace();
            return null;
        }
    }

    public static final boolean isTopic(String id) {
        return htTopics.containsKey(id);
    }

    public static final Message getTopicMessage(String tname, String msg_id) {
        TopicMessageHolder h = (TopicMessageHolder)topicObjectsHT.get(tname);
        if (h == null) {
            return null;
        }
        int index = h.topicMsgIDs.indexOf(msg_id);
        if (index < 0) {
            return null;
        }
        return (Message)h.topicMessages.elementAt(index);
    }

    public static final String[] getTopicMessageIds(String s) {
        TopicMessageHolder h = (TopicMessageHolder)topicObjectsHT.get(s);
        if (h == null) {
            return null;
        }
        Object[] ret = new String[h.topicMsgIDs.size()];
        h.topicMsgIDs.copyInto(ret);
        return ret;
    }

    public static final Message[] getTopicMessages(String id) {
        TopicMessageHolder h = (TopicMessageHolder)topicObjectsHT.get(id);
        if (h == null) {
            return null;
        }
        TopicManager.Out("TopicManager.getTopicMessages(): Topic ID: " + id + " - h.topicMessages.size(): " + h.topicMessages.size());
        Object[] ret = new Message[h.topicMessages.size()];
        h.topicMessages.copyInto(ret);
        return ret;
    }

    public static final void addTopicMessage(String s, Message m, boolean tofront) {
        TopicManager.Out("DEBUG: TopicManager.addTopicMessage(): s: " + s);
        TopicMessageHolder h = (TopicMessageHolder)topicObjectsHT.get(s);
        if (h == null) {
            return;
        }
        if (tofront) {
            h.topicMessages.insertElementAt(m, 0);
            h.topicMsgIDs.insertElementAt(m.getMessageId(), 0);
        } else {
            h.topicMessages.addElement(m);
            h.topicMsgIDs.addElement(m.getMessageId());
        }
        h.topicMessages.trimToSize();
        h.topicMsgIDs.trimToSize();
    }

    public static final void removeTopicMessage(String s, Message m) {
        TopicMessageHolder h = (TopicMessageHolder)topicObjectsHT.get(s);
        h.topicMessages.removeElement(m);
        h.topicMsgIDs.removeElement(m.getMessageId());
    }

    public static final void clearTopicMessages(String s) {
        TopicMessageHolder h = (TopicMessageHolder)topicObjectsHT.get(s);
        h.topicMessages.removeAllElements();
        h.topicMsgIDs.removeAllElements();
    }

    private static final void deleteTopicNow(NewsChannel t) {
        try {
            t.close();
        }
        catch (CollaborationException e) {
            System.out.println((Object)e);
        }
    }

    public static final void deleteTopic(NewsChannel t) {
        TopicManager.deleteTopic(t.getDestination(), t);
    }

    public static final void deleteTopic(String id, NewsChannel t) {
        htTopics.remove(id);
        topicObjectsHT.remove(id);
        subscribedTopicIDs.remove(id);
        if (t == null) {
            return;
        }
        if (worker != null) {
            worker.addRunnable((Runnable)new DeleteTopicThread(t));
        } else {
            TopicManager.deleteTopicNow(t);
        }
    }

    public static final void setTopicAlertChannelEnabled(boolean b) {
        _isTopicAlertChannelEnabled = b;
        if (_isTopicAlertChannelEnabled) {
            if (!TopicManager.isTopic(ID_TOPIC_ALERT_ID)) {
                TopicManager.insertSubscribedTopic(ID_TOPIC_ALERT_ID);
                TopicManager.createAlertTopicHolder();
            }
        } else if (TopicManager.isTopicSubscribed(ID_TOPIC_ALERT_ID)) {
            TopicManager.removeSubscribedTopic(ID_TOPIC_ALERT_ID);
            TopicManager.deleteTopic(ID_TOPIC_ALERT_ID, null);
        }
    }

    public static final boolean isTopicAlertChannelEnabled() {
        return _isTopicAlertChannelEnabled;
    }

    static {
        TopicManager.init();
    }

    static final class DeleteTopicThread
    implements Runnable {
        private NewsChannel t;

        public DeleteTopicThread(NewsChannel t) {
            this.t = t;
        }

        public void run() {
            TopicManager.deleteTopicNow(this.t);
        }
    }
}

