/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.PlatformUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class StorageManager
extends Manager {
    public static final int MSG_TYPE_SENT = 0;
    public static final int MSG_TYPE_RECEIVED = 1;
    public static final int MSG_TYPE_STATUS = 2;
    public static final String ID_MSGTYPE_STORE = "client/store";
    private static String _userCache = "";
    private static String _cache = "";
    public static String UPDATE_DIR = "";
    private static String _messageCache = "";
    private static String _soundCache = "";
    public static String USER_CACHE;
    public static final String ID_UPDATE_DIR = "updates";
    public static final String ID_SOUNDS_DIR = "sounds";
    public static final String ID_MESSAGE_LOG_DIR = "messages";
    static final String ID_MSG_PROPS_FILE = "msg.dat";
    static final String ID_MSG_FILE = "msg.file.";
    static final String ID_MSG_SUBJ = "msg.subj.";
    static final String ID_MSG_FROM = "msg.from.";
    static final String ID_MSG_DATE = "msg.date.";
    static final String ID_TOPIC_MSG_KEY = "topic.id.";
    static final String ID_ALERT_MSG_KEY = "alert.id.";
    static final String ID_REPLY_MSG_KEY = "reply.id.";
    static final String ID_CHAT_MSG_KEY = "chat.id.";
    static final String ID_SENT_MSG_KEY = "sent.id.";
    static final String ID_STORE_MSG_KEY = "store.id.";
    static final String ID_STATUS_MSG_KEY = "status.id.";
    private static Vector newReplies;
    private static Vector removeKeyStorage;
    private static Properties storageProps;
    private static Hashtable htMsgStore;

    public static final void reload() {
        StorageManager.clearCache();
        StorageManager.init();
    }

    public static final void init() {
        try {
            StorageManager.Out("StorageManager.init()");
            newReplies = new Vector(2);
            removeKeyStorage = new Vector(2);
            htMsgStore = new Hashtable(2);
            storageProps = new Properties();
            StorageManager.initStorage(_personalStoreSession.getProfile().getEntryId());
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMessageCache() {
        return _messageCache;
    }

    public static String getUserCache() {
        return _userCache;
    }

    public static final void clearCache() {
        if (newReplies != null) {
            newReplies.removeAllElements();
        }
        if (htMsgStore != null) {
            htMsgStore.clear();
        }
        if (removeKeyStorage != null) {
            removeKeyStorage.removeAllElements();
        }
    }

    public static final boolean isNewMsg(String key) {
        return newReplies.contains(key);
    }

    public static final void removeNewMsg(String key) {
        newReplies.removeElement(key);
    }

    public static final String[] getStoreKeys() {
        return StorageManager.getKeysFromID(ID_STORE_MSG_KEY);
    }

    public static final String[] getChatKeys() {
        return StorageManager.getKeysFromID(ID_CHAT_MSG_KEY);
    }

    public static final String[] getSentKeys() {
        return StorageManager.getKeysFromID(ID_SENT_MSG_KEY);
    }

    public static final String[] getReplyKeys() {
        return StorageManager.getKeysFromID(ID_REPLY_MSG_KEY);
    }

    public static final String[] getTopicKeys() {
        return StorageManager.getKeysFromID(ID_TOPIC_MSG_KEY);
    }

    public static final String[] getAlertKeys() {
        return StorageManager.getKeysFromID(ID_ALERT_MSG_KEY);
    }

    public static final String[] getStatusKeys() {
        return StorageManager.getKeysFromID(ID_STATUS_MSG_KEY);
    }

    public static final String[] getKeysFromID(String key) {
        Vector<String> v = new Vector<String>();
        Hashtable ht = (Hashtable)htMsgStore.clone();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String tmp = (String)e.nextElement();
            String id = (String)htMsgStore.get(tmp);
            if (id == null || !id.equals(key)) continue;
            v.addElement(tmp);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public static final void removeKeys(String key) {
        storageProps.remove(ID_MSG_SUBJ + key);
        storageProps.remove(ID_MSG_FILE + key);
        storageProps.remove(ID_MSG_DATE + key);
        storageProps.remove(ID_MSG_FROM + key);
        storageProps.remove(ID_REPLY_MSG_KEY + key);
        storageProps.remove(ID_ALERT_MSG_KEY + key);
        storageProps.remove(ID_TOPIC_MSG_KEY + key);
        storageProps.remove(ID_STORE_MSG_KEY + key);
        storageProps.remove(ID_CHAT_MSG_KEY + key);
        storageProps.remove(ID_STATUS_MSG_KEY + key);
    }

    public static final void deleteMsgFromKey(String key) {
        String name = storageProps.getProperty(ID_MSG_FILE + key, "");
        StorageManager.removeKeys(key);
        File f = new File(_messageCache, name);
        if (f.exists()) {
            f.delete();
        }
        StorageManager.refreshPropKeys();
    }

    public static final Message getMsgFromKey(String key) {
        String fname = storageProps.getProperty(ID_MSG_FILE + key, "");
        Message m = (Message)EditorUtility.loadObject(new File(_messageCache, fname));
        if (m == null) {
            StorageManager.removeKeys(key);
        }
        return m;
    }

    public static final String getMsgIdSubj(String key) {
        return storageProps.getProperty(ID_MSG_SUBJ + key, "empty");
    }

    public static final String getMsgIdFrom(String key) {
        return storageProps.getProperty(ID_MSG_FROM + key, "empty");
    }

    public static final String getMsgIdDate(String key) {
        String tmp = storageProps.getProperty(ID_MSG_DATE + key, "0");
        Date d = new Date(Long.parseLong(tmp));
        return StorageManager.getTimeStampSmall(d);
    }

    public static final String getTimeStampSmall(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        StringBuffer ret = new StringBuffer();
        ret.append(c.get(2) + 1);
        ret.append("/");
        ret.append(c.get(5));
        ret.append(" ");
        if (c.get(11) > 12) {
            ret.append(c.get(11) - 12);
        } else if (c.get(11) == 0) {
            ret.append(12);
        } else {
            ret.append(c.get(11));
        }
        ret.append(":");
        if (c.get(12) < 10) {
            ret.append("0");
        }
        ret.append(c.get(12));
        return ret.toString();
    }

    public static final String getMsgIdDateRaw(String key) {
        return storageProps.getProperty(ID_MSG_DATE + key, "0");
    }

    public static final boolean isStored(String key) {
        File f = new File(_messageCache, key);
        if (!f.exists()) {
            removeKeyStorage.addElement(key);
            return false;
        }
        return true;
    }

    public static final void refreshPropKeys() {
        StorageManager.clearCache();
        String tmp = "";
        String prop = "";
        Enumeration<Object> e = storageProps.keys();
        while (e.hasMoreElements()) {
            tmp = (String)e.nextElement();
            prop = storageProps.getProperty(tmp);
            if (tmp.startsWith(ID_ALERT_MSG_KEY)) {
                if (!StorageManager.isStored(prop)) continue;
                htMsgStore.put(prop, ID_ALERT_MSG_KEY);
                continue;
            }
            if (tmp.startsWith(ID_TOPIC_MSG_KEY)) {
                if (!StorageManager.isStored(prop)) continue;
                htMsgStore.put(prop, ID_TOPIC_MSG_KEY);
                continue;
            }
            if (tmp.startsWith(ID_REPLY_MSG_KEY)) {
                if (!StorageManager.isStored(prop)) continue;
                htMsgStore.put(prop, ID_REPLY_MSG_KEY);
                continue;
            }
            if (tmp.startsWith(ID_SENT_MSG_KEY)) {
                if (!StorageManager.isStored(prop)) continue;
                htMsgStore.put(prop, ID_SENT_MSG_KEY);
                continue;
            }
            if (tmp.startsWith(ID_CHAT_MSG_KEY)) {
                if (!StorageManager.isStored(prop)) continue;
                htMsgStore.put(prop, ID_CHAT_MSG_KEY);
                continue;
            }
            if (tmp.startsWith(ID_STORE_MSG_KEY)) {
                if (!StorageManager.isStored(prop)) continue;
                htMsgStore.put(prop, ID_STORE_MSG_KEY);
                continue;
            }
            if (!tmp.startsWith(ID_STATUS_MSG_KEY) || !StorageManager.isStored(prop)) continue;
            htMsgStore.put(prop, ID_STATUS_MSG_KEY);
        }
        for (int n = 0; n < removeKeyStorage.size(); ++n) {
            StorageManager.removeKeys((String)removeKeyStorage.elementAt(n));
        }
    }

    public static String saveSoundFile(byte[] b, String name) {
        File f = new File(_soundCache, name);
        if (f.exists()) {
            f.delete();
        }
        FileUtility.save((File)f, (byte[])b);
        return f.getAbsolutePath();
    }

    public static final void storeReceivedMsgProps(String key, Message m) {
        String type = m.getContentType();
        if (type.equals("application/x-iim-poll-reply")) {
            newReplies.addElement(m.getMessageId());
            storageProps.put(ID_REPLY_MSG_KEY + key, m.getMessageId());
            storageProps.put(ID_MSG_DATE + key, Long.toString(System.currentTimeMillis()));
            storageProps.put(ID_MSG_FROM + key, m.getOriginator());
        } else if (type.equals("text/html")) {
            storageProps.put(ID_CHAT_MSG_KEY + key, m.getMessageId());
            storageProps.put(ID_MSG_DATE + key, Long.toString(System.currentTimeMillis()));
            storageProps.put(ID_MSG_FROM + key, m.getOriginator());
        } else if (type.equals(ID_MSGTYPE_STORE)) {
            storageProps.put(ID_STORE_MSG_KEY + key, m.getMessageId());
            storageProps.put(ID_MSG_DATE + key, Long.toString(System.currentTimeMillis()));
            storageProps.put(ID_MSG_FROM + key, m.getOriginator());
        } else {
            storageProps.put(ID_ALERT_MSG_KEY + key, m.getMessageId());
            storageProps.put(ID_MSG_DATE + key, Long.toString(System.currentTimeMillis()));
            storageProps.put(ID_MSG_FROM + key, m.getOriginator());
        }
    }

    public static final void saveMsgNow(Message m, int type) {
        String key = m.getMessageId();
        if (key == null) {
            Random r1 = new Random();
            Random r = new Random(r1.nextLong());
            int x = r.nextInt();
            if (x < 0) {
                x *= -1;
            }
            key = Integer.toString(x);
        }
        File f = new File(_messageCache, key);
        switch (type) {
            case 0: {
                storageProps.put(ID_MSG_FROM + key, m.getOriginator());
                storageProps.put(ID_SENT_MSG_KEY + key, key);
                storageProps.put(ID_MSG_DATE + key, Long.toString(System.currentTimeMillis()));
                break;
            }
            case 1: {
                StorageManager.storeReceivedMsgProps(key, m);
                break;
            }
            case 2: {
                storageProps.put(ID_MSG_FROM + key, m.getOriginator());
                storageProps.put(ID_STATUS_MSG_KEY + key, key);
                storageProps.put(ID_MSG_DATE + key, Long.toString(System.currentTimeMillis()));
            }
        }
        storageProps.put(ID_MSG_FILE + key, key);
        storageProps.put(ID_MSG_SUBJ + key, m.getHeader("subject"));
        EditorUtility.save(f, m.toString().getBytes());
        StorageManager.saveLocalStorageProps();
    }

    public static final void saveMsg(Message m, int type) {
        if (Manager._is_applet) {
            return;
        }
        worker.addRunnable((Runnable)new SaveMessageThread(m, type));
    }

    public static final void saveLocalStorageProps() {
        if (storageProps == null) {
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(new File(_messageCache, ID_MSG_PROPS_FILE));
            storageProps.store(out, null);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.err.println("ERROR Could not save storage properties file ");
        }
    }

    private static final void loadLocalStorageProps() {
        storageProps = new Properties();
        try {
            File f = new File(_messageCache, ID_MSG_PROPS_FILE);
            FileInputStream in = new FileInputStream(f);
            storageProps.load(in);
            in.close();
        }
        catch (Exception e) {
            System.out.println(" Storage Props file not found");
        }
    }

    private static final String createCache(String dir, String subdir, boolean clean, Date d) {
        File f = new File(dir, subdir);
        StorageManager.Out("StorageManager.createCache: f:" + f);
        if (!f.isDirectory() && !f.mkdirs()) {
            System.err.println("ERROR StorageManager: Could not create: " + dir);
            return null;
        }
        if (clean) {
            EditorUtility.clearDir(f, d);
        }
        return f.getPath();
    }

    public static final void initStorage(String uid) {
        int delete_after = iIMPropsUtil.getCacheDeleteTime(userSettings);
        long tmp = (long)delete_after * 86400L * 1000L;
        if (delete_after == 0) {
            tmp *= 1000L;
        }
        String home = userSettings.containsKey("net.user.cache") ? (String)userSettings.get("net.user.cache") : PlatformUtil.getHomeDir();
        _cache = StorageManager.createCache(home, ".sunmsgr", false, null);
        _userCache = StorageManager.createCache(_cache, EditorUtility.formatLongString(uid), true, null);
        USER_CACHE = _messageCache = StorageManager.createCache(_userCache, ID_MESSAGE_LOG_DIR, true, null);
        _soundCache = StorageManager.createCache(_userCache, ID_SOUNDS_DIR, false, null);
    }

    static {
        StorageManager.init();
    }

    static final class SaveMessageThread
    implements Runnable {
        private Message m;
        private int type = 0;

        public SaveMessageThread(Message m, int type) {
            this.m = m;
            this.type = type;
        }

        public final void run() {
            StorageManager.saveMsgNow(this.m, this.type);
        }
    }
}

