/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserCache;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGroup;
import com.sun.im.service.PersonalStoreEntry;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class ServerGroupManager
extends Manager {
    private static Hashtable _htServerGroup = new Hashtable();
    public static final String ID_SERVER_GROUP_PREFIX = "g:";

    public static void reload() {
        ServerGroupManager.clearCache();
    }

    public static final void clearCache() {
        _htServerGroup.clear();
    }

    public static final void refreshStorageFromServer() {
    }

    public static final String[] getServerList() {
        String[] servers = new String[]{CurrentUserManager.getCurrentUserServer()};
        return servers;
    }

    public static final boolean isMember(PersonalContact nu, PersonalGroup ng) {
        try {
            CollaborationPrincipal prin = Manager._session.createPrincipal(nu.getEntryId());
            return ng.expand().contains(prin);
        }
        catch (CollaborationException ne) {
            System.out.println(ne.getMessage());
            return false;
        }
    }

    public static final boolean isMember(String uid, String group) {
        try {
            CollaborationPrincipal prin = UserCache.getPrincipal(uid);
            PersonalGroup ng = (PersonalGroup)Manager._personalStoreSession.getEntry("group", group);
            if (ng == null) {
                return false;
            }
            return ng.expand().contains(prin);
        }
        catch (CollaborationException ne) {
            System.out.println(ne.getMessage());
            return false;
        }
    }

    public static String formatGroupID(String id) {
        if (id.startsWith(ID_SERVER_GROUP_PREFIX)) {
            id = id.substring(ID_SERVER_GROUP_PREFIX.length());
        }
        return id;
    }

    public static final PersonalContact[] getUsersInGroupFromServer(PersonalGroup ng) {
        return ServerGroupManager.getUsersInGroupFromServer(ng.getEntryId());
    }

    public static final PersonalContact[] getUsersInGroupFromServer(String uid) {
        uid = ServerGroupManager.formatGroupID(uid);
        try {
            PersonalGroup ng = (PersonalGroup)Manager._personalStoreSession.getEntry("group", uid);
            Collection c = ng.expand();
            PersonalContact[] nu = new PersonalContact[c.size()];
            CollaborationPrincipal[] principal = new CollaborationPrincipal[c.size()];
            int j = 0;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                nu[j] = (PersonalContact)i.next();
                principal[j] = UserCache.getPrincipal(nu[j].getAddress("im"));
                ++j;
            }
            UserCache.addPrincipalToCache(principal);
            return nu;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public static final CollaborationPrincipal[] getCollaborationPrincipalsInGroupFromServer(String uid) {
        uid = ServerGroupManager.formatGroupID(uid);
        try {
            PersonalStoreEntry[] pses;
            PersonalGroup ng = (PersonalGroup)Manager._personalStoreSession.getEntry("group", uid);
            if (ng == null && (pses = Manager._personalStoreSession.search(0, uid, "group")) != null && pses.length == 1) {
                ng = (PersonalGroup)pses[0];
            }
            if (ng == null) {
                return null;
            }
            Collection c = ng.expand();
            CollaborationPrincipal[] principal = c.toArray(new CollaborationPrincipal[c.size()]);
            UserCache.addPrincipalToCache(principal);
            return principal;
        }
        catch (Exception e) {
            e.printStackTrace();
            ServerGroupManager.Out(e);
            return null;
        }
    }

    public static final PersonalContact[] getUsersInGroup(String uid) {
        return ServerGroupManager.getUsersInGroup(uid, uid.substring(uid.indexOf("@") + 1));
    }

    public static final PersonalContact[] getUsersInGroup(PersonalGroup group) {
        return ServerGroupManager.getUsersInGroup(group.getEntryId(), null);
    }

    public static final PersonalContact[] getUsersInGroup(String uid, String server) {
        uid = ServerGroupManager.formatGroupID(uid);
        ServerGroupManager.Out("ServerGroupManager.getUsersInGroup(): uid: >" + uid + "< - server: >" + server + "<");
        return (PersonalContact[])_htServerGroup.get(uid);
    }
}

