/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.swing.communicator.RoomListPanel;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.PersonalConference;
import com.sun.im.service.PersonalStoreEntry;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class RoomManager
extends Manager {
    private static Hashtable htRooms = new Hashtable(5);
    private static LinkedList _deleted = new LinkedList();
    private static LinkedList _autoInvite = new LinkedList();
    private static Hashtable htParticipants = new Hashtable();
    private static long lastParticipantUpdationTime;
    private static LinkedList _autoJoin;

    public static void addAutoInvite(List l) {
        _autoInvite.add(l);
    }

    public static List getAutoInvite() {
        return _autoInvite;
    }

    public static void addAutoJoin(String uid) {
        _autoJoin.add(uid);
    }

    public static List getAutoJoin() {
        return _autoJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshRooms() {
        Hashtable hashtable = htRooms;
        synchronized (hashtable) {
            try {
                Collection c = _personalStoreSession.getEntries("conference");
                Conference[] rooms = new Conference[c.size()];
                int j = 0;
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    PersonalConference pc = (PersonalConference)i.next();
                    rooms[j] = _conferenceSession.getPublicConference(pc.getAddress());
                    if (rooms[j] == null && !_deleted.contains(pc.getAddress())) {
                        _deleted.add(pc.getAddress());
                    }
                    ++j;
                }
                htRooms.clear();
                RoomManager.addRooms(rooms);
                RoomManager.refreshRoomParticipants(true);
            }
            catch (CollaborationException ne) {
                ne.printStackTrace();
                Manager.debug("refreshRooms:" + ne.getMessage());
            }
        }
    }

    public static Conference getRoom(String id) {
        return (Conference)htRooms.get(id);
    }

    public static Conference createConferenceRoom(String name, int access, ConferenceListener listener) throws Exception {
        return RoomManager.createConferenceRoomAndUpdate(name, access, listener, null);
    }

    public static Conference createConferenceRoomAndUpdate(String name, int access, ConferenceListener listener, RoomListPanel panel) throws Exception {
        if (htRooms.containsKey(name)) {
            throw new Exception("Room name already in use");
        }
        Conference c = _conferenceSession.setupPublicConference(name, listener, access);
        RoomManager.subscribe(c);
        if (panel != null) {
            RoomManager.refreshRooms();
            panel.refresh();
        }
        return c;
    }

    public static Conference createPrivateRoom(ConferenceListener l) {
        try {
            Conference c = _conferenceSession.setupConference(l, 30);
            Manager.Out("[RoomManager] Added Room: " + c.getDestination());
            return c;
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
            return null;
        }
    }

    private static void addRooms(Conference[] r) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.length; ++i) {
            if (r[i] == null) continue;
            RoomManager.addRoom(r[i]);
        }
    }

    private static void addRoom(Conference r) {
        htRooms.put(r.getDestination(), r);
    }

    public static void clearCache() {
        htRooms.clear();
    }

    public static Conference[] getRoomsFromServer(String server) {
        Conference[] conf = RoomManager.searchRooms("*", 0);
        RoomManager.addRooms(conf);
        return conf;
    }

    public static boolean roomExists(String str) {
        try {
            return _conferenceSession.getPublicConference(str) != null;
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
            return false;
        }
    }

    public static Conference[] searchRooms(String filter, int search_type) {
        Manager.Out("[RoomManager] searchRooms, filter: " + filter);
        try {
            PersonalStoreEntry[] pse = _personalStoreSession.search(search_type, filter, "conference");
            if (pse == null) {
                return null;
            }
            Conference[] c = new Conference[pse.length];
            for (int i = 0; i < pse.length; ++i) {
                c[i] = _conferenceSession.getPublicConference(pse[i].getEntryId());
            }
            return c;
        }
        catch (CollaborationException ne) {
            System.out.println("[RoomManager] searchRooms:" + ne.getMessage());
            return null;
        }
    }

    public static Conference[] getManagedRooms(String filter) {
        Manager.Out("[RoomManager] getManagedRooms, filter: " + filter);
        Conference[] all = RoomManager.searchRooms("*", 0);
        if (all == null) {
            return null;
        }
        Vector<Conference> managedRooms = new Vector<Conference>();
        for (int i = 0; i < all.length; ++i) {
            if (!UserAccessControl.hasPrivilege(all[i], 30)) continue;
            managedRooms.add(all[i]);
        }
        Conference[] ret = new Conference[managedRooms.size()];
        for (int i = 0; i < managedRooms.size(); ++i) {
            ret[i] = (Conference)managedRooms.get(i);
        }
        return ret;
    }

    public static Vector getFavorites() {
        return Manager.getVectorFromEnumeration(htRooms.elements());
    }

    public static boolean isLikelyPrivate(Conference r) {
        return !r.isPublic();
    }

    public static void deleteRoomNow(Conference c) {
        htRooms.remove(c.getDestination());
        try {
            c.close();
        }
        catch (CollaborationException e) {
            System.out.println("deleteRoomNow:" + (Object)((Object)e));
        }
    }

    public static void deleteManagedRoom(Conference r) {
        if (worker != null) {
            worker.addRunnable((Runnable)new DeleteRoomThread(r));
        } else {
            RoomManager.deleteRoomNow(r);
        }
    }

    public static void refreshRoomParticipants(boolean ignoreTime) {
        if (!ignoreTime && System.currentTimeMillis() - lastParticipantUpdationTime < 120000L) {
            return;
        }
        htParticipants.clear();
        Iterator itr = htRooms.values().iterator();
        while (itr.hasNext()) {
            int size;
            Conference c = (Conference)itr.next();
            try {
                size = c.getParticipants().size();
            }
            catch (CollaborationException e) {
                continue;
            }
            htParticipants.put(c.getDestination(), new Integer(size));
        }
        lastParticipantUpdationTime = System.currentTimeMillis();
    }

    public static int getParticipants(String conf) {
        try {
            Integer i = (Integer)htParticipants.get(conf);
            return i;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void subscribe(Conference conf) throws CollaborationException {
        PersonalConference pc = (PersonalConference)_personalStoreSession.createEntry("conference", conf.getDestination());
        pc.setAddress(conf.getDestination());
        pc.save();
        RoomManager.addRoom(conf);
    }

    public static void unsubscribe(Conference conf) throws CollaborationException {
        htRooms.remove(conf);
        PersonalStoreEntry pc = _personalStoreSession.getEntry("conference", conf.getDestination());
        if (pc != null) {
            pc.remove();
        }
    }

    static {
        _autoJoin = new LinkedList();
        RoomManager.clearCache();
    }

    static class DeleteRoomThread
    implements Runnable {
        private Conference r;

        public DeleteRoomThread(Conference r) {
            this.r = r;
        }

        public void run() {
            RoomManager.deleteRoomNow(this.r);
        }
    }
}

