/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.jni.JNILink;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.EmoticonsManager;
import com.iplanet.im.client.manager.MBeanManager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.manager.StorageManager;
import com.iplanet.im.client.manager.TopicManager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.manager.WebStartManager;
import com.iplanet.im.client.swing.archive.ArchiveBean;
import com.iplanet.im.client.util.BrowserLauncher;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SoundUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.ConferenceService;
import com.sun.im.service.NewsService;
import com.sun.im.service.NotificationService;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreService;
import com.sun.im.service.PresenceService;
import com.sun.im.service.StreamingService;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.util.Worker;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Manager {
    public static CollaborationSession _session = null;
    public static PresenceService _presenceSession = null;
    public static NewsService _newsSession = null;
    public static NotificationService _messageSession = null;
    public static PersonalStoreService _personalStoreSession = null;
    public static ConferenceService _conferenceSession = null;
    public static StreamingService _streamingService = null;
    public static Properties userSettings;
    public static Worker worker;
    public static Properties NetLertProperties;
    public static boolean INIT_CALLED;
    public static final int TOPIC = 0;
    public static final int ALERT = 1;
    public static final int ROOM = 2;
    public static final int CHAT = 3;
    public static final int TIMED_TOPIC = 4;
    public static final int TIMED_ALERT = 5;
    public static final int VIEW = 6;
    public static final int MSG_FORWARD = 7;
    public static final int WHITEBOARD = 8;
    public static final int BOT_ALERT = 9;
    public static boolean MODERATED_FEATURE;
    public static final String MODERATED_NOTE = "MODERATED";
    public static int MAX_MODERATED_TABLE_ITEMS;
    public static boolean SHOW_POSTED_USER;
    public static boolean TRY_LDAP_LOGIN;
    public static boolean ALLOW_ALERT_ONLY;
    public static boolean _is_applet;
    public static boolean _is_portal_env;
    public static boolean _is_portal_secure;
    public static boolean _use_ssl;
    public static boolean _register;
    public static boolean _use_ssl_optional;
    public static boolean _archive_control;
    public static String _server;
    public static String _resource;
    public static String _uid;
    public static String _domain;
    public static String _token;
    private static CollaborationSessionFactory _CollabFactory;
    private static int _priority;
    public static String contactFontName;
    public static int contactFontSize;
    public static Color contactFontColor;
    public static Color contactBackColor;
    public static boolean SHOW_ONLY_OFFLINE;
    public static boolean SHOW_PENDING_CONTACTS;
    public static int CHAT_VIEW_BUFFER;
    public static boolean AUTO_EXECUTE;
    public static int NUM_WORKER_THREADS;
    public static String _propFileName;
    public static boolean _disable_auto_logon;
    public static boolean _auto_logon;
    public static String gateway_url;
    public static Applet _applet;
    public static final String ATTACHMENT_KEY = "attachment:///";
    public static final int UNKNOWNHOST_EXCEPTION = 1;
    public static final int AUTH_EXCEPTION = 2;
    public static final int NET_EXCEPTION = 3;
    public static final int IO_EXCEPTION = 4;
    public static final int UNKNOWN_EXCEPTION = 5;
    public static final String START_MACRO = "${attr:";
    public static final String END_MACRO = "}";
    public static final String DISPLAYNAME_MACRO = "{displayname}";
    public static final String DOMAINNAME_MACRO = "{domainname}";
    public static final String STATUS_MACRO = "{status}";
    public static final String PASS = "net.password";
    public static final String NMS = "net.nms";
    public static final String RESOURCE = "net.resource";
    public static final String USER = "net.user";
    public static final String USE_SSL = "net.use.ssl";
    public static final String USER_ENV_VAR = "net.user.property";
    public static final String SHOW_INVISIBLE_INFO_DIALOG = "net.infodialog.property";
    public static final String ID_USER_CACHE = "net.user.cache";
    public static String PRIORITY_TEXT;
    public static String PRIORITY_VALUE;
    public static String PRIORITY_DEFAULT;
    public static final String PARAM_SERVER = "server";
    public static final String PARAM_RESOURCE = "resource";
    public static final String PARAM_PRIORITY = "priority";
    public static final String PARAM_REGISTER = "register";
    public static final String PARAM_DEBUG = "debug";
    public static final String PARAM_UID = "uid";
    public static final String PARAM_DOMAIN = "domain";
    public static final String PARAM_TOKEN = "token";
    public static final String PARAM_SECURE = "secure";
    public static final String PARAM_HELP_CODEBASE = "help_codebase";
    public static final String PARAM_USESSL = "usessl";
    public static final String PARAM_MAX_TABLE_ITEMS = "modchat_maxtableitems";
    public static final String PARAM_LOGCONFIG = "logconfig";
    public static final String PARAM_POSTED_USER = "modchat_showpostuser";
    public static final String PARAM_TRY_LDAP = "try_ldap_login";
    public static final String PARAM_ALLOW_ALERT_ONLY = "allow_alert_only";
    public static final String PARAM_MBEAN = "mbean";
    public static final String PARAM_FLAVOR = "flavor";
    public static final String PARAM_ARCHIVE_CONTROL = "archive_control";
    public static final String PARAM_CALREMINDER = "calendar_alert";
    public static final String PARAM_AUTOINVITE = "autoinvite";
    public static final String PARAM_AUTOJOIN = "autojoin";
    public static final String PARAM_LOCALE = "locale";
    public static final String PARAM_FORCE_ORIENTATION = "force_orientation";
    public static final String PARAM_GATEWAY_URL = "gateway_url";
    public static final String ORIENTATION_RTL = "rtl";
    public static final String ORIENTATION_LTR = "ltr";
    public static final String APPLET_PARAMETER_FILENAME = "parameters.properties";
    public static final String PARAM_MODERATED_CHAT = "modchat_enable";
    public static final String PARAM_ALLOW_ATTACHMENTS = "allow_attachments";
    public static boolean ALLOW_PRESENCE_ACCESS;
    public static boolean ALLOW_PRESENCE_CHANGES;
    public static boolean ALLOW_PRESENCE_PUBLISH;
    public static boolean ALLOW_SETTINGS_CHANGES;
    public static boolean ALLOW_CHAT;
    public static boolean ALLOW_ROOM_ACCESS;
    public static boolean ALLOW_ROOM_MANAGEMENT;
    public static boolean ALLOW_MODERATE;
    public static boolean ALLOW_SEND_ALERTS;
    public static boolean ALLOW_RECEIVE_ALERTS;
    public static boolean ALLOW_NEWS_ACCESS;
    public static boolean ALLOW_NEWS_MANAGEMENT;
    public static boolean ALLOW_ATTACHMENTS;
    public static boolean ALLOW_POLLS;
    public static boolean ALLOW_RECEIVE_POLLS;
    public static boolean ALLOW_CONTACT_MANAGEMENT;
    public static boolean ALLOW_INVITE_OTHERS;
    public static final String DEBUG_ALL = "ALL";
    public static final String DEBUG_API = "API";
    public static final String DEBUG_XMPPTRAFIC = "XMPPTRAFFIC";
    public static final String DEBUG_CLIENT = "CLIENT";
    public static final String FLAVOR_TAG_ALL = "ALL";
    public static final String FLAVOR_TAG_IM = "IM";
    public static final String FLAVOR_TAG_NEWS = "NEWS";
    public static final String FLAVOR_TAG_POPUP = "POPUP";
    public static final String FLAVOR_TAG_CHAT = "CHAT";
    public static final String FLAVOR_TAG_POLL = "POLL";
    public static final int FLAVOR_DEFAULT = 0;
    public static final int FLAVOR_IM = 1;
    public static final int FLAVOR_NEWS = 2;
    public static final int FLAVOR_POPUP = 3;
    public static final int FLAVOR_CHAT = 4;
    public static final int FLAVOR_POLL = 5;
    public static int flavor;
    public static boolean SERVER_ARCHIVE_ENABLED;
    static final String[][] policyPairs;
    public static final String LOCAL_CACHE_DIR = ".sunmsgr";
    private static Logger logger;
    static long tMemory;
    static long fMemory;
    private static boolean beansAlreadyAdded;

    public static void initFlavor(String flavor) {
        Manager.Out("INIT flavor:" + flavor);
        if (flavor.equalsIgnoreCase(FLAVOR_TAG_IM)) {
            Manager.flavor = 1;
        } else if (flavor.equalsIgnoreCase(FLAVOR_TAG_NEWS)) {
            Manager.flavor = 2;
        } else if (flavor.equalsIgnoreCase("ALL")) {
            Manager.flavor = 0;
        } else if (flavor.equalsIgnoreCase(FLAVOR_TAG_CHAT)) {
            Manager.flavor = 4;
        } else if (flavor.equalsIgnoreCase(FLAVOR_TAG_POPUP)) {
            Manager.flavor = 3;
            ALLOW_ALERT_ONLY = true;
        } else if (flavor.equalsIgnoreCase(FLAVOR_TAG_POLL)) {
            Manager.flavor = 5;
        } else {
            System.err.println("Unsupported flavor: " + flavor);
        }
    }

    public static final synchronized void initManager() throws Exception {
        if (worker == null) {
            worker = new Worker(NUM_WORKER_THREADS);
        }
        if (_is_applet) {
            JNILink.USE_WIN_JNI = false;
        }
        if (_CollabFactory != null) {
            _CollabFactory.close();
        }
        if (_use_ssl) {
            Manager.Out("CONNECT SOCKET SSL");
            _CollabFactory = new CollaborationSessionFactory("com.sun.im.service.xmpp.XMPPSecureSessionProvider");
        } else {
            _CollabFactory = new CollaborationSessionFactory();
        }
    }

    public static final String getParameter(String key, String def) {
        String value = null;
        value = _is_applet && _applet != null ? _applet.getParameter(key) : WebStartManager.getParameter(key);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public static final void openLink(String link) {
        Manager.openLink(link, "_blank");
    }

    public static final void openLink(String link, String target) {
        boolean showDialog = false;
        try {
            if (gateway_url != null) {
                link = gateway_url + "/redirect/" + link;
            }
            Manager.Out("Manager.openLink(): " + link);
            if (_is_applet) {
                URL u = new URL(link);
                _applet.getAppletContext().showDocument(u, target);
            } else if (!WebStartManager.showURL(link)) {
                if (!PlatformUtil.isMac()) {
                    BrowserLauncher.openURL(link, target);
                } else {
                    showDialog = true;
                }
            }
        }
        catch (IOException ioe) {
            showDialog = true;
        }
    }

    public static final boolean isAttachment(String u) {
        return u.indexOf(ATTACHMENT_KEY) >= 0;
    }

    public static void createLogger() {
        logger = LogManager.getLogger((String)"com.sun.im.desktop");
    }

    public static final boolean debugEnabled() {
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Logger l = (Logger)e.nextElement();
            if (l.getEffectiveLevel() != Level.DEBUG || !l.getName().startsWith("com.sun.im")) continue;
            return true;
        }
        return false;
    }

    public static final String[] getLogFiles() {
        Enumeration e = LogManager.getCurrentLoggers();
        HashSet<String> hs = new HashSet<String>();
        while (e.hasMoreElements()) {
            Logger l = (Logger)e.nextElement();
            if (!l.getName().startsWith("com.sun.im")) continue;
            Enumeration e1 = l.getAllAppenders();
            while (e1.hasMoreElements()) {
                Appender a = (Appender)e1.nextElement();
                if (!(a instanceof FileAppender)) continue;
                hs.add(((FileAppender)a).getFile().toString());
            }
        }
        return hs.toArray(new String[hs.size()]);
    }

    public static final void Out(String a, boolean show_stamp) {
        Manager.Out(a);
    }

    public static void Out(Object o) {
        String line = null;
        try {
            Throwable t = new Throwable();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            String input = sw.getBuffer().toString();
            StringReader sr = new StringReader(input);
            BufferedReader br = new BufferedReader(sr);
            br.readLine();
            br.readLine();
            line = br.readLine();
            int paren = line.indexOf(40);
            line = line.substring(0, paren);
            int period = line.lastIndexOf(32);
            line = line.substring(period + 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.debug((Object)("[" + line + "]" + o.toString()));
    }

    public static void debug(String msg) {
        logger.debug((Object)msg);
    }

    public static void notice(String msg) {
        logger.info((Object)msg);
    }

    public static void error(String msg) {
        logger.error((Object)msg);
    }

    public static void fatal(String msg) {
        logger.fatal((Object)msg);
    }

    public static void warning(String msg) {
        logger.warn((Object)msg);
    }

    public static void info(String msg) {
        logger.info((Object)msg);
    }

    public static final String getStackTrace() {
        try {
            Throwable t = new Throwable();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            return sw.getBuffer().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void clearCache() {
        UserStatusManager.clearCache();
        MBeanManager.cleanup();
        UserCache.clearCache();
        RoomManager.clearCache();
        TopicManager.clearCache();
        BuddyListManager.clear();
        ServerGroupManager.clearCache();
    }

    public static void reloadManager() {
        TopicManager.reload();
        UserStatusManager.clearCache();
        RoomManager.clearCache();
        UserCache.clearCache();
        UserStatusManager.reload(true);
        ServerGroupManager.reload();
        StorageManager.reload();
        EmoticonsManager.reload();
    }

    public static final void saveAllPropertiesToServer(boolean thread, boolean merge) {
        Manager.Out("saveUserSettings()");
        Properties p = null;
        if (userSettings != null) {
            p = (Properties)userSettings.clone();
        }
        if (p != null) {
            BuddyListManager.saveBuddyListGroups(p);
        }
        Manager.Out(p + "\n");
        try {
            Manager.Out("Thread = " + thread);
            if (_personalStoreSession != null) {
                if (thread) {
                    UserPropsManager.saveUserSettings(_personalStoreSession.getProfile(), p, merge);
                } else {
                    UserPropsManager.saveUserSettingsNow(_personalStoreSession.getProfile(), p, merge);
                }
            }
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
        }
    }

    public static final void printMemoryProfile(String out) {
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = total - free;
        System.out.println();
        System.out.println(out);
        System.out.println("***********************");
        System.out.println("FREE CHANGE:    " + (free - fMemory) / 1000L + "    <> " + (free - fMemory));
        System.out.println("TOTAL CHANGE:   " + (total - tMemory) / 1000L + "    <> " + (total - tMemory));
        System.out.println("USED CHANGE:    " + (tMemory - fMemory - used) / 1000L + "    <> " + (used - (tMemory - fMemory)));
        System.out.println();
        System.out.println("FREE MEMORY:    " + free / 1000L + "    <> " + free);
        System.out.println("TOTAL MEMORY:   " + total / 1000L + "    <> " + total);
        System.out.println("USED MEMORY:    " + used / 1000L + "    <> " + used);
        System.out.println("***********************\n");
        tMemory = total;
        fMemory = free;
    }

    public static final Vector getVectorFromEnumeration(Enumeration e) {
        Vector ret = new Vector();
        if (e == null) {
            return ret;
        }
        while (e.hasMoreElements()) {
            ret.addElement(e.nextElement());
        }
        return ret;
    }

    public static final Vector getVectorFromArray(Object[] o) {
        if (o == null) {
            return new Vector();
        }
        Vector<Object> ret = new Vector<Object>(o.length);
        for (int n = 0; n < o.length; ++n) {
            ret.addElement(o[n]);
        }
        ret.trimToSize();
        return ret;
    }

    public static final PersonalStoreEntry[] getUserArrayFromVector(Vector v) {
        if (v == null) {
            return null;
        }
        PersonalStoreEntry[] u = new PersonalStoreEntry[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            u[n] = (PersonalStoreEntry)v.elementAt(n);
        }
        return u;
    }

    public static final CollaborationPrincipal[] getPrincipalArrayFromVector(Vector v) {
        if (v == null) {
            return null;
        }
        CollaborationPrincipal[] cp = new CollaborationPrincipal[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            cp[n] = (CollaborationPrincipal)v.elementAt(n);
        }
        return cp;
    }

    public static CollaborationSessionFactory getCollaborationSessionFactory() {
        return _CollabFactory;
    }

    public static String getValidDestinationName(String name) {
        name = name.replace('/', '_');
        name = name.replace('\\', '_');
        name = name.replace('@', '_');
        name = name.replace(':', '_');
        name = name.replace('=', '-');
        name = name.replace(',', '_');
        return name;
    }

    public static final Point getValidPoint(Frame f, Point pFrame) {
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dFrame = f.getSize();
        Point pNew = new Point(0, 0);
        pNew.x = pFrame.x + dFrame.width > dScreen.width || pFrame.x < 0 ? 40 : pFrame.x;
        pNew.y = pFrame.y + dFrame.height > dScreen.height || pFrame.y < 0 ? 40 : pFrame.y;
        return pNew;
    }

    public static final Dimension getValidSize(Frame f, int w, int h) {
        Dimension dFrame = f.getSize();
        Dimension dNew = new Dimension(w, h);
        if (w > 1400) {
            dNew.width = 400;
        }
        if (h > 1400) {
            dNew.height = 400;
        }
        return dNew;
    }

    static final void printArray(Object[] o) {
        for (int n = 0; n < o.length; ++n) {
            System.out.println(o[n]);
        }
    }

    public static void login(CollaborationSessionListener listener) throws Exception {
        String res;
        Manager.Out("Use SSL = " + _use_ssl);
        String user = (String)NetLertProperties.get(USER);
        user = StringUtility.quoteSpecialCharacters((String)user);
        if (_domain != null && _domain.length() > 0) {
            user = StringUtility.appendDomainToAddress((String)user, (String)_domain);
        }
        if ((res = (String)NetLertProperties.get(RESOURCE)) != null && res.length() > 0) {
            user = user + "/" + res;
        }
        Manager.Out("User = " + user);
        _session = _CollabFactory.getSession((String)NetLertProperties.get(NMS), user, (String)NetLertProperties.get(PASS), listener);
        _presenceSession = _session.getPresenceService();
        _newsSession = _session.getNewsService();
        _conferenceSession = _session.getConferenceService();
        _messageSession = _session.getNotificationService();
        _personalStoreSession = _session.getPersonalStoreService();
        _streamingService = _session.getStreamingService();
        CurrentUserManager.initPolicyAttributes(policyPairs);
        userSettings = UserPropsManager.loadUserProperties(CurrentUserManager.getCurrentProfile());
        if (userSettings == null) {
            userSettings = new Properties();
        }
        CurrentUserManager.readPolicy();
        if (!SERVER_ARCHIVE_ENABLED) {
            _archive_control = false;
        }
        if (_archive_control && !beansAlreadyAdded) {
            MBeanManager.addFactory(new ArchiveBean());
            beansAlreadyAdded = true;
        }
    }

    public static void login() throws Exception {
        Manager.login(null);
    }

    public static boolean isConnected() {
        return true;
    }

    public static boolean isFileLaunchable(String filename) {
        if (PlatformUtil.isWin() && JNILink.USE_WIN_JNI) {
            return true;
        }
        String lcFilename = filename.toLowerCase();
        return lcFilename.endsWith(".html") || lcFilename.endsWith(".htm") || lcFilename.endsWith(".au") || lcFilename.endsWith(".wav") || lcFilename.endsWith(".jpg") || lcFilename.endsWith(".jpeg") || lcFilename.endsWith(".gif");
    }

    public static final void launchFile(String filename, byte[] content) throws Exception {
        String tempDir = System.getProperty("java.io.tmpdir", StorageManager.USER_CACHE);
        if (PlatformUtil.isWin() && JNILink.USE_WIN_JNI) {
            Manager.Out("Manager.launchFile(): tempDir: " + tempDir);
            File f = new File(tempDir, filename);
            FileUtility.save((String)f.toString(), (byte[])content);
            int rc = JNILink.executeWinApp(f.toString());
            if (rc != 0) {
                throw new Exception("Failed to open " + filename + " - status=" + rc);
            }
        } else {
            String absFilename = tempDir + File.separator + filename;
            File file = new File(absFilename);
            FileUtility.save((File)file, (byte[])content);
            String lcFilename = filename.toLowerCase();
            if (lcFilename.endsWith(".au") || lcFilename.endsWith(".wav")) {
                SoundUtility.play(absFilename);
            } else if (lcFilename.endsWith(".html") || lcFilename.endsWith(".htm") || lcFilename.endsWith(".gif") || lcFilename.endsWith(".jpg") || lcFilename.endsWith(".jpeg")) {
                Manager.openLink(file.toURL().toString());
            }
        }
    }

    public static final void launchFile(File f) throws Exception {
        if (PlatformUtil.isWin() && JNILink.USE_WIN_JNI) {
            Manager.Out("Manager.launchFile(): file: " + f.toString());
            int rc = JNILink.executeWinApp(f.toString());
            if (rc != 0) {
                throw new Exception("Failed to open " + f.toString() + " - status=" + rc);
            }
        } else {
            String lcFilename = f.getName().toLowerCase();
            if (lcFilename.endsWith(".au") || lcFilename.endsWith(".wav")) {
                SoundUtility.play(f.getAbsolutePath());
            } else if (lcFilename.endsWith(".html") || lcFilename.endsWith(".htm") || lcFilename.endsWith(".gif") || lcFilename.endsWith(".jpg") || lcFilename.endsWith(".jpeg")) {
                Manager.openLink(f.toURL().toString());
            }
        }
    }

    public static void exit(int status) {
        if (!_is_applet) {
            try {
                System.exit(status);
            }
            catch (Exception exception) {}
        } else {
            _applet.setVisible(false);
        }
    }

    public static List getPriorityList() {
        SafeResourceBundle loginDialogBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");
        int i = 0;
        String txt = loginDialogBundle.getString(PRIORITY_TEXT + Integer.toString(i));
        ArrayList<String> list = new ArrayList<String>();
        while (!"".equals(txt)) {
            list.add(txt);
            txt = loginDialogBundle.getString(PRIORITY_TEXT + Integer.toString(++i));
        }
        return list;
    }

    public static int getPriorityValue(int location) {
        SafeResourceBundle loginDialogBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");
        String val = loginDialogBundle.getString(PRIORITY_VALUE + Integer.toString(location));
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static String getPriorityString(int value) {
        SafeResourceBundle loginDialogBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");
        int i = 0;
        String val = loginDialogBundle.getString(PRIORITY_VALUE + Integer.toString(i));
        ArrayList list = new ArrayList();
        while (!"".equals(val)) {
            try {
                if (Integer.parseInt(val) == value) {
                    return loginDialogBundle.getString(PRIORITY_TEXT + Integer.toString(i));
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            val = loginDialogBundle.getString(PRIORITY_VALUE + Integer.toString(++i));
        }
        return loginDialogBundle.getString(PRIORITY_VALUE + Integer.toString(0));
    }

    public static String getDefaultPriorityString() {
        SafeResourceBundle loginDialogBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");
        String val = loginDialogBundle.getString(PRIORITY_DEFAULT);
        val = loginDialogBundle.getString(PRIORITY_TEXT + val);
        return val;
    }

    public static void setSessionPriority(int priority) {
        _priority = priority;
    }

    public static int getSessionPriority() {
        return _priority;
    }

    static {
        worker = null;
        NetLertProperties = new Properties();
        INIT_CALLED = false;
        MODERATED_FEATURE = true;
        MAX_MODERATED_TABLE_ITEMS = 100;
        SHOW_POSTED_USER = true;
        TRY_LDAP_LOGIN = false;
        ALLOW_ALERT_ONLY = false;
        _is_applet = true;
        _is_portal_env = false;
        _is_portal_secure = false;
        _use_ssl = false;
        _register = false;
        _use_ssl_optional = false;
        _archive_control = false;
        _server = null;
        _resource = null;
        _uid = null;
        _domain = null;
        _token = null;
        _priority = -1;
        contactFontName = "SansSerif";
        contactFontSize = 12;
        contactFontColor = Color.black;
        contactBackColor = Color.white;
        SHOW_ONLY_OFFLINE = true;
        SHOW_PENDING_CONTACTS = true;
        CHAT_VIEW_BUFFER = 15000;
        AUTO_EXECUTE = false;
        NUM_WORKER_THREADS = 2;
        _propFileName = "messenger.properties";
        _disable_auto_logon = false;
        _auto_logon = false;
        gateway_url = null;
        _applet = null;
        PRIORITY_TEXT = "LoginDialog_priority_text";
        PRIORITY_VALUE = "LoginDialog_priority_value";
        PRIORITY_DEFAULT = "LoginDialog_priority_default_index";
        ALLOW_PRESENCE_ACCESS = true;
        ALLOW_PRESENCE_CHANGES = true;
        ALLOW_PRESENCE_PUBLISH = true;
        ALLOW_SETTINGS_CHANGES = true;
        ALLOW_CHAT = true;
        ALLOW_ROOM_ACCESS = true;
        ALLOW_ROOM_MANAGEMENT = true;
        ALLOW_MODERATE = true;
        ALLOW_SEND_ALERTS = true;
        ALLOW_RECEIVE_ALERTS = true;
        ALLOW_NEWS_ACCESS = true;
        ALLOW_NEWS_MANAGEMENT = true;
        ALLOW_ATTACHMENTS = true;
        ALLOW_POLLS = true;
        ALLOW_RECEIVE_POLLS = true;
        ALLOW_CONTACT_MANAGEMENT = true;
        ALLOW_INVITE_OTHERS = true;
        flavor = 0;
        SERVER_ARCHIVE_ENABLED = false;
        policyPairs = new String[][]{{"version", "1.0"}, {"allow_alert_only.bool", "sunIMAllowAlertOnly"}, {"allow_file_transfer.bool", "sunIMAllowFileTransfer"}, {"enable_moderator.bool", "sunimenablemoderator"}, {"flavor.token", "sunimflavor"}, {"allow_presence_access.bool", "sunPresenceAllowAccess"}, {"allow_settings_changes.bool", "sunIMAllowUserSettings"}, {"allow_chat.bool", "sunIMAllowChat"}, {"allow_invite_others.bool", "sunIMAllowChatInvite"}, {"allow_room_access.bool", "sunIMAllowForumAccess"}, {"allow_room_management.bool", "sunIMAllowForumManage"}, {"allow_moderate.bool", "sunIMAllowForumModerate"}, {"allow_send_alerts.bool", "sunIMAllowAlertsSend"}, {"allow_receive_alerts.bool", "sunIMAllowAlertsAccess"}, {"allow_news_access.bool", "sunIMAllowNewsAccess"}, {"allow_news_management.bool", "sunIMAllowNewsManage"}, {"allow_polls.bool", "sunIMAllowPollingSend"}, {"allow_receive_polls.bool", "sunIMAllowPollingAccess"}, {"allow_contact_management.bool", "sunIMAllowContactListManage"}, {"allow_presence_changes.bool", "sunPresenceAllowManage"}, {"allow_presence_publish.bool", "sunPresenceAllowPublish"}, {"enable_archive.bool", "sunIMArchiveEnabled"}};
        logger = null;
        tMemory = 0L;
        fMemory = 0L;
        beansAlreadyAdded = false;
    }
}

