/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.Manager;
import com.sun.im.desktop.MessengerBeanFactory;
import com.sun.im.desktop.MessengerContainer;
import com.sun.im.desktop.MessengerEventListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;

public class MBeanRecord {
    public MessengerContainer container;
    public MessengerBeanFactory factory;
    public Component component;
    public MessengerEventListener eventListener = null;
    public EventListener _mbeanManagerEventListener = null;
    public ActionListener _mbeanManagerActionListener = null;
    public ItemListener _mbeanManagerItemListener = null;

    public MBeanRecord(MessengerContainer container, MessengerBeanFactory factory, Component component) {
        this.container = container;
        this.factory = factory;
        this.component = component;
        this.eventListener = this.factory.getEventListener(this.container);
    }

    public void listen() {
        if (this.eventListener != null) {
            this._mbeanManagerEventListener = new MBeanManagerListener((EventListener)this.eventListener);
            if (this.eventListener instanceof ActionListener && this.component instanceof JButton) {
                ((JButton)this.component).addActionListener((ActionListener)this._mbeanManagerEventListener);
            } else if (this.eventListener instanceof ItemListener && this.component instanceof JToggleButton) {
                ((JToggleButton)this.component).addItemListener((ItemListener)this._mbeanManagerEventListener);
            }
        }
    }

    public void close() {
        if (this.component instanceof JButton) {
            ((JButton)this.component).removeActionListener((ActionListener)this._mbeanManagerEventListener);
        } else if (this.component instanceof JToggleButton) {
            ((JToggleButton)this.component).removeItemListener((ItemListener)this._mbeanManagerEventListener);
        }
        this.factory.removeEventListener(this.eventListener);
    }

    public void enable() {
        this.component.setEnabled(true);
    }

    public void disable() {
        this.component.setEnabled(false);
    }

    public String getLabel() {
        if (this.eventListener != null) {
            return this.eventListener.getLabel();
        }
        return null;
    }

    public String getImage() {
        if (this.eventListener != null) {
            return this.eventListener.getImage();
        }
        return null;
    }

    public ImageIcon getIcon() {
        if (this.eventListener != null) {
            Manager.Out("MBeanRecord.getIcon(): returning: " + this.eventListener.getIcon());
            return this.eventListener.getIcon();
        }
        return null;
    }

    public String getToolTipText() {
        if (this.eventListener != null) {
            Manager.Out("MBeanRecord.getToolTipText(): returning: " + this.eventListener.getToolTipText());
            return this.eventListener.getToolTipText();
        }
        return null;
    }

    class MBeanManagerListener
    implements ActionListener,
    ItemListener {
        EventListener _eventListener;

        public MBeanManagerListener(EventListener eventListener) {
            this._eventListener = eventListener;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this._eventListener != null) {
                MessengerEventThread thr = new MessengerEventThread(this._eventListener, itemEvent);
                thr.start();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this._eventListener != null) {
                MessengerEventThread thr = new MessengerEventThread(this._eventListener, actionEvent);
                thr.start();
            }
        }
    }

    class MessengerEventThread
    extends Thread {
        ActionListener _actionListener = null;
        ItemListener _itemListener = null;
        ActionEvent _actionEvent = null;
        ItemEvent _itemEvent = null;

        public MessengerEventThread(EventListener eventListener, AWTEvent e) {
            if (eventListener instanceof ActionListener) {
                this._actionListener = (ActionListener)eventListener;
                this._actionEvent = (ActionEvent)e;
            } else if (eventListener instanceof ItemListener) {
                this._itemListener = (ItemListener)eventListener;
                this._itemEvent = (ItemEvent)e;
            }
        }

        public void run() {
            MBeanRecord.this.disable();
            if (this._actionListener != null) {
                this._actionListener.actionPerformed(this._actionEvent);
            } else if (this._itemListener != null) {
                this._itemListener.itemStateChanged(this._itemEvent);
            }
            MBeanRecord.this.enable();
        }
    }
}

