/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.MBeanRecord;
import com.iplanet.im.client.manager.Manager;
import com.sun.im.desktop.MessengerBeanFactory;
import com.sun.im.desktop.MessengerContainer;
import com.sun.im.desktop.MessengerMessageListener;
import com.sun.im.service.ReadOnlyMessage;
import java.awt.Component;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public final class MBeanManager {
    public static final String MBEAN_PREFIX = "mbean.";
    public static final String MBEAN_COMMUNICATOR = "mbean.comm";
    public static final String MBEAN_COMM_TAB_CONTACTS = "mbean.comm.tab.contacts";
    public static final String MBEAN_COMM_TAB_CONFS = "mbean.comm.tab.confs";
    public static final String MBEAN_CHAT = "mbean.chat";
    public static final String MBEAN_CONFERENCE = "mbean.conference";
    public static final String MBEAN_POLLRECV = "mbean.poll";
    public static final String MBEAN_POLLCOMPOSE = "mbean.poll.compose";
    public static final String MBEAN_ALERTRECV = "mbean.alert";
    public static final String MBEAN_ALERTCOMPOSE = "mbean.alert.compose";
    private static String factoryClassList = null;
    private static HashMap _factories = new HashMap();
    private static LinkedList _factoryList = new LinkedList();
    private static Hashtable _beans = new Hashtable();
    private static LinkedList _genericMessageListeners = new LinkedList();
    private static HashMap _messageListeners = new HashMap();

    public static void addBean(String containerType, MessengerBeanFactory f) {
        try {
            if (f != null) {
                LinkedList<MessengerBeanFactory> l = (LinkedList<MessengerBeanFactory>)_factories.get(containerType);
                if (l != null) {
                    if (!l.contains(f)) {
                        l.add(f);
                    }
                } else {
                    l = new LinkedList<MessengerBeanFactory>();
                    l.add(f);
                    _factories.put(containerType, l);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addMessageListener(MessengerMessageListener listener) {
        Manager.Out("[Bean] adding generic message listener: " + listener);
        _genericMessageListeners.add(listener);
    }

    public static void addMessageListener(String contentType, MessengerMessageListener listener) {
        try {
            if (listener != null) {
                LinkedList<MessengerMessageListener> l = (LinkedList<MessengerMessageListener>)_messageListeners.get(contentType);
                if (l != null) {
                    if (!l.contains(listener)) {
                        l.add(listener);
                    }
                    Manager.Out("[Bean] Added new listener for " + contentType);
                } else {
                    l = new LinkedList<MessengerMessageListener>();
                    l.add(listener);
                    _messageListeners.put(contentType, l);
                    Manager.Out("[Bean] created new listener list for " + contentType);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processMessage(ReadOnlyMessage m) {
        MessengerMessageListener listener;
        Iterator i;
        String contentType = m.getContentType();
        Manager.Out("[Bean] Processing Message of type " + m.getContentType());
        List l = (List)_messageListeners.get(contentType);
        if (l != null) {
            Manager.Out("[Bean] found listener list of size " + l.size());
            i = l.iterator();
            while (i.hasNext()) {
                listener = (MessengerMessageListener)i.next();
                if (_genericMessageListeners.contains(listener)) continue;
                Manager.Out("[Bean] found listener: " + listener);
                listener.onMessage(m);
            }
        }
        i = _genericMessageListeners.iterator();
        while (i.hasNext()) {
            listener = (MessengerMessageListener)i.next();
            Manager.Out("[Bean] found listener: " + listener);
            listener.onMessage(m);
        }
    }

    public static void init(String factories) {
        Manager.Out("[Bean] init: " + factories);
        factoryClassList = factories;
    }

    public static void load() {
        Manager.Out("[Bean] Loading beans");
        if (factoryClassList != null) {
            StringTokenizer st = new StringTokenizer(factoryClassList, ",");
            while (st.hasMoreTokens()) {
                String className = st.nextToken().trim();
                try {
                    MessengerBeanFactory f = (MessengerBeanFactory)Class.forName(className).newInstance();
                    Manager.Out("[Bean] Loaded Bean: " + className);
                    MBeanManager.addFactory(f);
                }
                catch (Exception e) {
                    System.err.println("[Bean] Failed to load " + className + " - " + e.toString());
                }
            }
        }
        Iterator i = _factoryList.iterator();
        while (i.hasNext()) {
            MessengerBeanFactory f = (MessengerBeanFactory)i.next();
            f.init();
        }
    }

    public static void addFactory(MessengerBeanFactory f) {
        _factoryList.add(f);
        int locations = f.getLocations();
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_COMMUNICATOR) != 0) {
            MBeanManager.addBean(MBEAN_COMMUNICATOR, f);
        }
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_COMM_TAB_CONTACTS) != 0) {
            MBeanManager.addBean(MBEAN_COMM_TAB_CONTACTS, f);
        }
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_COMM_TAB_CONFS) != 0) {
            MBeanManager.addBean(MBEAN_COMM_TAB_CONFS, f);
        }
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_CHAT) != 0) {
            MBeanManager.addBean(MBEAN_CHAT, f);
        }
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_CONFERENCE) != 0) {
            MBeanManager.addBean(MBEAN_CONFERENCE, f);
        }
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_RECEIVE_ALERT) != 0) {
            MBeanManager.addBean(MBEAN_ALERTRECV, f);
        }
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_COMPOSE_ALERT) != 0) {
            MBeanManager.addBean(MBEAN_ALERTCOMPOSE, f);
        }
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_RECEIVE_POLL) != 0) {
            MBeanManager.addBean(MBEAN_POLLRECV, f);
        }
        if ((locations & MessengerBeanFactory.MBEAN_LOCATION_COMPOSE_POLL) != 0) {
            MBeanManager.addBean(MBEAN_POLLCOMPOSE, f);
        }
    }

    public static List getBeans(String containerType) {
        return (List)_factories.get(containerType);
    }

    public static List getBeans() {
        return _factoryList;
    }

    public static void cleanup() {
        Iterator i = _factoryList.iterator();
        while (i.hasNext()) {
            MessengerBeanFactory f = (MessengerBeanFactory)i.next();
            f.close();
        }
    }

    public static MBeanRecord addComponent(MessengerContainer container, MessengerBeanFactory factory, Component component) {
        MBeanRecord r = new MBeanRecord(container, factory, component);
        Manager.Out("[Bean] new component");
        LinkedList<MBeanRecord> l = (LinkedList<MBeanRecord>)_beans.get(container);
        if (l != null) {
            if (!l.contains(r)) {
                l.add(r);
            }
        } else {
            l = new LinkedList<MBeanRecord>();
            l.add(r);
            _beans.put(container, l);
        }
        return r;
    }

    public static void close(Object container) {
        List l = (List)_beans.remove(container);
        if (l != null) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                MBeanRecord r = (MBeanRecord)i.next();
                r.close();
            }
        }
    }

    public static void startActionListeners(Object container) {
        List l = (List)_beans.get(container);
        if (l != null) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                MBeanRecord r = (MBeanRecord)i.next();
                r.listen();
            }
        }
    }
}

