/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.LonguestFirstComparator;
import com.iplanet.im.client.manager.Manager;
import com.sun.im.service.util.HtmlUtility;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EmoticonsManager
extends Manager {
    private static final String SHORTCUT_KEY_SUFFIX = ".shortcut";
    private static final String TOOLTIP_KEY_SUFFIX = ".tooltip";
    private static final String IMAGE_KEY_SUFFIX = ".image";
    private static Properties _props = null;
    private static HashMap _htShortcuts = null;
    private static HashMap _htIconsURLs = null;
    private static HashMap _htIcons = null;
    private static String[] _shortcuts = null;
    private static String[] _uniqueShortcuts = null;
    private static String[] _tooltips = null;
    private static HashMap _htTooltips = null;
    private static String[] _uniqueTooltips = null;
    private static HashMap _htTooltips1 = null;

    public static void init() throws IOException {
        int suffixPos;
        int i = 0;
        int j = 0;
        Iterator keyIterator = null;
        Iterator keyToolIterator = null;
        _props = new Properties();
        if (_htShortcuts == null) {
            _htShortcuts = new HashMap();
        }
        if (_htTooltips == null) {
            _htTooltips = new HashMap();
        }
        if (_htIconsURLs == null) {
            _htIconsURLs = new HashMap();
        }
        InputStream is = EmoticonsManager.class.getResourceAsStream("/com/sun/im/desktop/emoticons/emoticons.properties");
        _props.load(is);
        is.close();
        String key = null;
        String keyTooltip = null;
        String newKey = null;
        Object newTooltipKey = null;
        Enumeration<?> keysEnum = null;
        keysEnum = _props.propertyNames();
        while (keysEnum.hasMoreElements()) {
            key = (String)keysEnum.nextElement();
            suffixPos = key.indexOf(IMAGE_KEY_SUFFIX);
            if (suffixPos == -1) continue;
            newKey = key.substring(0, key.length() - IMAGE_KEY_SUFFIX.length());
            if (_htIconsURLs.containsKey(newKey)) {
                System.err.println("EmoticonsManager.init(): Emoticon: " + newKey + " is defined more than once, ignoring this instance.");
                continue;
            }
            String value = (String)_props.get(key);
            if (value == null || value.length() <= 0) continue;
            URL iconURL = (class$com$iplanet$im$client$manager$EmoticonsManager == null ? EmoticonsManager.class$("com.iplanet.im.client.manager.EmoticonsManager") : class$com$iplanet$im$client$manager$EmoticonsManager).getResource("/com/sun/im/desktop/emoticons/" + value);
            if (iconURL == null) {
                iconURL = (class$com$iplanet$im$client$manager$EmoticonsManager == null ? EmoticonsManager.class$("com.iplanet.im.client.manager.EmoticonsManager") : class$com$iplanet$im$client$manager$EmoticonsManager).getResource("/com/sun/im/desktop/default/emoticons/" + value);
            }
            if (iconURL == null) continue;
            _htIconsURLs.put(key.substring(0, key.length() - IMAGE_KEY_SUFFIX.length()), iconURL);
        }
        keysEnum = _props.propertyNames();
        while (keysEnum.hasMoreElements()) {
            String shortcut;
            key = (String)keysEnum.nextElement();
            suffixPos = key.indexOf(SHORTCUT_KEY_SUFFIX);
            if (suffixPos == -1) continue;
            String iconName = key.substring(0, suffixPos);
            if (!key.endsWith(SHORTCUT_KEY_SUFFIX) && !key.substring(suffixPos + SHORTCUT_KEY_SUFFIX.length()).startsWith(".")) {
                System.err.println("EmoticonsManager.init(): Key: " + key + " is illegal: unrecognized suffix: " + key.substring(suffixPos + 1) + ", ignoring...");
                continue;
            }
            if (!_htIconsURLs.containsKey(iconName) || (shortcut = (String)_props.get(key)) == null || shortcut.length() <= 0) continue;
            if (_htShortcuts.containsKey(shortcut)) {
                System.err.println("EmoticonsManager.init(): Shortcut: " + shortcut + " is defined more than once, ignoring this instance.");
                continue;
            }
            _htShortcuts.put(shortcut, iconName);
        }
        keyIterator = _htIconsURLs.keySet().iterator();
        while (keyIterator.hasNext()) {
            key = (String)keyIterator.next();
            if (_htShortcuts.containsValue(key)) continue;
            System.err.println("EmoticonsManager.init(): Emoticon: " + key + " has no shortcut associated: removing");
            _htIconsURLs.remove(key);
        }
        i = 0;
        _shortcuts = new String[_htShortcuts.size()];
        keyIterator = _htShortcuts.keySet().iterator();
        while (keyIterator.hasNext()) {
            EmoticonsManager._shortcuts[i++] = (String)keyIterator.next();
        }
        Arrays.sort(_shortcuts, new LonguestFirstComparator());
        for (i = 0; i < _shortcuts.length; ++i) {
            EmoticonsManager.Out("EmoticonsManager.init(): loaded: " + _shortcuts[i]);
        }
        EmoticonsManager.Out("EmoticonsManager.init(): Initialization terminated, " + _htIconsURLs.size() + " emoticon(s) loaded.");
        keysEnum = _props.propertyNames();
        while (keysEnum.hasMoreElements()) {
            String tooltip;
            keyTooltip = (String)keysEnum.nextElement();
            int suffixTooltipPos = keyTooltip.indexOf(TOOLTIP_KEY_SUFFIX);
            if (suffixTooltipPos == -1) continue;
            String iconTooltipName = keyTooltip.substring(0, suffixTooltipPos);
            if (!keyTooltip.endsWith(TOOLTIP_KEY_SUFFIX) && !keyTooltip.endsWith(SHORTCUT_KEY_SUFFIX)) {
                if (!keyTooltip.substring(suffixTooltipPos + TOOLTIP_KEY_SUFFIX.length()).startsWith(".")) {
                    System.err.println("EmoticonsManager.init(): Key: " + keyTooltip + " is illegal: unrecognized suffix: " + keyTooltip.substring(suffixTooltipPos + 1) + ", ignoring...");
                    continue;
                }
                if (!keyTooltip.substring(suffixTooltipPos + SHORTCUT_KEY_SUFFIX.length()).startsWith(".")) {
                    System.err.println("EmoticonsManager.init(): Key: " + keyTooltip + " is illegal: unrecognized suffix: " + keyTooltip.substring(suffixTooltipPos + 1) + ", ignoring...");
                    continue;
                }
            }
            if (!_htIconsURLs.containsKey(iconTooltipName) || (tooltip = (String)_props.get(keyTooltip)) == null || tooltip.length() <= 0) continue;
            if (_htTooltips.containsKey(tooltip)) {
                System.err.println("EmoticonsManager.init(): Tooltip: " + tooltip + " is defined more than once, ignoring this instance.");
                continue;
            }
            _htTooltips.put(iconTooltipName, tooltip);
        }
        j = 0;
        _tooltips = new String[_htTooltips.size()];
        keyToolIterator = _htTooltips.keySet().iterator();
        while (keyToolIterator.hasNext()) {
            EmoticonsManager._tooltips[j++] = (String)keyToolIterator.next();
        }
        Arrays.sort(_tooltips, new LonguestFirstComparator());
        for (j = 0; j < _tooltips.length; ++j) {
            EmoticonsManager.Out("EmoticonsManager.init(): loaded: " + _tooltips[j]);
        }
        EmoticonsManager.Out("EmoticonsManager.init(): Initialization terminated, " + _htIconsURLs.size() + " emoticon(s) loaded.");
    }

    public static int getEmoticonsCount() {
        return _htIconsURLs.size();
    }

    public static String[] getShortcuts() {
        return _shortcuts;
    }

    public static String[] getTooltips() {
        return _tooltips;
    }

    public static String[] getUniqueShortcuts() {
        if (_uniqueShortcuts == null) {
            ArrayList<String> shortcuts = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            Iterator keyIterator = null;
            int i = 0;
            for (i = 0; i < _shortcuts.length; ++i) {
                shortcuts.add(_shortcuts[i]);
            }
            keyIterator = _htIconsURLs.keySet().iterator();
            while (keyIterator.hasNext()) {
                names.add((String)keyIterator.next());
            }
            for (i = 0; i < shortcuts.size(); ++i) {
                String name = (String)_htShortcuts.get((String)shortcuts.get(i));
                if (names.indexOf(name) > -1) {
                    names.remove(name);
                    continue;
                }
                shortcuts.remove(i--);
            }
            names = null;
            _uniqueShortcuts = new String[shortcuts.size()];
            for (i = 0; i < shortcuts.size(); ++i) {
                EmoticonsManager._uniqueShortcuts[i] = (String)shortcuts.get(i);
                EmoticonsManager.Out("EmoticonsManager.getUniqueShortcuts(): keeping shortcut: " + _uniqueShortcuts[i]);
            }
            Object var0 = null;
        }
        return _uniqueShortcuts;
    }

    public static String[] getUniqueTooltips() {
        if (_uniqueTooltips == null) {
            ArrayList<String> tooltips = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            Iterator keyIterator = null;
            int i = 0;
            for (i = 0; i < _tooltips.length; ++i) {
                tooltips.add(_tooltips[i]);
            }
            keyIterator = _htIconsURLs.keySet().iterator();
            while (keyIterator.hasNext()) {
                names.add((String)keyIterator.next());
            }
            for (i = 0; i < tooltips.size(); ++i) {
                String name = (String)_htTooltips.get((String)tooltips.get(i));
                if (names.indexOf(name) > -1) {
                    names.remove(name);
                    continue;
                }
                tooltips.remove(i--);
            }
            names = null;
            _uniqueTooltips = new String[tooltips.size()];
            for (i = 0; i < tooltips.size(); ++i) {
                EmoticonsManager._uniqueTooltips[i] = (String)tooltips.get(i);
                EmoticonsManager.Out("EmoticonsManager.getUniqueTooltips(): keeping tooltips: " + _uniqueTooltips[i]);
            }
            Object var0 = null;
        }
        return _uniqueTooltips;
    }

    public static URL getIconURLForShortcut(String shortcut) {
        if (shortcut == null || shortcut.length() <= 0 || !_htShortcuts.containsKey(shortcut)) {
            return null;
        }
        String iconName = (String)_htShortcuts.get(shortcut);
        return (URL)_htIconsURLs.get(iconName);
    }

    public static Icon getIconForShortcut(String shortcut) {
        if (shortcut == null || shortcut.length() <= 0 || !_htShortcuts.containsKey(shortcut)) {
            return null;
        }
        if (_htIcons == null) {
            _htIcons = new HashMap(_htIconsURLs.size());
            Iterator keyIterator = _htIconsURLs.keySet().iterator();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                _htIcons.put(key, new ImageIcon((URL)_htIconsURLs.get(key), key));
            }
        }
        String iconName = (String)_htShortcuts.get(shortcut);
        return (Icon)_htIcons.get(iconName);
    }

    public static String getToolTipForShortcut(String shortcut) {
        if (shortcut == null || shortcut.length() <= 0 || !_htShortcuts.containsKey(shortcut)) {
            return null;
        }
        if (_htTooltips == null) {
            _htTooltips = new HashMap(_htIconsURLs.size());
            Iterator keyIterator = _htIconsURLs.keySet().iterator();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                _htIcons.put(key, new ImageIcon((URL)_htIconsURLs.get(key), key));
            }
        }
        String toolTip = (String)_htShortcuts.get(shortcut);
        return (String)_htTooltips.get(toolTip);
    }

    public static String substituteHTMLEmoticons(String s) {
        for (int i = 0; i < _shortcuts.length; ++i) {
            String escapedShortcut = HtmlUtility.escape((String)_shortcuts[i]);
            if (s.indexOf(escapedShortcut) <= -1) continue;
            s = HtmlUtility.substitute((String)s, (String)_shortcuts[i], (String)HtmlUtility.createImageTag((String)EmoticonsManager.getIconURLForShortcut(_shortcuts[i]).toString(), (String)((String)_htShortcuts.get(_shortcuts[i]))));
        }
        return s;
    }

    public static final void reload() {
        EmoticonsManager.clearCache();
        try {
            EmoticonsManager.init();
        }
        catch (Exception e) {
            System.out.println("EmoticonsManager.reload(): Exception thrown while initializing emoticons: " + e);
        }
    }

    public static final void clearCache() {
        if (_htShortcuts != null) {
            _htShortcuts.clear();
        }
        if (_htIconsURLs != null) {
            _htIconsURLs.clear();
        }
        if (_htIcons != null) {
            _htIcons.clear();
        }
        if (_htTooltips != null) {
            _htTooltips.clear();
        }
        _htShortcuts = null;
        _htIconsURLs = null;
        _htIcons = null;
        _htTooltips = null;
    }

    static {
        try {
            EmoticonsManager.init();
        }
        catch (Exception e) {
            System.out.println("EmoticonsManager.<init>: Exception thrown while initializing emoticons: " + e);
        }
    }
}

