/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalProfile;
import com.sun.im.service.util.StringUtility;
import java.util.Hashtable;
import java.util.Properties;

public final class CurrentUserManager
extends Manager {
    static SafeResourceBundle currentUserManagerBundle = new SafeResourceBundle("com.iplanet.im.client.manager.manager");
    private static Hashtable policyAttributes = new Hashtable();

    public static void initPolicyAttributes(String[][] thePolicyPairs) {
        for (int i = 0; i < thePolicyPairs.length; ++i) {
            policyAttributes.put(thePolicyPairs[i][0], thePolicyPairs[i][1]);
        }
    }

    static final boolean aValueHasBeenAssignedTo(attributeAndValueAssigned thePair) {
        boolean validAssignment = false;
        boolean theValueAssigned = false;
        String attr = (String)policyAttributes.get(thePair.getAttribute());
        if (attr != null) {
            String val = CurrentUserManager.getAttribute(attr);
            if (val != null) {
                try {
                    Manager.Out(attr + "=" + val);
                    theValueAssigned = StringUtility.getBoolean((String)val);
                    validAssignment = true;
                }
                catch (Exception e) {}
            } else {
                Manager.Out("config.me.getAttribute(" + attr + ") returned null");
            }
        } else {
            Manager.Out("policyAttributes.get(" + thePair.getAttribute() + ") returned null");
        }
        thePair.setValue(theValueAssigned);
        return validAssignment;
    }

    protected static void readPolicy() {
        String val;
        String attr;
        attributeAndValueAssigned avPair = new attributeAndValueAssigned();
        avPair.setAttribute("allow_alert_only.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_ALERT_ONLY = avPair.getValue();
        }
        avPair.setAttribute("allow_file_transfer.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_ATTACHMENTS = avPair.getValue();
        }
        avPair.setAttribute("enable_moderator.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.MODERATED_FEATURE = avPair.getValue();
        }
        avPair.setAttribute("allow_presence_publish.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_PRESENCE_PUBLISH = avPair.getValue();
        }
        Manager.Out("ALLOW_PRESENCE_PUBLISH: " + Manager.ALLOW_PRESENCE_PUBLISH);
        avPair.setAttribute("allow_presence_access.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_PRESENCE_ACCESS = avPair.getValue();
        }
        Manager.Out("ALLOW_PRESENCE_ACCESS: " + Manager.ALLOW_PRESENCE_ACCESS);
        avPair.setAttribute("allow_settings_changes.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_SETTINGS_CHANGES = avPair.getValue();
        }
        avPair.setAttribute("allow_chat.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_CHAT = avPair.getValue();
        }
        Manager.Out("ALLOW_CHAT: " + Manager.ALLOW_CHAT);
        avPair.setAttribute("allow_invite_others.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_INVITE_OTHERS = avPair.getValue();
        }
        avPair.setAttribute("allow_room_access.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_ROOM_ACCESS = !Manager.ALLOW_SETTINGS_CHANGES ? false : avPair.getValue();
        }
        Manager.Out("ALLOW_ROOM_ACCESS: " + Manager.ALLOW_ROOM_ACCESS);
        avPair.setAttribute("allow_room_management.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_ROOM_MANAGEMENT = !Manager.ALLOW_SETTINGS_CHANGES ? false : avPair.getValue();
        }
        Manager.Out("ALLOW_ROOM_MANAGEMENT: " + Manager.ALLOW_ROOM_MANAGEMENT);
        avPair.setAttribute("allow_moderate.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_MODERATE = avPair.getValue();
        }
        avPair.setAttribute("allow_receive_polls.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_RECEIVE_POLLS = avPair.getValue();
        }
        avPair.setAttribute("allow_send_alerts.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_SEND_ALERTS = avPair.getValue();
        }
        avPair.setAttribute("allow_receive_alerts.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_RECEIVE_ALERTS = avPair.getValue();
        }
        avPair.setAttribute("allow_news_access.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_NEWS_ACCESS = avPair.getValue();
        }
        avPair.setAttribute("allow_news_management.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_NEWS_MANAGEMENT = avPair.getValue();
        }
        Manager.Out("ALLOW_NEWS_MANAGEMENT: " + Manager.ALLOW_NEWS_MANAGEMENT);
        avPair.setAttribute("allow_polls.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_POLLS = avPair.getValue();
        }
        avPair.setAttribute("allow_contact_management.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_CONTACT_MANAGEMENT = avPair.getValue();
        }
        avPair.setAttribute("allow_presence_changes.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.ALLOW_PRESENCE_CHANGES = avPair.getValue();
        }
        avPair.setAttribute("enable_archive.bool");
        if (CurrentUserManager.aValueHasBeenAssignedTo(avPair)) {
            Manager.SERVER_ARCHIVE_ENABLED = avPair.getValue();
        }
        if ((attr = (String)policyAttributes.get("flavor.token")) != null && (val = CurrentUserManager.getAttribute(attr)) != null) {
            Manager.Out("flavor policy read: " + attr + "=" + val);
            Manager.initFlavor(val);
        }
        if (!Manager.ALLOW_PRESENCE_ACCESS) {
            Manager.ALLOW_CHAT = false;
            Manager.ALLOW_SEND_ALERTS = false;
            Manager.ALLOW_POLLS = false;
        }
    }

    public static final Properties getCurrentUserProperties() {
        return userSettings;
    }

    public static final void setCurrentUserProperties(Properties p) {
        userSettings = p;
    }

    public static final String getCurrentUserServer() {
        try {
            return _session.getPrincipal().getDomainName();
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
            return null;
        }
    }

    public static final PersonalContact getCurrentUser() {
        if (_session == null) {
            return null;
        }
        try {
            return (PersonalContact)_personalStoreSession.getEntry("contact", CurrentUserManager.getCurrentUserID());
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
            e.printStackTrace();
            return null;
        }
    }

    public static final CollaborationPrincipal getCurrentPrincipal() {
        if (_session == null) {
            return null;
        }
        try {
            CollaborationPrincipal cp = _session.getPrincipal();
            return cp;
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
            return null;
        }
    }

    public static final PersonalProfile getCurrentProfile() {
        if (_session == null) {
            return null;
        }
        try {
            return _personalStoreSession.getProfile();
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
            return null;
        }
    }

    public static final String getAttribute(String name) {
        PersonalProfile p = CurrentUserManager.getCurrentProfile();
        if (p == null) {
            return null;
        }
        return StringUtility.getFirstAttr((Object)p.getProperty(name));
    }

    public static final String getCurrentUserID() {
        if (_session == null) {
            return null;
        }
        return CurrentUserManager.getCurrentPrincipal().getUID();
    }

    public static final String getCurrentUserDisplayName() {
        if (_session == null) {
            return null;
        }
        return CurrentUserManager.getCurrentPrincipal().getDisplayName();
    }

    public static final boolean isCurrentUserID(String s) {
        return CurrentUserManager.getCurrentUserID().equalsIgnoreCase(s);
    }

    public static final String getCurrUsrUIDWithResource() {
        return CurrentUserManager.getCurrentUserID() + "/" + Manager.NetLertProperties.get("net.resource");
    }

    private static final class attributeAndValueAssigned {
        String attribute;
        boolean valueAssigned = false;

        void setAttribute(String ma) {
            this.attribute = ma;
        }

        String getAttribute() {
            return this.attribute;
        }

        attributeAndValueAssigned() {
        }

        void setValue(boolean value) {
            this.valueAssigned = value;
        }

        boolean getValue() {
            return this.valueAssigned;
        }
    }
}

