/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.BuddyListGroup;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.ServerGroup;
import com.iplanet.im.client.manager.ServerUser;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGateway;
import com.sun.im.service.PersonalGroup;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreFolder;
import com.sun.im.service.util.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class BuddyListManager
extends Manager {
    static SafeResourceBundle buddyListManagerBundle = new SafeResourceBundle("com.iplanet.im.client.manager.manager");
    private static Hashtable _htRoot = new Hashtable();
    private static Vector _sortedBuddyListGroups = new Vector();
    private static ArrayList _gateways;
    public static final String ID_CUST_GROUP = "custom.";
    public static final String ID_CUST_USER = "custusr.";
    public static final String ID_CUST_USER_COUNT = "cust.usr.num.";
    public static final String ID_CUST_GRP_EXPANDED = "cust.grp.expand.";
    public static final String ID_MY_CONTACTS;
    private static String _dummyFolderName;
    public static final String SERVER_GROUP_MEMBERS = "Server Group Members";

    public static final void init() {
        try {
            Properties p = CurrentUserManager.getCurrentUserProperties();
            String orphansFolder = iIMPropsUtil.getOrphansFolder(p);
            if (orphansFolder != null) {
                _dummyFolderName = orphansFolder;
            }
            BuddyListManager.loadBuddyListNow();
            BuddyListManager.loadGateways();
        }
        catch (CollaborationException e) {
            BuddyListManager.Out("Exception: " + (Object)((Object)e));
        }
    }

    public static final void reload(boolean clear) {
        if (clear) {
            _htRoot.clear();
            _sortedBuddyListGroups.clear();
            _gateways = null;
        }
        BuddyListManager.loadBuddyList();
    }

    public static final void clear() {
        _htRoot.clear();
        _sortedBuddyListGroups.clear();
        _gateways = null;
    }

    public static final void loadBuddyList() {
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            Manager.worker.addRunnable((Runnable)new LoadBuddyListThread());
        }
    }

    public static final void loadBuddyListNow() throws CollaborationException {
        if (!Manager.ALLOW_PRESENCE_ACCESS) {
            BuddyListManager.Out("BuddyListManager.loadBuddyListNow(): no presence access");
            return;
        }
        BuddyListManager.Out("BuddyListManager.loadBuddyListNow(): Starting");
        Properties p = (Properties)userSettings.clone();
        Vector<String> users = new Vector<String>();
        Enumeration<Object> e = p.keys();
        boolean hasContacts = false;
        UserCache.clearPrimaryCache();
        Collection folders = _personalStoreSession.getFolders("abook");
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            PersonalStoreEntry pse;
            Iterator j;
            PersonalStoreFolder f = (PersonalStoreFolder)i.next();
            Object newFolder = null;
            String folder = f.getDisplayName();
            if (folder.equals(SERVER_GROUP_MEMBERS)) {
                Collection c = f.getEntries();
                j = c.iterator();
                while (j.hasNext()) {
                    pse = (PersonalStoreEntry)j.next();
                    if (!"contact".equals(pse.getType())) continue;
                    PersonalContact pc = (PersonalContact)pse;
                    UserCache.addToPrimaryCache(pc.getPrincipal());
                }
                continue;
            }
            if (folder.equals("")) {
                BuddyListManager.Out("folder name is blank");
                BuddyListManager.addBuddyListGroup0(_dummyFolderName);
                folder = _dummyFolderName;
            } else {
                BuddyListManager.addBuddyListGroup0(folder);
            }
            BuddyListManager.Out(" - " + folder);
            Collection entries = f.getEntries();
            j = entries.iterator();
            while (j.hasNext()) {
                PersonalContact c;
                pse = (PersonalStoreEntry)j.next();
                if ("contact".equals(pse.getType())) {
                    c = (PersonalContact)pse;
                    UserCache.addToPrimaryCache(c.getPrincipal());
                    String id = c.getAddress("im");
                    if (!BuddyListManager.isWatcher(c)) {
                        BuddyListManager.addBuddyListGroupMember0(folder, id);
                        BuddyListManager.Out("     - " + c.getDisplayName() + " <" + id + ">");
                    }
                    users.addElement(id);
                    hasContacts = true;
                } else if ("group".equals(pse.getType())) {
                    c = (PersonalGroup)pse;
                    CollaborationGroup cg = c.getGroup();
                    UserCache.addToPrimaryCache((CollaborationPrincipal)cg);
                    BuddyListManager.addBuddyListGroupMember0(folder, cg);
                    hasContacts = true;
                    BuddyListManager.Out("     - " + c.getDisplayName() + " <" + c.getEntryId() + ">");
                } else {
                    BuddyListManager.Out("     - " + pse.getDisplayName() + " <" + pse.getEntryId() + "> - Not added to buddy list");
                }
                String grpKey = folder.replace(' ', '_');
                BuddyListManager.setBuddyListGroupExpansion(folder, StringUtility.getBoolean((String)p.getProperty(ID_CUST_GRP_EXPANDED + grpKey, "true")));
                userSettings.remove(ID_CUST_GRP_EXPANDED + grpKey);
            }
        }
        if (!hasContacts) {
            BuddyListManager.Out("Buddy list is empty. Creating a new list.");
            BuddyListManager.addBuddyListGroup0(_dummyFolderName);
            BuddyListManager.addBuddyListGroupMember(_dummyFolderName, CurrentUserManager.getCurrentUserID());
        }
        if (_htRoot.size() == 1) {
            BuddyListManager.setBuddyListGroupExpansion((String)_sortedBuddyListGroups.get(0), true);
        }
        BuddyListManager.Out("BuddyListManager.loadBuddyListNow(): Terminating");
    }

    private static boolean isWatcher(PersonalContact pc) {
        return pc.getInboundSubscriptionStatus() == 0 && pc.getOutboundSubscriptionStatus() == 1;
    }

    public static final void saveBuddyListGroups(Properties p) {
        try {
            LinkedList folders = new LinkedList(Manager._personalStoreSession.getFolders("abook"));
            Enumeration groupNames = _htRoot.keys();
            while (groupNames.hasMoreElements()) {
                String groupName = (String)groupNames.nextElement();
                String tmp = groupName.replace(' ', '_');
                BuddyListGroup cg = (BuddyListGroup)_htRoot.get(groupName);
                p.put(ID_CUST_GRP_EXPANDED + tmp, StringUtility.getBooleanString((boolean)cg.isExpanded()));
                List elements = cg.getMembers();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final String[] getBuddyListGroups() {
        Object[] sortedBuddyListGroups = new String[_sortedBuddyListGroups.size()];
        _sortedBuddyListGroups.copyInto(sortedBuddyListGroups);
        return sortedBuddyListGroups;
    }

    public static final int indexOfGroup(String buddyListGroupName) {
        return _sortedBuddyListGroups.indexOf(buddyListGroupName);
    }

    public static final boolean setBuddyListGroupCollapsed(String id) {
        return BuddyListManager.setBuddyListGroupExpansion(id, false);
    }

    public static final boolean setBuddyListGroupExpanded(String id) {
        return BuddyListManager.setBuddyListGroupExpansion(id, true);
    }

    public static final boolean setBuddyListGroupExpansion(String id, boolean expand) {
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(id);
        if (cg != null && cg.isExpanded() != expand) {
            BuddyListManager.Out("BuddyListManager.setBuddyListGroupExpansion(): id: " + id + "+ setting expansion to: " + expand);
            cg.setExpanded(expand);
            return true;
        }
        return false;
    }

    public static final void toggleBuddyListGroupExpansion(String id) {
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(id);
        if (cg != null) {
            cg.toggleExpansion();
        }
    }

    public static final boolean isGroupExpanded(String id) {
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(id);
        if (cg != null) {
            return cg.isExpanded();
        }
        return false;
    }

    public static final boolean isServerGroup(String grp) {
        if (grp == null) {
            return false;
        }
        return grp.startsWith("g:");
    }

    public static final CollaborationPrincipal[] getBuddyListGroupElements(String g) {
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(g);
        if (cg == null) {
            return null;
        }
        Manager.Out("group = " + g + "Member size is " + cg.getMemberCount());
        return BuddyListManager.toPrincipalArray(BuddyListManager.sortByElementsStatus(cg.getMembers()));
    }

    public static final CollaborationPrincipal[] getAllElements() {
        Enumeration buddyListGroups = _htRoot.keys();
        Vector<CollaborationPrincipal> allElements = new Vector<CollaborationPrincipal>();
        while (buddyListGroups.hasMoreElements()) {
            String key = (String)buddyListGroups.nextElement();
            CollaborationPrincipal[] elements = BuddyListManager.getBuddyListGroupElements(key);
            if (elements == null || elements.length <= 0) continue;
            for (int i = 0; i < elements.length; ++i) {
                if (!allElements.contains(elements[i])) {
                    // empty if block
                }
                allElements.add(elements[i]);
            }
        }
        if (allElements.size() == 0) {
            return null;
        }
        Object[] tmpArray = new CollaborationPrincipal[allElements.size()];
        allElements.copyInto(tmpArray);
        return tmpArray;
    }

    public static final String[] getAllElementsIDs() {
        CollaborationPrincipal[] allElements = BuddyListManager.getAllElements();
        if (allElements == null || allElements.length == 0) {
            return null;
        }
        String[] allElementsIds = new String[allElements.length];
        int i = 0;
        while (i < allElements.length) {
            allElementsIds[i] = allElements[i++].getUID();
        }
        return allElementsIds;
    }

    public static final String[] getAllGroupsAndUserIDs() {
        Manager.Out("Debug: in getAllGroupsAndUserIDs()");
        Enumeration buddyListGroups = _htRoot.keys();
        Vector<String> allElements = new Vector<String>();
        while (buddyListGroups.hasMoreElements()) {
            String key = (String)buddyListGroups.nextElement();
            allElements.add(key);
            Manager.Out("Debug: Added group: " + key);
            CollaborationPrincipal[] elements = BuddyListManager.getBuddyListGroupElements(key);
            if (elements == null || elements.length <= 0) continue;
            for (int i = 0; i < elements.length; ++i) {
                allElements.add(elements[i].getUID());
                Manager.Out("Debug: Added user: " + elements[i].getUID());
            }
        }
        if (allElements == null || allElements.size() == 0) {
            return null;
        }
        Manager.Out("Debug: size is: " + allElements.size());
        String[] allElementsIds = new String[allElements.size()];
        for (int i = 0; i < allElements.size(); ++i) {
            allElementsIds[i] = (String)allElements.elementAt(i);
        }
        return allElementsIds;
    }

    public static final boolean isElementInGroup(CollaborationPrincipal element, String group) {
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(group);
        if (cg == null) {
            return false;
        }
        return cg.isMember(element);
    }

    public static final boolean isElementInGroup(String uid, String group) {
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(group);
        if (cg == null) {
            return false;
        }
        return cg.isMember(uid);
    }

    public static final boolean isLdapGroupInGroup(String u, String g, String s) {
        return false;
    }

    public static final int getGroupMemberCount(String grp) {
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(grp);
        return cg.getMemberCount();
    }

    public static final void clearBuddyListGroupUsers(String g) {
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(g);
        if (cg == null) {
            return;
        }
        cg.clear();
    }

    public static final void addBuddyListGroup0(String name) {
        if (name == null) {
            return;
        }
        if (_htRoot.get(name) != null) {
            return;
        }
        _htRoot.put(name, new BuddyListGroup());
        _sortedBuddyListGroups.add(name);
        _sortedBuddyListGroups = StringUtility.sort((Vector)_sortedBuddyListGroups);
    }

    public static final void addBuddyListGroup(String name) {
        if (name == null) {
            return;
        }
        if (_htRoot.get(name) != null) {
            return;
        }
        try {
            PersonalStoreFolder psf = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", name);
            if (psf != null) {
                return;
            }
            psf = (PersonalStoreFolder)_personalStoreSession.createEntry("abook", name);
            psf.save();
        }
        catch (CollaborationException e) {
            return;
        }
        _htRoot.put(name, new BuddyListGroup());
        _sortedBuddyListGroups.add(name);
        _sortedBuddyListGroups = StringUtility.sort((Vector)_sortedBuddyListGroups);
    }

    static void addBuddyListGroupMember0(String groupName, Object o) {
        BuddyListGroup cg;
        if (groupName == null || o == null) {
            return;
        }
        if (!_htRoot.containsKey(groupName)) {
            BuddyListManager.Out("BuddyListGroup _htRoot.containsKey(groupName) " + groupName);
            BuddyListManager.addBuddyListGroup(groupName);
        }
        if ((cg = (BuddyListGroup)_htRoot.get(groupName)) == null) {
            BuddyListManager.Out("BuddyListGroup " + groupName + " not found");
            return;
        }
        String uid = null;
        if (o instanceof String) {
            uid = (String)o;
            if (BuddyListManager.isServerGroup(uid)) {
                cg.addMember(new ServerGroup(uid));
            } else {
                cg.addMember(new ServerUser(uid));
            }
        } else if (o instanceof CollaborationPrincipal) {
            uid = ((CollaborationPrincipal)o).getUID();
            if (o instanceof CollaborationGroup) {
                cg.addMember(new ServerGroup(uid));
            } else {
                cg.addMember(new ServerUser(uid));
            }
        }
        cg.setExpanded(true);
    }

    public static final void addBuddyListGroupMember(String groupName, Object o) {
        BuddyListManager.addBuddyListGroupMember(groupName, o, true);
    }

    public static final void addBuddyListGroupMember(String groupName, Object o, boolean subscribe) {
        BuddyListGroup cg;
        if (groupName == null || o == null) {
            return;
        }
        String uid = null;
        boolean group = false;
        if (o instanceof String) {
            uid = (String)o;
            if (BuddyListManager.isServerGroup(uid)) {
                group = true;
            }
        } else if (o instanceof CollaborationPrincipal) {
            uid = ((CollaborationPrincipal)o).getUID();
            if (o instanceof CollaborationGroup) {
                group = true;
            }
        }
        PersonalStoreEntry pse = null;
        if (uid != null) {
            try {
                PersonalStoreFolder psf = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", groupName);
                if (psf == null) {
                    psf = (PersonalStoreFolder)_personalStoreSession.createEntry("abook", groupName);
                }
                if ((pse = _personalStoreSession.getEntry(group ? "group" : "contact", uid)) == null) {
                    pse = _personalStoreSession.createEntry(UserCache.getPrincipal(uid), group ? "group" : "contact", UserCache.getPrincipal(uid).getDisplayName());
                } else {
                    PersonalStoreFolder temp = BuddyListManager.getFolderToCopy(pse);
                    if (temp != null) {
                        pse.addToFolder(temp);
                    }
                }
                pse.addToFolder(psf);
                pse.save();
            }
            catch (CollaborationException e) {
                return;
            }
            if (subscribe) {
                try {
                    if (!group && ((PersonalContact)(pse = _personalStoreSession.getEntry("contact", uid))).getInboundSubscriptionStatus() == 0) {
                        _presenceSession.subscribe(pse.getEntryId());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (!_htRoot.containsKey(groupName)) {
            BuddyListManager.Out("BuddyListGroup _htRoot.containsKey(groupName) " + groupName);
            BuddyListManager.addBuddyListGroup(groupName);
        }
        if ((cg = (BuddyListGroup)_htRoot.get(groupName)) == null) {
            return;
        }
        cg.setExpanded(true);
    }

    public static final void addBuddyListGroupMembers(String buddyListGroupID, Object[] members) {
        for (int n = 0; n < members.length; ++n) {
            BuddyListManager.addBuddyListGroupMember(buddyListGroupID, members[n]);
        }
    }

    public static final void removeBuddyListGroup(String grp) {
        block11: {
            BuddyListManager.Out("BuddyListManager.removeBuddyListGroup(): " + grp);
            if (grp == null) {
                return;
            }
            if (grp.equals(_dummyFolderName)) {
                BuddyListManager.removeBuddyListGroup("");
            }
            try {
                PersonalStoreFolder psf = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", grp);
                if (psf != null) {
                    Collection c = psf.getEntries();
                    Iterator it = c.iterator();
                    while (it.hasNext()) {
                        PersonalStoreEntry pse = (PersonalStoreEntry)it.next();
                        if (pse instanceof PersonalContact && BuddyListManager.isWatcher((PersonalContact)pse)) {
                            if (pse.getFolders().size() > 1) {
                                pse.removeFromFolder(psf);
                                pse.save();
                                continue;
                            }
                            BuddyListManager.addBuddyListGroup("");
                            BuddyListManager.moveBuddyListElement(((PersonalContact)pse).getPrincipal(), grp, "");
                            continue;
                        }
                        if (pse instanceof PersonalContact && !CurrentUserManager.isCurrentUserID(pse.getEntryId()) && pse.getFolders().size() == 1 && ((PersonalContact)pse).getOutboundSubscriptionStatus() == 1) {
                            BuddyListManager.addBuddyListGroup("");
                            BuddyListManager.moveBuddyListElement(((PersonalContact)pse).getPrincipal(), grp, "");
                        }
                        BuddyListManager.removeBuddyListGroupMember(pse.getEntryId(), grp);
                    }
                    if (!"".equals(grp)) {
                        psf.remove();
                    }
                    if (grp.equals(_dummyFolderName)) {
                        iIMPropsUtil.setOrphansFolder(CurrentUserManager.getCurrentUserProperties(), null);
                        _dummyFolderName = buddyListManagerBundle.getString("My_Contacts");
                    }
                    break block11;
                }
                return;
            }
            catch (CollaborationException e) {
                return;
            }
        }
        _sortedBuddyListGroups.remove(grp);
        BuddyListGroup cg = (BuddyListGroup)_htRoot.remove(grp);
        cg = null;
    }

    public static final void removeBuddyListGroupMembers(String[] ids, String g) {
        if (ids == null) {
            return;
        }
        for (int n = 0; n < ids.length; ++n) {
            BuddyListManager.removeBuddyListGroupMember(ids[n], g);
        }
    }

    public static final void removeBuddyListGroupMember(String id, String g) {
        block13: {
            if (id == null || g == null) {
                return;
            }
            try {
                PersonalStoreFolder psf = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", g);
                if (g.equals(_dummyFolderName)) {
                    psf = BuddyListManager.getResolvedDummyFolder(id);
                }
                if (psf == null) break block13;
                PersonalStoreEntry pse = _personalStoreSession.getEntry("contact", id);
                if (pse == null) {
                    pse = _personalStoreSession.getEntry("group", id);
                } else if (pse.getFolders().size() > 1) {
                    pse.removeFromFolder(psf);
                    pse.save();
                } else if (!CurrentUserManager.isCurrentUserID(id)) {
                    PersonalContact pc = (PersonalContact)pse;
                    int inss = pc.getInboundSubscriptionStatus();
                    int outss = pc.getOutboundSubscriptionStatus();
                    BuddyListManager.Out("BuddyListManager remove buddy " + pc.getEntryId() + " outss=" + outss + " inss=" + inss);
                    if (inss == 0 || outss == 0) {
                        BuddyListManager.Out("BuddyListManager calling remove on " + pc.getEntryId());
                        pse.remove();
                    } else {
                        BuddyListManager.Out("BuddyListManager calling unsubscribe on " + pc.getEntryId());
                        pse = null;
                        _presenceSession.unsubscribe(id);
                    }
                }
                if (pse != null) {
                    pse.removeFromFolder(psf);
                    pse.save();
                    break block13;
                }
                return;
            }
            catch (CollaborationException e) {
                return;
            }
        }
        BuddyListGroup cg = (BuddyListGroup)_htRoot.get(g);
        if (cg != null) {
            Manager.Out("BuddyListManager.removeBuddyListGroupMember(): removing element: " + id + " from group: " + g);
            cg.removeMember(id);
        }
    }

    public static final void removeWatcher(String id) {
        if (id == null) {
            return;
        }
        try {
            PersonalStoreEntry pse = _personalStoreSession.getEntry("contact", id);
            if (pse != null) {
                PersonalContact pc = (PersonalContact)pse;
                int outss = pc.getInboundSubscriptionStatus();
                if (outss == 0) {
                    BuddyListManager.Out("BuddyListManager calling remoive on " + pc.getEntryId());
                    pse.remove();
                    pse.save();
                } else {
                    BuddyListManager.Out("BuddyListManager calling cancel on " + pc.getEntryId());
                    _presenceSession.cancel(id);
                }
            }
        }
        catch (CollaborationException e) {
            return;
        }
    }

    public static final boolean isBuddyListGroup(Object o) {
        if (o == null || !(o instanceof String)) {
            return false;
        }
        return _htRoot.containsKey((String)o);
    }

    public static final void renameBuddyListGroup(String g, String to) {
        BuddyListGroup cg;
        BuddyListManager.Out("BuddyListManager.renameBuddyListGroup(): " + g + " to " + to);
        if (g == null || to == null) {
            return;
        }
        try {
            PersonalStoreFolder psf = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", g);
            if (psf != null) {
                psf.rename(to);
                psf.save();
            }
        }
        catch (CollaborationException e) {
            return;
        }
        if (g.equals(_dummyFolderName)) {
            iIMPropsUtil.setOrphansFolder(CurrentUserManager.getCurrentUserProperties(), to);
            _dummyFolderName = to;
        }
        if ((cg = (BuddyListGroup)_htRoot.remove(g)) != null) {
            BuddyListManager.Out("BuddyListManager.renameBuddyListGroup(): adding " + to);
            _htRoot.put(to, cg);
            _sortedBuddyListGroups.remove(g);
            _sortedBuddyListGroups.addElement(to);
            _sortedBuddyListGroups = StringUtility.sort((Vector)_sortedBuddyListGroups);
        }
    }

    public static final void renameBuddyListElement(CollaborationPrincipal p, String name) {
        BuddyListManager.Out("BuddyListManager.renameBuddyListElement(): principal " + p + " name " + name);
        if (p == null || name == null) {
            return;
        }
        try {
            String type = p instanceof CollaborationGroup ? "group" : "contact";
            PersonalStoreEntry pse = _personalStoreSession.getEntry(type, p.getUID());
            if (pse != null) {
                pse.setDisplayName(name);
                pse.save();
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final String getDummyFolderName() {
        return _dummyFolderName;
    }

    public static final void moveBuddyListElement(CollaborationPrincipal p, String fromGroup, String toGroup) {
        if (p == null || fromGroup == null || toGroup == null) {
            return;
        }
        try {
            String type = p instanceof CollaborationGroup ? "group" : "contact";
            PersonalStoreEntry pse = _personalStoreSession.getEntry(type, p.getUID());
            PersonalStoreFolder from = (PersonalStoreFolder)_personalStoreSession.getEntry("book", fromGroup);
            PersonalStoreFolder to = (PersonalStoreFolder)_personalStoreSession.getEntry("book", toGroup);
            if (fromGroup.equals(_dummyFolderName)) {
                from = BuddyListManager.getResolvedDummyFolder(p.getUID());
            }
            if (to == null && toGroup.equals(_dummyFolderName)) {
                to = (PersonalStoreFolder)_personalStoreSession.createEntry("abook", _dummyFolderName);
            }
            if (pse != null && from != null && to != null) {
                pse.removeFromFolder(from);
                pse.addToFolder(to);
                pse.save();
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private static PersonalStoreFolder getResolvedDummyFolder(String id) {
        PersonalStoreFolder from = null;
        try {
            from = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", _dummyFolderName);
            if (from == null) {
                from = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", "");
            } else if (!from.hasEntry(id)) {
                from = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", "");
            }
        }
        catch (CollaborationException collaborationException) {
            // empty catch block
        }
        return from;
    }

    private static PersonalStoreFolder getFolderToCopy(PersonalStoreEntry pse) {
        PersonalStoreFolder psf = null;
        try {
            Iterator itr;
            PersonalStoreFolder temp;
            Collection c = pse.getFolders();
            if (c.size() == 1 && "".equals((temp = (PersonalStoreFolder)(itr = c.iterator()).next()).getDisplayName()) && (psf = (PersonalStoreFolder)_personalStoreSession.getEntry("abook", _dummyFolderName)) == null) {
                psf = (PersonalStoreFolder)_personalStoreSession.createEntry("abook", _dummyFolderName);
            }
        }
        catch (CollaborationException collaborationException) {
            // empty catch block
        }
        return psf;
    }

    public static final void copyBuddyListElement(CollaborationPrincipal p, String toGroup) {
        if (p == null || toGroup == null) {
            return;
        }
        try {
            String type = p instanceof CollaborationGroup ? "group" : "contact";
            PersonalStoreEntry pse = _personalStoreSession.getEntry(type, p.getUID());
            PersonalStoreFolder to = (PersonalStoreFolder)_personalStoreSession.getEntry("book", toGroup);
            if (to == null && toGroup.equals(_dummyFolderName)) {
                to = (PersonalStoreFolder)_personalStoreSession.createEntry("abook", _dummyFolderName);
            }
            if (pse != null && to != null) {
                PersonalStoreFolder psf = BuddyListManager.getFolderToCopy(pse);
                if (psf != null) {
                    pse.addToFolder(psf);
                }
                pse.addToFolder(to);
                pse.save();
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final List sortByElementsStatus(List list) {
        Vector<CollaborationPrincipal> sortedOn = new Vector<CollaborationPrincipal>();
        Vector<CollaborationPrincipal> sortedOff = new Vector<CollaborationPrincipal>();
        LinkedList<CollaborationPrincipal> l = new LinkedList<CollaborationPrincipal>();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            CollaborationPrincipal element = (CollaborationPrincipal)itr.next();
            if (element == null) {
                BuddyListManager.Out("NULL ELEMENT IN ARRAY. ");
                return null;
            }
            if (element instanceof CollaborationGroup) {
                sortedOn.add(element);
                continue;
            }
            String id = element.getUID();
            if (id == null) continue;
            UserInfo ui = UserStatusManager.getUserInfoObject(id);
            if (BuddyListManager.isAuthorizationReq(element)) {
                sortedOn.add(element);
                continue;
            }
            if (ui == null) {
                sortedOn.add(element);
                continue;
            }
            if (ui.isOnLine() || ui.isAway() || ui.isIdle() || ui.isBusy() || ui.isChat()) {
                BuddyListManager.Out("Adding " + id + " to online on list");
                sortedOn.add(element);
                continue;
            }
            if (ui.isOffLine() && Manager.SHOW_ONLY_OFFLINE) {
                sortedOff.add(element);
                continue;
            }
            if (!ui.isPending() || !Manager.SHOW_PENDING_CONTACTS) continue;
            sortedOff.add(element);
        }
        StringUtility.sort(sortedOn);
        l.addAll(sortedOn);
        StringUtility.sort(sortedOff);
        l.addAll(sortedOff);
        BuddyListManager.Out("BuddyListManager.sortByElementStatus(): list.size()=" + list.size());
        sortedOn = null;
        sortedOff = null;
        return l;
    }

    public static final CollaborationPrincipal[] sortByElementsStatus(CollaborationPrincipal[] elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<CollaborationPrincipal> list = new ArrayList<CollaborationPrincipal>(Arrays.asList(elements));
        List l = BuddyListManager.sortByElementsStatus(list);
        BuddyListManager.Out("BuddyListManager.sortByElementStatus(): list.size()=" + l.size());
        return BuddyListManager.toPrincipalArray(l);
    }

    public static final CollaborationPrincipal[] toPrincipalArray(List list) {
        if (list != null && list.size() > 0) {
            CollaborationPrincipal[] p = new CollaborationPrincipal[list.size()];
            int k = 0;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                p[k++] = (CollaborationPrincipal)i.next();
            }
            return p;
        }
        return null;
    }

    public static Vector getWatchers() {
        try {
            Collection c = _personalStoreSession.getEntries("contact");
            Vector<PersonalContact> ret = new Vector<PersonalContact>();
            Iterator ltr = c.iterator();
            while (ltr.hasNext()) {
                PersonalContact pc = (PersonalContact)ltr.next();
                if (!BuddyListManager.isWatcher(pc) || ret.contains(pc)) continue;
                ret.addElement(pc);
            }
            return ret;
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAuthorizationReq(CollaborationPrincipal c) {
        PersonalContact pc = null;
        if (!(c instanceof CollaborationGroup)) {
            try {
                pc = (PersonalContact)Manager._personalStoreSession.getEntry("contact", c.getUID());
            }
            catch (CollaborationException e) {
                return false;
            }
            if (pc == null) {
                return true;
            }
            return pc.getInboundSubscriptionStatus() == 0;
        }
        return false;
    }

    public static void loadGateways() {
        if (!Manager.ALLOW_PRESENCE_ACCESS) {
            return;
        }
        _gateways = new ArrayList();
        Collection gateways = null;
        try {
            gateways = _personalStoreSession.getEntries("gateway");
        }
        catch (CollaborationException e) {
            Manager.warning("Unabe to get Gateway entries " + (Object)((Object)e));
            return;
        }
        Iterator i = gateways.iterator();
        while (i.hasNext()) {
            _gateways.add(i.next());
        }
    }

    public static PersonalGateway[] getGateways() {
        if (_gateways != null) {
            return _gateways.toArray(new PersonalGateway[_gateways.size()]);
        }
        return null;
    }

    static {
        _dummyFolderName = ID_MY_CONTACTS = buddyListManagerBundle.getString("My_Contacts");
    }

    static final class LoadBuddyListThread
    implements Runnable {
        LoadBuddyListThread() {
        }

        public void run() {
            Manager.Out("BuddyListManager.LoadBuddyListThread.run(): Thread starting");
            try {
                BuddyListManager.loadBuddyListNow();
            }
            catch (CollaborationException e) {
                Manager.Out("Exception: " + (Object)((Object)e));
            }
            Manager.Out("BuddyListManager.LoadBuddyListThread.run(): Thread terminating");
        }
    }
}

