/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.ServerElement;
import com.iplanet.im.client.manager.ServerGroup;
import com.iplanet.im.client.manager.ServerUser;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

class BuddyListGroup {
    private Vector _vMembers = new Vector();
    private boolean _isExpanded = false;

    public void addMember(ServerElement serverElement) {
        if (serverElement == null) {
            return;
        }
        if (this._vMembers.contains(serverElement)) {
            return;
        }
        this._vMembers.add(serverElement);
    }

    public void setMembers(ServerElement[] serverElements) {
        if (serverElements.length <= 0) {
            return;
        }
        this._vMembers.removeAllElements();
        for (int i = 0; i < serverElements.length; ++i) {
            this.addMember(serverElements[i]);
        }
    }

    public void setMembers(CollaborationPrincipal[] elements) {
        if (elements.length <= 0) {
            return;
        }
        this._vMembers.removeAllElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] instanceof CollaborationGroup) {
                this.addMember(new ServerGroup(((CollaborationGroup)elements[i]).getUID()));
                continue;
            }
            if (!(elements[i] instanceof CollaborationPrincipal)) continue;
            this.addMember(new ServerUser(elements[i].getUID()));
        }
    }

    public void removeMember(String uid) {
        Manager.Out("BuddyListGroup.removeMember(): " + uid);
        if (uid == null) {
            return;
        }
        if (uid.startsWith("g:")) {
            uid = uid.substring(2);
        }
        for (int i = 0; i < this._vMembers.size(); ++i) {
            if (!((ServerElement)this._vMembers.get(i)).getUID().equals(uid)) continue;
            Manager.Out("BuddyListGroup.removeMember(): removing " + uid);
            this._vMembers.remove(i);
            break;
        }
    }

    public int getMemberCount() {
        return this._vMembers.size();
    }

    public List getMembers() {
        LinkedList<CollaborationPrincipal> l = new LinkedList<CollaborationPrincipal>();
        try {
            Iterator i = this._vMembers.iterator();
            while (i.hasNext()) {
                l.add(((ServerElement)i.next()).getServerElement());
            }
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
        }
        return l;
    }

    public boolean isMember(String uid) {
        boolean isMember = false;
        if (uid == null) {
            return false;
        }
        if (uid.startsWith("g:")) {
            uid = uid.substring(2);
        }
        for (int i = 0; i < this._vMembers.size(); ++i) {
            if (!((ServerElement)this._vMembers.get(i)).getUID().equals(uid)) continue;
            isMember = true;
            break;
        }
        return isMember;
    }

    public boolean isMember(CollaborationPrincipal element) {
        boolean isMember = false;
        try {
            for (int i = 0; i < this._vMembers.size(); ++i) {
                if (!((ServerElement)this._vMembers.get(i)).getServerElement().equals(element)) continue;
                isMember = true;
                break;
            }
        }
        catch (CollaborationException e) {
            Manager.Out("Exception: " + (Object)((Object)e));
        }
        return isMember;
    }

    public void clear() {
        this._vMembers.removeAllElements();
    }

    public void setExpanded(boolean b) {
        this._isExpanded = b;
    }

    public void toggleExpansion() {
        this._isExpanded = !this._isExpanded;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }
}

