/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.manager;

import com.iplanet.im.client.jni.JNILink;
import com.iplanet.im.client.manager.FrameListActionListener;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.topic.TopicView;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.util.PlatformUtil;
import java.awt.Frame;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ApplicationManager
extends Manager {
    public static boolean AUTO_CLOSE = false;
    public static boolean CHECKED_VERSIONS = false;
    public static boolean USE_JNI_PATH = false;
    public static int MAX_FILE_SIZE = -1;
    public static boolean NETLERT_CAN_EXIT = true;
    private static LinkedList _openWindows = new LinkedList();
    private static FrameListActionListener _action = new FrameListActionListener();
    static SafeResourceBundle applicationManagerBundle = new SafeResourceBundle("com.iplanet.im.client.manager.manager");

    public static final Collection getActiveFrames() {
        return (Collection)_openWindows.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setFrameListInMenu(Frame currentFrame, JMenu menu) {
        FrameListActionListener frameListActionListener = _action;
        synchronized (frameListActionListener) {
            Iterator i = _openWindows.iterator();
            while (i.hasNext()) {
                Frame f = (Frame)i.next();
                if (f == currentFrame) continue;
                JMenuItem menuItem = _action.getMenuItem(f);
                menu.add(menuItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isLastActiveObject() {
        int active = 0;
        FrameListActionListener frameListActionListener = _action;
        synchronized (frameListActionListener) {
            Iterator i = _openWindows.iterator();
            while (i.hasNext()) {
                Frame f = (Frame)i.next();
                if (f instanceof Communicator || f instanceof TopicView) {
                    ++active;
                }
                if (active <= 1) continue;
                break;
            }
        }
        return active <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addActiveObject(Frame f) {
        FrameListActionListener frameListActionListener = _action;
        synchronized (frameListActionListener) {
            if (!_openWindows.contains(f)) {
                _openWindows.add(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeActiveObject(Frame f) {
        FrameListActionListener frameListActionListener = _action;
        synchronized (frameListActionListener) {
            _openWindows.remove(f);
            _action.remove(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void close() {
        Iterator i = ApplicationManager.getActiveFrames().iterator();
        while (i.hasNext()) {
            Frame f = (Frame)i.next();
            Manager.Out("[ApplicationManager] closing frame " + f.getClass().getName());
            ApplicationManager.removeActiveObject(f);
            f.setVisible(false);
            f.dispose();
        }
        FrameListActionListener frameListActionListener = _action;
        synchronized (frameListActionListener) {
            _openWindows.clear();
        }
    }

    public static final void refreshFrame(Frame f, boolean min, boolean tofront) {
        Manager.Out("[ApplicationManager] Refreshing Frame: " + f.getClass().getName());
        f.setVisible(true);
        if (PlatformUtil.isJava2()) {
            if (min) {
                f.setState(1);
            } else {
                f.setState(0);
                if (tofront) {
                    f.toFront();
                }
            }
        }
    }

    public static void refresh() {
        SwingUtilities.invokeLater(new RestoreFramesRunnable());
    }

    public static final void initJNI() {
        if (Manager._is_applet) {
            return;
        }
        if (USE_JNI_PATH) {
            JNILink.loadJNILibrary();
        } else {
            JNILink.loadJNILibraryNoPath();
        }
    }

    public static final boolean hasOpenWindows() {
        return _openWindows.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void showMessageBox(String msg) {
        Frame parent = null;
        boolean newFrameCreated = false;
        FrameListActionListener frameListActionListener = _action;
        synchronized (frameListActionListener) {
            if (_openWindows.size() != 0) {
                parent = (Frame)_openWindows.get(0);
            } else {
                parent = new Frame();
                newFrameCreated = true;
            }
        }
        JOptionPane.showMessageDialog(parent, msg);
        if (newFrameCreated) {
            parent.dispose();
        }
    }

    public static final boolean isFileTooLarge(File f) {
        if (MAX_FILE_SIZE < 0) {
            return false;
        }
        if (f.length() > (long)MAX_FILE_SIZE) {
            String msg = "File is too large to send! \n";
            String msg2 = applicationManagerBundle.getString("File_is_too_large_to_send");
            ApplicationManager.showMessageBox("File is too large to send! \n" + msg2);
            return true;
        }
        return false;
    }

    static class RestoreFramesRunnable
    implements Runnable {
        RestoreFramesRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FrameListActionListener frameListActionListener = _action;
            synchronized (frameListActionListener) {
                Iterator i = _openWindows.iterator();
                while (i.hasNext()) {
                    Frame f = (Frame)i.next();
                    ApplicationManager.refreshFrame(f, false, true);
                }
            }
        }
    }
}

