/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.install;

import com.sun.im.service.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JnlpParser {
    private Collection arguments;
    private String application;
    private String version;
    private String server;
    private String codeBase;
    private String helpCodeBase;
    private String locale;

    public Collection getArguments() {
        return this.arguments;
    }

    public void addArgument(String arg) {
        this.arguments.add(arg);
    }

    public void setApplication(String javaClass) {
        this.application = javaClass;
    }

    public void setJnlpSpecVersion(String version) {
        this.version = version;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setCodeBase(String codebase) {
        this.codeBase = codebase;
    }

    public void setHelpCodeBase(String helpCodeBase) {
        this.helpCodeBase = helpCodeBase;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getJnlpSpecVersion() {
        return this.version;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getCodeBase() {
        return this.codeBase;
    }

    public String getHelpCodeBase() {
        return this.helpCodeBase;
    }

    public String getServer() {
        return this.server;
    }

    public void getApplication(String javaClass) {
        this.application = javaClass;
    }

    public void buildJnlp(Document doc) {
        Element root = doc.getDocumentElement();
        this.setCodeBase(root.getAttribute("codebase"));
        this.setJnlpSpecVersion(root.getAttribute("spec"));
        String href = root.getAttribute("href");
        int startIndex = href.indexOf("/");
        if (startIndex != -1) {
            this.setLocale(href.substring(0, startIndex));
        }
        NodeList arguments = doc.getElementsByTagName("argument");
        for (int i = 0; i < arguments.getLength(); ++i) {
            Node arg = arguments.item(i);
            NodeList argValues = arg.getChildNodes();
            Node argValueNode = argValues.item(0);
            String argValue = argValueNode.getNodeValue();
            if (argValue.indexOf("server=") != -1) {
                startIndex = argValue.indexOf("=");
                this.setServer(argValue.substring(startIndex + 1));
                continue;
            }
            if (argValue.indexOf("help_codebase=") != -1) {
                this.setHelpCodeBase(argValue);
                continue;
            }
            System.out.println("not a server argument neither helpcode");
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java -cp jaxp.jar:imnet.jar:msgrinstall.jar JnlpParser  IMDocRoot locale");
        }
        String enDocDir = args[0];
        String locale = args[1];
        String localizedDocDir = enDocDir + File.separator + locale;
        JnlpParser jnlpDoc = JnlpParser.parse(enDocDir);
        JnlpParser.generateFiles(jnlpDoc, enDocDir, locale);
    }

    public static JnlpParser parse(String enDocDir) {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setValidating(false);
        fac.setNamespaceAware(false);
        Document doc = null;
        DocumentBuilder builder = null;
        JnlpParser jnlpDoc = null;
        enDocDir = enDocDir + File.separator + "en";
        try {
            builder = fac.newDocumentBuilder();
            doc = builder.parse(new File(enDocDir + File.separator + "im.jnlp"));
            jnlpDoc = new JnlpParser();
            jnlpDoc.buildJnlp(doc);
        }
        catch (SAXException se) {
            System.out.println("Error while parsing the jnlp document");
            se.printStackTrace();
        }
        catch (ParserConfigurationException pse) {
            System.out.println("Error while parsing the jnlp document");
            pse.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("Error in opening the file" + enDocDir);
            ioe.printStackTrace();
        }
        return jnlpDoc;
    }

    public static void generateFiles(JnlpParser jnlpDoc, String enDocDir, String locale) {
        String localizedDocDir = enDocDir + File.separator + locale;
        String codebase = jnlpDoc.getCodeBase();
        String server = jnlpDoc.getServer();
        System.out.println("codebase = " + codebase);
        System.out.println("server = " + server);
        System.out.println("locale = " + locale);
        HashMap<String, String> hmap = new HashMap<String, String>();
        hmap.put("INSERT_LOCALE_HERE", locale);
        hmap.put("INSERT_SERVER_HERE", server);
        hmap.put("INSERT_CODEBASE_HERE", codebase);
        hmap.put("INSERT_USESSL_HERE", "true");
        File infile = null;
        File outfile = null;
        try {
            infile = new File(localizedDocDir + File.separator + "im.jnlp.template");
            outfile = new File(localizedDocDir + File.separator + "im.jnlp");
            FileUtility.findReplace((File)infile, (File)outfile, hmap, null, (String)"ISO-8859-1");
            infile = new File(localizedDocDir + File.separator + "imssl.jnlp.template");
            outfile = new File(localizedDocDir + File.separator + "imssl.jnlp");
            FileUtility.findReplace((File)infile, (File)outfile, hmap, null, (String)"ISO-8859-1");
            infile = new File(localizedDocDir + File.separator + "im.html.template");
            outfile = new File(localizedDocDir + File.separator + "im.html");
            FileUtility.findReplace((File)infile, (File)outfile, hmap, null, (String)"ISO-8859-1");
            infile = new File(localizedDocDir + File.separator + "imssl.html.template");
            outfile = new File(localizedDocDir + File.separator + "imssl.html");
            FileUtility.findReplace((File)infile, (File)outfile, hmap, null, (String)"ISO-8859-1");
        }
        catch (IOException ioe) {
            System.out.println("Error in opening the file " + infile + " " + outfile);
            ioe.printStackTrace();
        }
    }
}

