/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client;

import com.iplanet.im.client.jni.JNILink;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.MBeanManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.TopicManager;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.manager.WebStartManager;
import com.iplanet.im.client.swing.Alert;
import com.iplanet.im.client.swing.BuddyList;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.Client;
import com.iplanet.im.client.swing.Poll;
import com.iplanet.im.client.swing.SubscriptionListener;
import com.iplanet.im.client.swing.Topics;
import com.iplanet.im.client.swing.calendar.CalendarBean;
import com.iplanet.im.client.swing.chat.bean.RoomView;
import com.iplanet.im.client.swing.login.LoginDialog;
import com.iplanet.im.client.util.Orientation;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.ViewUtility;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.iplanet.im.client.util.iIMUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class iIM {
    static SafeResourceBundle communicatorBundle;
    static SafeResourceBundle iIMBundle;
    static SafeResourceBundle brandBundle;
    public static String VERSION;
    public static String IPADDRESS;
    public static final String FILEEXT = "file:///";
    private static boolean SHOW_SPLASH;
    public static boolean GET_IP;
    public static boolean ENCODE_PW;
    public static boolean OPTIMIZE;
    private static String helpCodebase;
    private static String savedStatus;
    private static String savedStatusString;
    private static String previousStatusStr;
    private static ImageIcon savedIcon;
    public static LoginDialog _login;
    public static Client _client;
    public static Chat _chat;
    public static BuddyList _buddylist;
    public static Topics _topics;
    public static Alert _alert;
    public static Poll _poll;
    public static String ID_NO_PRIVILEGE;

    private static void initDebug() {
        String logConfig = Manager.getParameter("logconfig", null);
        String debug = null;
        String fileName = null;
        if (logConfig != null) {
            fileName = logConfig;
            if ("ALL".equalsIgnoreCase(logConfig)) {
                fileName = "com/sun/im/desktop/log/all_log.properties";
            } else if ("API".equalsIgnoreCase(logConfig)) {
                fileName = "com/sun/im/desktop/log/api_log.properties";
            } else if ("CLIENT".equalsIgnoreCase(logConfig)) {
                fileName = "com/sun/im/desktop/log/client_log.properties";
            } else if ("XMPPTRAFFIC".equalsIgnoreCase(logConfig)) {
                fileName = "com/sun/im/desktop/log/xmpptraffic_log.properties";
            }
        } else {
            debug = Manager.getParameter("debug", null);
            if (debug != null) {
                boolean flag = false;
                try {
                    flag = StringUtility.getBoolean((String)debug);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Orientation.setDebugEnabled(flag);
                if (flag) {
                    fileName = "com/sun/im/desktop/log/all_console_log.properties";
                }
            }
        }
        if (fileName == null || "".equals(fileName.trim())) {
            fileName = "com/sun/im/desktop/log/default_log.properties";
        }
        System.setProperty("log4j.configuration", fileName);
        Manager.createLogger();
        Manager.debug("Using log config : " + fileName);
    }

    public static void init(boolean auto_connect) {
        boolean autologon = auto_connect;
        if (Manager._is_applet) {
            iIM.initDebug();
            iIM.initParams();
        }
        iIM.loadLocalProperties();
        Properties authProps = Manager.NetLertProperties;
        if (!authProps.containsKey("net.nms") && Manager._server != null && !Manager._server.equals("")) {
            authProps.put("net.nms", Manager._server);
        }
        if (Manager._uid != null && Manager._uid.length() > 0 && Manager._server != null && Manager._server.length() > 0 && Manager._token != null && Manager._token.length() > 0) {
            authProps.put("net.user", Manager._uid);
            authProps.put("net.nms", Manager._server);
            authProps.put("net.password", Manager._token);
        }
        if (authProps.containsKey("net.nms") && authProps.containsKey("net.password") && authProps.containsKey("net.user")) {
            Manager.Out("Initiate Auto Logon");
            autologon = true;
        }
        ApplicationManager.initJNI();
        if (!OPTIMIZE) {
            iIM.initLAF();
        }
        iIM.startLogon(autologon);
    }

    private static void initSecureOption(String secure) {
        Manager.Out("INIT secure:" + secure);
        try {
            if (StringUtility.getBoolean((String)secure)) {
                Manager._is_portal_env = true;
                Manager._is_portal_secure = true;
            } else {
                Manager._is_portal_env = true;
                Manager._is_portal_secure = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initSSLOption(String usessl) {
        block4: {
            Manager.Out("INIT usessl: " + usessl);
            try {
                if (StringUtility.getBoolean((String)usessl)) {
                    Manager._use_ssl = true;
                    Manager._use_ssl_optional = false;
                } else {
                    Manager._use_ssl = false;
                    Manager._use_ssl_optional = false;
                }
            }
            catch (Exception e) {
                if (!usessl.equalsIgnoreCase("optional")) break block4;
                Manager._use_ssl = true;
                Manager._use_ssl_optional = true;
            }
        }
    }

    private static void initRegister(String regis) {
        Manager.Out("INIT register: " + regis);
        try {
            Manager._register = StringUtility.getBoolean((String)regis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initModeratedChatOption(String moderatedchat) {
        Manager.Out("INIT moderatedchat:" + moderatedchat);
        try {
            if (moderatedchat != null) {
                Manager.MODERATED_FEATURE = StringUtility.getBoolean((String)moderatedchat);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initShowPostUserOption(String showpost) {
        Manager.Out("INIT showpostuser:" + showpost);
        try {
            if (showpost != null) {
                Manager.SHOW_POSTED_USER = StringUtility.getBoolean((String)showpost);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initTryLdapOption(String tryldap) {
        Manager.Out("INIT tryldap:" + tryldap);
        try {
            if (tryldap != null) {
                Manager.TRY_LDAP_LOGIN = StringUtility.getBoolean((String)tryldap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initAllowAlertOnlyOption(String str) {
        Manager.Out("INIT allow_alert_only: " + str);
        try {
            if (str != null) {
                Manager.ALLOW_ALERT_ONLY = StringUtility.getBoolean((String)str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initAllowAttachments(String str) {
        Manager.Out("INIT allow_attachments: " + str);
        try {
            if (str != null) {
                Manager.ALLOW_ATTACHMENTS = StringUtility.getBoolean((String)str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initArchiveControl(String str) {
        Manager.Out("INIT archive_control: " + str);
    }

    private static void initCalReminder(String str) {
        try {
            if (str != null && !StringUtility.getBoolean((String)str)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MBeanManager.addFactory(new CalendarBean());
        Manager.Out("Loaded Calendar reminder listener");
    }

    private static void initAutoJoin(String str) {
        Manager.Out("INIT autojoin: " + str);
        StringTokenizer st = new StringTokenizer(str, ",");
        if (st != null) {
            LinkedList list = new LinkedList();
            while (st.hasMoreTokens()) {
                String uid = st.nextToken().trim();
                RoomManager.addAutoJoin(uid);
            }
        }
    }

    private static void initAutoInvite(String str) {
        Manager.Out("INIT autoinvite: " + str);
        StringTokenizer st = new StringTokenizer(str, ",");
        if (st != null) {
            LinkedList<String> list = new LinkedList<String>();
            while (st.hasMoreTokens()) {
                String uid = st.nextToken().trim();
                list.add(uid);
            }
            if (!list.isEmpty()) {
                RoomManager.addAutoInvite(list);
            }
        }
    }

    private static void initLocale(String str) {
        Manager.Out("INIT Locale: " + str);
        if (str == null) {
            return;
        }
        StringTokenizer tk = new StringTokenizer(str, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        Locale.setDefault(new Locale(lang, country, variant));
    }

    private static void initResources() {
        communicatorBundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");
        iIMBundle = new SafeResourceBundle("com.iplanet.im.client.client");
        brandBundle = new SafeResourceBundle("com.sun.im.desktop.brand.brand", "com.sun.im.desktop.default.brand.brand");
        VERSION = brandBundle.getString("messenger.version");
        IPADDRESS = iIMBundle.getString("Unknown");
        ID_NO_PRIVILEGE = iIMBundle.getString("You_do_not_have_the_proper_privilege");
    }

    private static void initForceOrientation(String orientation) {
        if (orientation == null) {
            return;
        }
        Manager.Out("INIT force_orientation: " + orientation);
        Manager.Out("DEBUG: iIM.initForceOrientation(): Orientation.isLeftToRight(): " + Orientation.isLeftToRight());
        if (orientation.equalsIgnoreCase("rtl")) {
            Manager.Out("DEBUG: iIM.initForceOrientation(): forcing right to left");
            Orientation.forceOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else if (orientation.equalsIgnoreCase("ltr")) {
            Manager.Out("DEBUG: iIM.initForceOrientation(): forcing left to right");
            Orientation.forceOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        Manager.Out("DEBUG: iIM.initForceOrientation(): Orientation.isLeftToRight(): " + Orientation.isLeftToRight());
    }

    public static final void startLogon(boolean auto_connect) {
        Manager.Out("startLogon()");
        if (_login != null) {
            _login.dispose();
            _login = null;
        }
        _login = new LoginDialog(auto_connect);
        HelpManager.init(_login, helpCodebase);
        if (auto_connect) {
            String result = _login.connect(Manager.NetLertProperties);
            if (result != null) {
                if (Manager._is_portal_env) {
                    _login.setVisible(false);
                    String msg = Manager._is_portal_secure ? iIMBundle.getString("login_failed_secure") : iIMBundle.getString("login_failed");
                    JOptionPane.showMessageDialog(_login, msg, iIMBundle.getString("login_failed_title"), 0);
                    iIM.exit(false);
                } else {
                    JOptionPane.showMessageDialog(_login, result);
                    _login.setVisible(false);
                    _login.close(false);
                    _login = new LoginDialog(false);
                    HelpManager.init(_login, helpCodebase);
                    _login.loadDefaultSettings();
                }
            } else {
                if (!Manager._is_portal_env) {
                    Manager._auto_logon = true;
                }
                _login.setVisible(false);
            }
        } else {
            _login.loadDefaultSettings();
        }
        _login.requestDefaultFocus();
        if (!auto_connect) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        Manager.initManager();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            t.start();
        }
    }

    public static final void loadNetLert(int flavor) {
        boolean aReasonForAnything;
        Manager.Out("loadiIM()");
        boolean aReasonToShowTheBuddyList = Manager.ALLOW_PRESENCE_ACCESS || Manager.ALLOW_ROOM_ACCESS;
        boolean bl = aReasonForAnything = aReasonToShowTheBuddyList || Manager.ALLOW_RECEIVE_ALERTS || Manager.ALLOW_NEWS_ACCESS;
        if (!aReasonForAnything) {
            JOptionPane.showMessageDialog(null, iIMBundle.getString("no_access_to_functionality"), iIMBundle.getString("no_access_to_functionality_title"), 0);
            iIM.exit(true);
        }
        if (Manager._session == null) {
            System.out.println("Could not load messenger - No connection to server");
            iIM.exit(false);
        }
        if (_buddylist != null) {
            _buddylist.removeTrayIcon();
        }
        if (_client != null) {
            _client.stop();
        }
        iIM.closeMainViews();
        _client = new Client(_login);
        _client.init();
        _alert = new Alert(_client);
        _alert.init();
        if (Manager.ALLOW_CHAT || Manager.ALLOW_ROOM_ACCESS) {
            Manager.Out("iIM.loadNetLert(): Initialize chat");
            _chat = new Chat(_client);
        }
        if (Manager.ALLOW_PRESENCE_ACCESS || Manager.ALLOW_ROOM_ACCESS) {
            Manager.Out("iIM.loadNetLert(): Initialize buddy list");
            _buddylist = new BuddyList(_client);
            _buddylist.init();
        }
        if (Manager.ALLOW_NEWS_ACCESS && !Manager.ALLOW_PRESENCE_ACCESS && !Manager.ALLOW_ROOM_ACCESS) {
            iIM.showTopicView();
        }
        if (Manager.ALLOW_POLLS) {
            Manager.Out("iIM.loadNetLert(): Initialize poll");
            _poll = new Poll(_client);
            _poll.init();
        }
        _client.showViews(flavor);
        if (!ApplicationManager.hasOpenWindows() && !Manager.ALLOW_ALERT_ONLY) {
            Manager.Out("No frame could be opened.  Exiting");
            Manager.exit(1);
        }
    }

    private static final void printOptions() {
        Manager.Out(".... EXTRA DEBUG OPTIONS - THESE OPTIONS ARE SUBJECT TO CHANGE AND MAY NOT BE SUPPORTED.....");
        Manager.Out("....Usage:   iIM -option1 [arg] -option2 [arg]");
        Manager.Out("    -p propfile.name   Name of property file to use");
        Manager.Out("    -nojni             do not load win32 dll");
        Manager.Out("    -debug             Turn ON Debugging Print-Outs");
        Manager.Out("    -chatbuffer size   Size of viewable Chat buffer (default 5000)");
        Manager.Out("    -nothreadedsound   Turn Off Threaded Sound");
        Manager.Out("    -nostrongsound     Turn Off New Strong Sound");
        Manager.Out("    -nochatattach      Turn Off Ability to send Chat attachments");
        Manager.Out("    -nomsgattach       Turn Off Ability to send Any attachments");
        Manager.Out("    -maxfilesize size  Max file of sendable file in KB");
        Manager.Out("    -jnifilename       name of jni library to load if different from clientjni");
        Manager.Out("    -nopwencoding      turn off password encoding");
        Manager.Out("    -autoclose         do not ask before closing client");
        Manager.Out("    -workercount       # of worker threads to create");
        Manager.Out("    -nosplash          turn of opening splash screen");
        Manager.Out("    -usejnipath        include path when loading jni dll");
        Manager.Out("    -splashurl         url of splash screen img");
        Manager.Out("    -backgroundurl     url of background img");
        Manager.Out("    -optimize          Optimize client by removing added view formatting");
        Manager.Out("\n");
    }

    private static int getNextArg(int index, String[] args, iIMArgument arg) {
        int equalIndex = args[index].indexOf(61);
        if (equalIndex > 0) {
            arg.parameter = args[index].substring(0, equalIndex).trim();
            arg.value = args[index].substring(equalIndex + 1).trim();
            return index;
        }
        if (args.length > index + 1) {
            arg.parameter = args[index].trim();
            arg.value = args[index + 1].trim();
            return index + 1;
        }
        arg.parameter = null;
        arg.value = null;
        return index + 1;
    }

    private static final void initArgs(String[] argv) {
        String enableCalReminder = "true";
        String param = null;
        for (int n = 0; n < argv.length; ++n) {
            iIMArgument arg = new iIMArgument();
            n = iIM.getNextArg(n, argv, arg);
            param = arg.parameter;
            if (param == null) {
                return;
            }
            WebStartManager.setParameter(param, arg.value);
        }
        iIM.initDebug();
        Enumeration e = WebStartManager.getParameterKeys();
        while (e.hasMoreElements()) {
            param = (String)e.nextElement();
            String value = WebStartManager.getParameter(param);
            if (param.equalsIgnoreCase("server") || param.equalsIgnoreCase("-server")) {
                Manager._server = value;
                continue;
            }
            if (param.equalsIgnoreCase("resource") || param.equalsIgnoreCase("-resource")) {
                Manager._resource = value;
                continue;
            }
            if (param.equalsIgnoreCase("locale")) {
                iIM.initLocale(value);
                continue;
            }
            if (param.equalsIgnoreCase("uid")) {
                Manager._uid = value;
                continue;
            }
            if (param.equalsIgnoreCase("domain")) {
                Manager._domain = value;
                continue;
            }
            if (param.equalsIgnoreCase("token")) {
                Manager._token = value;
                continue;
            }
            if (param.equalsIgnoreCase("secure")) {
                iIM.initSecureOption(value);
                continue;
            }
            if (param.equalsIgnoreCase("usessl")) {
                iIM.initSSLOption(value);
                continue;
            }
            if (param.equalsIgnoreCase("register") || param.equalsIgnoreCase("-register")) {
                iIM.initRegister(value);
                continue;
            }
            if (param.equalsIgnoreCase("modchat_maxtableitems")) {
                Manager.MAX_MODERATED_TABLE_ITEMS = Integer.parseInt(value);
                continue;
            }
            if (param.equalsIgnoreCase("modchat_enable")) {
                iIM.initModeratedChatOption(value);
                continue;
            }
            if (param.equalsIgnoreCase("modchat_showpostuser")) {
                iIM.initShowPostUserOption(value);
                continue;
            }
            if (param.equalsIgnoreCase("try_ldap_login")) {
                iIM.initTryLdapOption(value);
                continue;
            }
            if (param.equalsIgnoreCase("allow_alert_only")) {
                iIM.initAllowAlertOnlyOption(value);
                continue;
            }
            if (param.equalsIgnoreCase("allow_alert_only")) {
                iIM.initAllowAlertOnlyOption(value);
                continue;
            }
            if (param.equalsIgnoreCase("mbean")) {
                MBeanManager.init(value);
                continue;
            }
            if (param.equalsIgnoreCase("flavor")) {
                Manager.initFlavor(value);
                continue;
            }
            if (param.equalsIgnoreCase("allow_attachments")) {
                iIM.initAllowAttachments(value);
                continue;
            }
            if (param.equalsIgnoreCase("archive_control")) {
                iIM.initArchiveControl(value);
                continue;
            }
            if (param.equalsIgnoreCase("calendar_alert")) {
                enableCalReminder = value;
                continue;
            }
            if (param.equalsIgnoreCase("autoinvite")) {
                iIM.initAutoInvite(value);
                continue;
            }
            if (param.equalsIgnoreCase("autojoin")) {
                iIM.initAutoJoin(value);
                continue;
            }
            if (param.equalsIgnoreCase("help_codebase")) {
                helpCodebase = value;
                continue;
            }
            if (param.equalsIgnoreCase("force_orientation")) {
                iIM.initForceOrientation(value);
                continue;
            }
            if (!param.equalsIgnoreCase("gateway_url")) continue;
            Manager.gateway_url = value;
        }
        iIM.initResources();
        iIM.initCalReminder(enableCalReminder);
    }

    private static final void initParams() {
        Manager._uid = Manager.getParameter("uid", null);
        Manager._domain = Manager.getParameter("domain", null);
        Manager._server = Manager.getParameter("server", null);
        if (Manager._server == null) {
            Manager._server = Manager.getParameter("-server", null);
        }
        if ((Manager._resource = Manager.getParameter("resource", null)) == null) {
            Manager._resource = Manager.getParameter("-resource", null);
        }
        Manager._token = Manager.getParameter("token", null);
        String s = Manager.getParameter("locale", null);
        if (s != null) {
            iIM.initLocale(s);
        }
        iIM.initResources();
        s = Manager.getParameter("secure", "");
        iIM.initSecureOption(s);
        s = Manager.getParameter("usessl", "");
        iIM.initSSLOption(s);
        s = Manager.getParameter("register", "");
        iIM.initRegister(s);
        s = Manager.getParameter("modchat_maxtableitems", null);
        if (s != null) {
            Manager.MAX_MODERATED_TABLE_ITEMS = Integer.parseInt(s);
        }
        s = Manager.getParameter("modchat_enable", "");
        iIM.initModeratedChatOption(s);
        s = Manager.getParameter("try_ldap_login", "");
        iIM.initTryLdapOption(s);
        s = Manager.getParameter("modchat_showpostuser", "");
        iIM.initShowPostUserOption(s);
        s = Manager.getParameter("allow_alert_only", null);
        iIM.initAllowAlertOnlyOption(s);
        s = Manager.getParameter("mbean", null);
        if (s != null) {
            MBeanManager.init(s);
        }
        if ((s = Manager.getParameter("flavor", null)) != null) {
            Manager.initFlavor(s);
        }
        if ((s = Manager.getParameter("allow_attachments", null)) != null) {
            iIM.initAllowAttachments(s);
        }
        if ((s = Manager.getParameter("archive_control", null)) != null) {
            iIM.initArchiveControl(s);
        }
        s = Manager.getParameter("calendar_alert", null);
        iIM.initCalReminder(s);
        s = Manager.getParameter("autoinvite", null);
        if (s != null) {
            iIM.initAutoInvite(s);
        }
        if ((s = Manager.getParameter("autojoin", null)) != null) {
            iIM.initAutoJoin(s);
        }
        helpCodebase = Manager.getParameter("help_codebase", null);
        s = Manager.getParameter("force_orientation", "");
        iIM.initForceOrientation(s);
        Manager.gateway_url = Manager.getParameter("gateway_url", null);
    }

    public static void main(String[] argv) {
        System.setProperty("apple.mrj.application.growbox.intrudes", "false");
        iIM.loadMacMenubar();
        iIM.initArgs(argv);
        Manager.Out("Starting messenger...");
        long time = System.currentTimeMillis();
        Manager._is_applet = false;
        Manager.Out("Messenger version: " + VERSION);
        Manager.Out("Protocol version:  " + iIMUtility.getNETVersion());
        Manager.Out("JRE version:       " + PlatformUtil.getJavaVersion());
        Manager.Out("Operating System:  " + PlatformUtil.getOSName());
        if (PlatformUtil.is98() || PlatformUtil.is95()) {
            PlatformUtil.loadWinSock();
        }
        savedStatus = "OPEN";
        savedIcon = null;
        previousStatusStr = savedStatusString = communicatorBundle.getString("Online");
        iIM.init(false);
        iIM.printElapsedTime(time);
        iIM.GarbageCollect();
    }

    public static void loadMacMenubar() {
        if (PlatformUtil.isMac()) {
            System.setProperty("com.apple.laf.useScreenMenuBar", "true");
        }
    }

    private static final void loadLocalProperties() {
        String filename = "messenger.properties";
        if (PlatformUtil.isOS2()) {
            filename = "messenger.prp";
        }
        try {
            File tmpf = new File(PlatformUtil.getHomeDir(), ".sunmsgr");
            if (!tmpf.exists()) {
                tmpf.mkdir();
            }
            FileUtility.setFilePermissions((File)tmpf, (String)"0700");
            tmpf = new File(tmpf, filename);
            Manager._propFileName = tmpf.toString();
            Properties p = iIMPropsUtil.loadNLProperties(Manager._propFileName);
            if (p != null) {
                Manager.NetLertProperties = p;
            }
        }
        catch (Exception e) {
            Manager.NetLertProperties = new Properties();
            Manager._propFileName = null;
        }
    }

    private static final void printElapsedTime(long time) {
        StringBuffer buf = new StringBuffer(" \n TIME TO LOAD: < ");
        buf.append(System.currentTimeMillis() - time);
        buf.append(" >\n");
        Manager.Out(buf.toString());
        buf = null;
    }

    public static final void initLAF() {
        UIManager.put("Button.textIconGap", new Integer(0));
        String lafClassName = Manager.NetLertProperties.getProperty("messenger.lookandfeel." + PlatformUtil.getNoSpaceOSName());
        if (lafClassName != null && (lafClassName = lafClassName.trim()).length() > 0) {
            try {
                ViewUtility.setLAF(lafClassName);
                return;
            }
            catch (Exception e) {
                System.out.println("Failed to set look and feel: " + lafClassName + " : " + e.toString());
            }
        }
        if ((lafClassName = Manager.NetLertProperties.getProperty("messenger.lookandfeel")) != null && (lafClassName = lafClassName.trim()).length() > 0) {
            try {
                ViewUtility.setLAF(lafClassName);
                return;
            }
            catch (Exception e) {
                System.out.println("Failed to set look and feel: " + lafClassName + " : " + e.toString());
            }
        }
        if ((lafClassName = brandBundle.getString("messenger.lookandfeel." + PlatformUtil.getNoSpaceOSName())) != null && (lafClassName = lafClassName.trim()).length() > 0) {
            try {
                ViewUtility.setLAF(lafClassName);
                return;
            }
            catch (Exception e) {
                System.out.println("Failed to set look and feel: " + lafClassName + " : " + e.toString());
            }
        }
        if ((lafClassName = brandBundle.getString("messenger.lookandfeel")) != null && (lafClassName = lafClassName.trim()).length() > 0) {
            try {
                ViewUtility.setLAF(lafClassName);
                return;
            }
            catch (Exception e) {
                System.out.println("Failed to set look and feel: " + lafClassName + " : " + e.toString());
            }
        }
        if (PlatformUtil.isUnix()) {
            ViewUtility.setJavaLAF();
        } else {
            ViewUtility.setDefaultLAF();
        }
    }

    public static final void GarbageCollect() {
        System.runFinalization();
        System.gc();
    }

    public static final void showBuddyList(boolean min) {
        if (_buddylist != null) {
            _buddylist.showBuddyList(min);
        }
    }

    public static final void updateChatRoomModels() {
        if (_buddylist != null) {
            _buddylist.updateChatRoomModels();
        }
    }

    public static final boolean addRoom(String name, String server, int access, boolean showUserList) {
        if (_buddylist != null) {
            return _buddylist.addRoom(name, access, showUserList);
        }
        return false;
    }

    public static final void refreshRooms() {
        if (_buddylist != null) {
            _buddylist.refreshRooms();
        }
    }

    public static final void addUsersToBuddyListGroup(String[] ids, String group) {
        if (_buddylist != null) {
            _buddylist.addUsersToBuddyListGroup(ids, group);
        }
    }

    public static final void addUsersToBuddyListGroup(CollaborationPrincipal[] p, String group) {
        if (_buddylist != null) {
            _buddylist.addUsersToBuddyListGroup(p, group);
        }
    }

    public static final void updateBuddyList(boolean b) {
        if (_buddylist != null) {
            _buddylist.update(b);
        }
    }

    public static CollaborationPrincipal[] getAllUsersInBuddyList() {
        return (CollaborationPrincipal[])StringUtility.sort((Object[])BuddyListManager.getAllElements());
    }

    public static void connectionLost() {
        if (_buddylist != null) {
            _buddylist.connectionLost();
        }
        _chat.localStatusMessage(iIMBundle.getString("Messenger_has_lost_connection"));
        _chat.localStatusMessage(iIMBundle.getString("Chat_session_not_active"));
    }

    public static void revertPreviousStatus() {
        if (_buddylist != null) {
            _buddylist.revertPreviousStatus();
        }
    }

    public static void changeFont() {
        if (_buddylist != null) {
            _buddylist.changeFont();
        }
    }

    public static final void openTopicManager() {
        if (_topics != null) {
            _topics.openTopicManager();
        }
    }

    public static final void refreshTopicViews(boolean update) {
        if (_topics != null) {
            _topics.refreshTopicViews(update);
        }
    }

    public static final void fireSubscriptionListeners(String name, int type, String id) {
        if (_topics != null) {
            Topics.fireSubscriptionListeners(name, type, id);
        }
    }

    public static final void removeSubscriptionListener(SubscriptionListener l) {
        if (_topics != null) {
            Topics.removeSubscriptionListener(l);
        }
    }

    public static final void deleteTopic(NewsChannel t) {
        if (_topics != null) {
            _topics.deleteTopic(t);
        }
    }

    public static final void showTopicView() {
        if (Manager.ALLOW_NEWS_ACCESS) {
            if (_topics == null && _client != null && _login != null) {
                Manager.Out("iIM.loadNetLert(): Initialize news");
                _topics = new Topics(_client, _login);
                _topics.init();
            }
            _topics.showTopicView();
        }
    }

    public static void showTopicSubscription() {
        if (_topics != null) {
            _topics.showTopicSubscription();
        }
    }

    public static final boolean addTopic(String name, String server, int access) {
        if (_topics != null) {
            return _topics.addTopic(name, server, access);
        }
        return false;
    }

    public static void refreshTopics() {
        if (_topics != null) {
            _topics.refreshTopics();
        }
    }

    public static final void AddMsg(Message m) {
        if (_alert != null) {
            Alert.AddMsg(m);
        }
    }

    public static final void AddMsg(Vector v, Vector va, int type) {
        if (_alert != null) {
            Alert.AddMsg(v, va, type);
        }
    }

    public static final void AddMsg(CollaborationPrincipal[] nu, CollaborationPrincipal[] au, int type) {
        Vector<CollaborationPrincipal> v = null;
        Vector<CollaborationPrincipal> a = null;
        if (nu != null) {
            v = new Vector<CollaborationPrincipal>(nu.length);
            for (int n = 0; n < nu.length; ++n) {
                v.addElement(nu[n]);
            }
        }
        if (au != null) {
            a = new Vector<CollaborationPrincipal>(au.length);
            for (int m = 0; m < au.length; ++m) {
                a.addElement(au[m]);
            }
            iIM.AddMsg(v, a, type);
        }
    }

    public static final void Poll(Frame parent, Vector a, Vector v) {
        if (_poll != null) {
            _poll.Poll(parent, a, v);
        }
    }

    public static final void startNewChat(CollaborationPrincipal[] nm) {
        try {
            if (_chat != null) {
                _chat.startNewChat(nm);
            }
        }
        catch (CollaborationException e) {
            Manager.Out("Exception e: " + (Object)((Object)e));
        }
    }

    public static final void enterRoom(Conference r) {
        if (_chat != null) {
            _chat.enterRoom(r);
        }
    }

    public static final RoomView getRoomViewFor(String roomUid) {
        if (_chat != null) {
            return _chat.getRoomViewFor(roomUid);
        }
        return null;
    }

    public static final void receiveChatInvite(Conference r, InviteMessage m) {
        try {
            if (_chat != null) {
                Chat.receiveChatInvite(r, m);
            }
        }
        catch (CollaborationException e) {
            Manager.Out("Exception e: " + (Object)((Object)e));
        }
    }

    public static final void handleModeratedChatMsg(Message m) {
        try {
            if (_chat != null) {
                _chat.attachModeratedMessageToConference(m);
            }
        }
        catch (CollaborationException e) {
            Manager.Out("Exception e: " + (Object)((Object)e));
        }
    }

    public static final void openDestinationAdmin(JFrame parent, int type) {
        _client.openDestinationAdmin(parent, type);
    }

    public static final void openDestinationAdmin(JFrame parent, int type, Conference selectedRoom) {
        _client.openDestinationAdmin(parent, type, selectedRoom);
    }

    public static final void reLogOn() {
        _client.reLogOn();
    }

    public static final void openUserAdmin() {
        _client.openUserAdmin();
    }

    public static final void showSettings(CollaborationPrincipal user, String value) {
        Client.showSettings(user, value);
    }

    public static void refreshWindows() {
        Properties currentUserProperties = CurrentUserManager.getCurrentUserProperties();
        iIM.changeFont();
        if (_buddylist != null) {
            _buddylist.setTrayIconVisible(iIMPropsUtil.getShowTrayIcon(currentUserProperties));
        }
        TopicManager.setTopicAlertChannelEnabled(iIMPropsUtil.isTopicAlertChannelEnabled(currentUserProperties));
        Topics.fireSubscriptionListeners(TopicManager.ID_ALERT_ID, 5, null);
        ApplicationManager.refresh();
    }

    public static void setActiveWindow(long lng) {
        SwingUtilities.invokeLater(new SetActiveRunnable(lng));
    }

    public static final boolean canExit(Frame frame) {
        if (!ApplicationManager.NETLERT_CAN_EXIT) {
            return false;
        }
        if (!ApplicationManager.AUTO_CLOSE && frame != null) {
            String msg = iIMBundle.getString("Are_you_sure_you_want_to_exit");
            Object[] message = new Object[2];
            message[0] = msg;
            int result = JOptionPane.showOptionDialog(frame, msg, iIMBundle.getString("Exit"), 0, 3, null, null, null);
            if (result != 0) {
                return false;
            }
        }
        return true;
    }

    private static void closeMainViews() {
        if (_chat != null) {
            _chat.close();
            _chat = null;
        }
        if (_buddylist != null) {
            _buddylist.close();
            _buddylist = null;
        }
        if (_topics != null) {
            _topics.close();
            _topics = null;
        }
        if (_alert != null) {
            _alert.close();
            _alert = null;
        }
        if (_poll != null) {
            _poll.close();
            _poll = null;
        }
    }

    public static final void exit(boolean save) {
        iIM.exit(null, save);
    }

    public static final void exit(Frame frame) {
        iIM.exit(frame, true);
    }

    public static final void exit(Frame frame, boolean save) {
        if (Manager.ALLOW_PRESENCE_PUBLISH) {
            String status = "CLOSED";
            String reason = iIMBundle.getString("Offline");
            if (frame != null && iIMPropsUtil.getSetOfflineStatus(CurrentUserManager.getCurrentUserProperties())) {
                Manager.Out("   DEBUG: SET STATUS ");
                String msg = iIMBundle.getString("Enter_Your_Offline_Status");
                String tmp = JOptionPane.showInputDialog(frame, (Object)msg);
                if (tmp != null && !tmp.equals("")) {
                    reason = tmp;
                }
            }
            UserStatusManager.setCurrentUserStatusToServerNow(CurrentUserManager.getCurrentUserID(), status, reason);
        }
        if (Manager.ALLOW_SETTINGS_CHANGES && save) {
            Manager.saveAllPropertiesToServer(false, true);
        }
        iIM.closeMainViews();
        if (Manager._is_applet) {
            Manager.clearCache();
        }
        if (Manager.worker != null) {
            Manager.worker.stop();
            Manager.worker = null;
        }
        if (_login != null) {
            _login.close(false);
            _login = null;
        }
        Manager.exit(0);
        if (Manager._is_applet) {
            iIM.closeBrowser();
        }
    }

    private static void closeBrowser() {
        try {
            Manager._applet.getAppletContext().showDocument(new URL("javascript: window.close();"), "_parent");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static BuddyList getBuddyList() {
        return _buddylist;
    }

    public static Topics getTopics() {
        return _topics;
    }

    public static String getPresenceStatus() {
        return savedStatus;
    }

    public static String getPresenceStatusString() {
        return savedStatusString;
    }

    public static ImageIcon getPresenceIcon() {
        return savedIcon;
    }

    public static String getPreviousStatusString() {
        return previousStatusStr;
    }

    public static void setPresenceStatus(String status) {
        savedStatus = status;
    }

    public static void setPresenceStatusString(String str) {
        iIM.setPreviousStatusString(savedStatusString);
        savedStatusString = str;
    }

    public static void setPresenceIcon(ImageIcon icon) {
        savedIcon = icon;
    }

    public static void setPreviousStatusString(String str) {
        previousStatusStr = str;
    }

    static {
        SHOW_SPLASH = false;
        GET_IP = false;
        ENCODE_PW = true;
        OPTIMIZE = false;
        helpCodebase = null;
        _login = null;
        _client = null;
        _chat = null;
        _buddylist = null;
        _topics = null;
        _alert = null;
        _poll = null;
    }

    private static class SetActiveRunnable
    implements Runnable {
        private long l;

        public SetActiveRunnable(long l) {
            this.l = l;
        }

        public void run() {
            JNILink.setActiveWindow(this.l);
        }
    }

    static class iIMArgument {
        public String parameter;
        public String value;

        iIMArgument() {
        }
    }
}

