/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.jni.JNILink;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.StorageManager;
import com.iplanet.im.client.util.NetUtility;
import com.iplanet.im.client.util.SoundUtility;
import com.iplanet.im.client.util.iIMPropsUtil;
import java.net.URL;

public class Sound {
    public static final int ALERT = 0;
    public static final int OFF = 1;
    public static final int ON = 2;
    public static final int SEND = 3;
    public static final int RECEIVE = 4;
    public static final int AWAY = 5;
    public static final int NEWTOPIC = 6;
    public static final int CHAT = 7;
    public static final int BUSY = 8;
    private static final String[] names = new String[]{"/com/sun/im/desktop/sounds/alert", "/com/sun/im/desktop/sounds/soundoff", "/com/sun/im/desktop/sounds/soundon", "/com/sun/im/desktop/sounds/send", "/com/sun/im/desktop/sounds/receive", "/com/sun/im/desktop/sounds/away", "/com/sun/im/desktop/sounds/alerttpc", "/com/sun/im/desktop/sounds/alerttpc", "/com/sun/im/desktop/sounds/alerttpc"};
    private static final String[] defaultNames = new String[]{"/com/sun/im/desktop/default/sounds/alert", "/com/sun/im/desktop/default/sounds/soundoff", "/com/sun/im/desktop/default/sounds/soundon", "/com/sun/im/desktop/default/sounds/send", "/com/sun/im/desktop/default/sounds/receive", "/com/sun/im/desktop/default/sounds/away", "/com/sun/im/desktop/default/sounds/alerttpc", "/com/sun/im/desktop/default/sounds/alerttpc", "/com/sun/im/desktop/default/sounds/alerttpc"};
    private static URL[] soundURL = new URL[names.length];
    private static String[] soundFile = new String[names.length];
    public static boolean on = false;

    public static void play(int sound) {
        if (on) {
            if (sound < 0 || sound > names.length) {
                Manager.Out("INVALID SOUND");
            } else {
                switch (sound) {
                    case 0: {
                        if (Manager.ALLOW_RECEIVE_ALERTS && iIMPropsUtil.isPlaySoundOnAlertEnabled(CurrentUserManager.getCurrentUserProperties())) break;
                        return;
                    }
                    case 3: {
                        if (Manager.ALLOW_CHAT && iIMPropsUtil.isPlaySoundOnSendMessageEnabled(CurrentUserManager.getCurrentUserProperties())) break;
                        return;
                    }
                    case 4: {
                        if (Manager.ALLOW_CHAT && iIMPropsUtil.isPlaySoundOnReceiveMessageEnabled(CurrentUserManager.getCurrentUserProperties())) break;
                        return;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 7: 
                    case 8: {
                        if (Manager.ALLOW_PRESENCE_ACCESS && iIMPropsUtil.isPlaySoundOnStatusChangeEnabled(CurrentUserManager.getCurrentUserProperties())) break;
                        return;
                    }
                    case 6: {
                        if (Manager.ALLOW_NEWS_ACCESS && iIMPropsUtil.isPlaySoundOnNewNewsMessageEnabled(CurrentUserManager.getCurrentUserProperties())) break;
                        return;
                    }
                }
                if (JNILink.USE_WIN_JNI) {
                    SoundUtility.play(soundFile[sound]);
                } else {
                    SoundUtility.play(soundURL[sound]);
                }
            }
        }
    }

    public static final void initSound() {
        on = iIMPropsUtil.isSoundEnabled(CurrentUserManager.getCurrentUserProperties());
        for (int n = 0; n < names.length; ++n) {
            URL u = ((Object)((Object)iIM._client)).getClass().getResource(names[n] + ".wav");
            if (u == null) {
                u = ((Object)((Object)iIM._client)).getClass().getResource(defaultNames[n] + ".wav");
            }
            Sound.soundURL[n] = u;
            if (u == null || !JNILink.USE_WIN_JNI) continue;
            byte[] b = NetUtility.loadUrlBytes(u, false);
            String tmp = u.getPath();
            tmp = tmp.substring(tmp.lastIndexOf("/") + 1);
            Manager.Out("[Sound] saving sound file locally: " + tmp);
            Sound.soundFile[n] = StorageManager.saveSoundFile(b, tmp);
        }
    }
}

