/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.xpath;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.xpath.AbstractFunction;
import org.jabberstudio.jso.xpath.LocaleFunction;
import org.jaxen.Context;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class MatchLocaleFunction
extends AbstractFunction {
    public String getFunctionName() {
        return "locale-match";
    }

    public Object call(Context ctx, List args) throws FunctionCallException {
        Navigator nav = ctx.getNavigator();
        Object arg1 = null;
        List arg2 = null;
        int size = args.size();
        switch (size) {
            case 1: {
                arg1 = args.get(0);
                arg2 = ctx.getNodeSet();
                break;
            }
            case 2: {
                arg1 = args.get(0);
                arg2 = args.get(1);
                break;
            }
            default: {
                throw new FunctionCallException(this.getFunctionName() + " requires at one or two arguments");
            }
        }
        return MatchLocaleFunction.evaluate(arg1, arg2, nav);
    }

    public static Boolean evaluate(Object arg1, Object arg2, Navigator nav) throws FunctionCallException {
        Boolean retval = null;
        try {
            Locale target;
            Locale source = LocaleFunction.evaluate(arg1, nav);
            if (source == null) {
                throw new FunctionCallException("first argument is not a valid Locale");
            }
            if (nav.isElement(arg2)) {
                arg2 = Collections.singletonList(arg2);
            }
            if (arg2 instanceof List) {
                boolean matched = true;
                boolean result = true;
                Iterator<Object> itr = arg2.iterator();
                while (matched && result && itr.hasNext()) {
                    Object node = itr.next();
                    result = nav.isElement(node);
                    if (result) {
                        target = ((StreamElement)node).getLocale();
                        result = Utilities.matchLocales(source, target);
                        continue;
                    }
                    matched = false;
                }
                if (matched) {
                    retval = result;
                }
            }
            if (retval == null) {
                target = LocaleFunction.evaluate(arg2, nav);
                if (target == null) {
                    throw new FunctionCallException("second argument is not a valid Locale");
                }
                retval = Utilities.matchLocales(source, target);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionCallException("Cannot evaluate arguments");
        }
        return retval;
    }
}

