/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.xpath;

import java.util.List;
import java.util.Locale;
import org.jabberstudio.jso.format.LocaleFormat;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.xpath.AbstractFunction;
import org.jaxen.Context;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class LocaleFunction
extends AbstractFunction {
    public String getFunctionName() {
        return "locale";
    }

    public Object call(Context ctx, List args) throws FunctionCallException {
        Navigator nav = ctx.getNavigator();
        int size = args.size();
        if (size > 1) {
            throw new FunctionCallException("locale() requires zero or one argument");
        }
        List eval = size == 0 ? ctx.getNodeSet() : args.get(0);
        return LocaleFunction.evaluate(eval, nav);
    }

    public static Locale evaluate(Object arg, Navigator nav) throws FunctionCallException {
        Locale l = null;
        try {
            if (arg instanceof Locale) {
                l = (Locale)arg;
            } else {
                String value = StringFunction.evaluate(arg, nav);
                if (Utilities.isValidString(value)) {
                    l = (Locale)LocaleFormat.getInstance().parseObject(value);
                }
            }
        }
        catch (Exception e) {
            throw new FunctionCallException("Cannot evaluate to a Locale.");
        }
        return l;
    }
}

