/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.xpath;

import java.util.List;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.xpath.AbstractFunction;
import org.jaxen.Context;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class JidFunction
extends AbstractFunction {
    public String getFunctionName() {
        return "jid";
    }

    public Object call(Context ctx, List args) throws FunctionCallException {
        Navigator nav = ctx.getNavigator();
        int size = args.size();
        if (size > 1) {
            throw new FunctionCallException("jid() requires zero or one argument");
        }
        List eval = size == 0 ? ctx.getNodeSet() : args.get(0);
        return JidFunction.evaluate(eval, nav);
    }

    public static JID evaluate(Object arg, Navigator nav) throws FunctionCallException {
        JID jid = null;
        try {
            if (arg instanceof JID) {
                jid = (JID)arg;
            } else {
                String value = StringFunction.evaluate(arg, nav);
                if (Utilities.isValidString(value)) {
                    jid = new JID(value);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionCallException("Cannot evaluate to a JID.");
        }
        return jid;
    }
}

