/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.xpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jabberstudio.jso.xpath.AbstractFunction;
import org.jabberstudio.jso.xpath.ClassFunction;
import org.jaxen.Context;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class ImplsClassFunction
extends AbstractFunction {
    public String getFunctionName() {
        return "implements-class";
    }

    public Object call(Context ctx, List args) throws FunctionCallException {
        Navigator nav = ctx.getNavigator();
        int size = args.size();
        if (size < 1) {
            throw new FunctionCallException("implements-class() requires one or more arguments");
        }
        Class iface = ClassFunction.evaluate(args.get(0), nav);
        args = size == 1 ? ctx.getNodeSet() : this.asFlatList(args.subList(1, size));
        return ImplsClassFunction.evaluate(iface, args, nav);
    }

    public static Boolean evaluate(Class iface, List args, Navigator nav) throws FunctionCallException {
        boolean result;
        if (iface == null) {
            throw new FunctionCallException("Class cannot be null");
        }
        if (args == null) {
            args = Collections.EMPTY_LIST;
        }
        Iterator itr = args.iterator();
        boolean bl = result = !args.isEmpty();
        while (result && itr.hasNext()) {
            result = result && iface.isInstance(itr.next());
        }
        return result;
    }

    private List asFlatList(List in) {
        Iterator itr = in.iterator();
        ArrayList<Object> out = new ArrayList<Object>();
        while (itr.hasNext()) {
            Object test = itr.next();
            if (test instanceof Collection) {
                out.addAll((Collection)test);
                continue;
            }
            if (test instanceof Map) {
                out.addAll(((Map)test).values());
                continue;
            }
            out.add(test);
        }
        return out;
    }
}

