/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.x.core;

import java.util.HashMap;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamFeature;
import org.jabberstudio.jso.StreamFeatureset;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.features.AbstractFeatureConsumer;
import org.jabberstudio.jso.features.FeatureContext;
import org.jabberstudio.jso.util.IdentityGenerator;
import org.jabberstudio.jso.util.PacketException;
import org.jabberstudio.jso.util.XPathListener;
import org.jabberstudio.jso.x.core.BindQuery;
import org.saxpath.SAXPathException;

public class BindFeatureConsumer
extends AbstractFeatureConsumer {
    private JID _JID;
    private String _Resource;

    public BindFeatureConsumer() {
        this(null);
    }

    public BindFeatureConsumer(String res) throws IllegalArgumentException {
        this.setResource(res);
    }

    public JID getJID() {
        return this._JID;
    }

    private void setJID(JID jid) {
        this._JID = jid;
    }

    public String getResource() {
        return this._Resource;
    }

    public void setResource(String res) throws IllegalArgumentException {
        if (!JID.isValidResource(res)) {
            throw new IllegalArgumentException("String \"" + res + "\" is not a valid resource");
        }
        this._Resource = res != null ? res : "";
    }

    public StreamFeature findFeature(StreamFeatureset fs) {
        return (StreamFeature)fs.getFirstElement(BindQuery.NAME);
    }

    protected void startConsumption() throws IllegalStateException, StreamException {
        FeatureContext ctx = this.getFeatureContext();
        PacketRouter router = ctx.getRouter();
        PacketDispatcher dispatch = ctx.getDispatcher();
        StreamDataFactory sdf = ctx.getRouter().getDataFactory();
        try {
            dispatch.addPacketListener(PacketEvent.RECEIVED, new BindWatcher(router));
        }
        catch (SAXPathException spe) {
            throw new IllegalStateException("Could not register Bind packet listener");
        }
        InfoQuery iq = (InfoQuery)sdf.createPacketNode(sdf.createNSI("iq", router.getDefaultNamespace()), InfoQuery.class);
        iq.setType(InfoQuery.SET);
        iq.setID(IdentityGenerator.generateGlobal("bind"));
        BindQuery bind = (BindQuery)iq.addElement(BindQuery.NAME, BindQuery.class);
        bind.setResource(this.getResource());
        router.send(iq);
    }

    public void reset() {
        super.reset();
        this.setJID(null);
    }

    private class BindWatcher
    extends XPathListener {
        public BindWatcher(PacketRouter router) throws SAXPathException {
            super(router.getDataFactory(), "app:iq[(@type='result') or (@type='error')]/bind:*");
            HashMap<String, String> nss = new HashMap<String, String>();
            nss.put("app", router.getDefaultNamespace());
            nss.put("bind", "urn:ietf:params:xml:ns:xmpp-bind");
            this.setupNamespaces(nss);
        }

        public void packetMatched(PacketEvent evt) {
            PacketDispatcher dispatch = BindFeatureConsumer.this.getFeatureContext().getDispatcher();
            InfoQuery iq = (InfoQuery)evt.getData();
            dispatch.removePacketListener(PacketEvent.RECEIVED, this);
            if (iq.getType() == InfoQuery.ERROR) {
                BindFeatureConsumer.this.completeFailedConsumption(new PacketException(iq.getError()));
            } else {
                BindQuery bind = (BindQuery)iq.getFirstElement(class$org$jabberstudio$jso$x$core$BindQuery == null ? (class$org$jabberstudio$jso$x$core$BindQuery = BindFeatureConsumer.class$("org.jabberstudio.jso.x.core.BindQuery")) : class$org$jabberstudio$jso$x$core$BindQuery);
                BindFeatureConsumer.this.setJID(bind.getJID());
                BindFeatureConsumer.this.completeSucceededConsumption(false);
            }
        }
    }
}

