/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.x.core;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.util.DigestHash;
import org.jabberstudio.jso.util.Enumerator;
import org.jabberstudio.jso.util.Utilities;

public interface AuthQuery
extends Extension {
    public static final String NAMESPACE = "jabber:iq:auth";
    public static final NSI NAME = new NSI("query", "jabber:iq:auth");
    public static final Method NONE = new Method("none"){

        public boolean isSupported(AuthQuery aq) throws IllegalArgumentException {
            if (aq == null) {
                throw new IllegalArgumentException("AuthQuery cannot be null");
            }
            return true;
        }

        public Map setupAuthParams(AuthQuery aq) throws IllegalArgumentException, IllegalStateException {
            TreeMap params = new TreeMap();
            if (!this.isSupported(aq)) {
                throw new IllegalStateException("AuthQuery does not support this method:  " + this.toString());
            }
            return params;
        }

        public void setupAuth(AuthQuery aq, Map params) throws IllegalArgumentException, IllegalStateException {
            if (!this.isSupported(aq)) {
                throw new IllegalStateException("AuthQuery does not support this method:  " + this.toString());
            }
            this.resetAuth(aq);
        }

        public Map setupFieldParams(AuthQuery aq) throws IllegalArgumentException {
            TreeMap params = new TreeMap();
            return params;
        }

        public void setupFields(AuthQuery aq, Map params) throws IllegalArgumentException {
            if (aq == null) {
                throw new IllegalArgumentException("AuthQuery cannot be null");
            }
        }
    };
    public static final Method PLAIN = new Method("plain"){

        public boolean isSupported(AuthQuery aq) throws IllegalArgumentException {
            if (aq == null) {
                throw new IllegalArgumentException("AuthQuery cannot be null");
            }
            Set names = aq.getFieldNames();
            return names.contains("password");
        }

        public Map setupAuthParams(AuthQuery aq) throws IllegalArgumentException, IllegalStateException {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (!this.isSupported(aq)) {
                throw new IllegalStateException("AuthQuery does not support this method:  " + this.toString());
            }
            params.put("password", null);
            return params;
        }

        public void setupAuth(AuthQuery aq, Map params) throws IllegalArgumentException, IllegalStateException {
            if (!this.isSupported(aq)) {
                throw new IllegalStateException("AuthQuery does not support this method:  " + this.toString());
            }
            if (params == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (!params.containsKey("password")) {
                throw new IllegalArgumentException("Paramters must contain a 'password'");
            }
            Object pwd = params.get("password");
            this.resetAuth(aq);
            aq.setPassword(pwd != null ? pwd.toString() : null);
        }

        public Map setupFieldParams(AuthQuery aq) throws IllegalArgumentException {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("digest", null);
            return params;
        }

        public void setupFields(AuthQuery aq, Map params) throws IllegalArgumentException {
            Object password = null;
            if (aq == null) {
                throw new IllegalArgumentException("AuthQuery cannot be null");
            }
            if (params != null && params.containsKey("password")) {
                password = params.get("password");
            }
            aq.setPassword(password != null ? password.toString() : null);
        }
    };
    public static final Method DIGEST = new Method("digest"){

        public boolean isSupported(AuthQuery aq) throws IllegalArgumentException {
            if (aq == null) {
                throw new IllegalArgumentException("AuthQuery cannot be null");
            }
            Set names = aq.getFieldNames();
            return names.contains("digest");
        }

        public Map setupAuthParams(AuthQuery aq) throws IllegalArgumentException, IllegalStateException {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (!this.isSupported(aq)) {
                throw new IllegalStateException("AuthQuery does not support this method:  " + this.toString());
            }
            params.put("sessionid", null);
            params.put("password", null);
            return params;
        }

        public void setupAuth(AuthQuery aq, Map params) throws IllegalArgumentException, IllegalStateException {
            if (!this.isSupported(aq)) {
                throw new IllegalStateException("AuthQuery does not support this method:  " + this.toString());
            }
            if (params == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (!params.containsKey("sessionid")) {
                throw new IllegalArgumentException("Paramters must contain a 'sessionid'");
            }
            if (!params.containsKey("password")) {
                throw new IllegalArgumentException("Paramters must contain a 'password'");
            }
            Object sessionid = params.get("sessionid");
            Object password = params.get("password");
            String digest = DigestHash.SHA1.hash((sessionid != null ? sessionid.toString() : "") + (password != null ? password.toString() : ""));
            this.resetAuth(aq);
            aq.setDigest(digest);
        }

        public Map setupFieldParams(AuthQuery aq) throws IllegalArgumentException {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("digest", null);
            return params;
        }

        public void setupFields(AuthQuery aq, Map params) throws IllegalArgumentException {
            Object digest = null;
            if (aq == null) {
                throw new IllegalArgumentException("AuthQuery cannot be null");
            }
            if (params != null && params.containsKey("digest")) {
                digest = params.get("digest");
            }
            aq.setDigest(digest != null ? digest.toString() : null);
        }
    };
    public static final Method ZERO_KNOWLEDGE = new Method("zero knowledge"){

        public boolean isSupported(AuthQuery aq) throws IllegalArgumentException {
            if (aq == null) {
                throw new IllegalArgumentException("AuthQuery cannot be null");
            }
            Set names = aq.getFieldNames();
            return names.contains("token") && names.contains("sequence");
        }

        public Map setupAuthParams(AuthQuery aq) throws IllegalArgumentException, IllegalStateException {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (!this.isSupported(aq)) {
                throw new IllegalStateException("AuthQuery does not support this method:  " + this.toString());
            }
            params.put("password", null);
            return params;
        }

        public void setupAuth(AuthQuery aq, Map params) throws IllegalArgumentException, IllegalStateException {
            DigestHash hasher = DigestHash.SHA1;
            int sequence = 0;
            if (!this.isSupported(aq)) {
                throw new IllegalStateException("AuthQuery does not support this method:  " + this.toString());
            }
            if (params == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            if (!params.containsKey("password")) {
                throw new IllegalArgumentException("Paramters must contain a 'password'");
            }
            Object password = params.get("password");
            String token = aq.getField("token");
            String temp = aq.getField("sequence");
            try {
                sequence = Integer.parseInt(temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String hash = hasher.hash(password != null ? password.toString() : "");
            hash = hasher.hash(hash + token);
            for (int idx = 0; idx < sequence; ++idx) {
                hash = hasher.hash(hash);
            }
            this.resetAuth(aq);
            aq.setField("hash", hash);
        }

        public Map setupFieldParams(AuthQuery aq) throws IllegalArgumentException {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("token", null);
            params.put("sequence", null);
            return params;
        }

        public void setupFields(AuthQuery aq, Map params) throws IllegalArgumentException {
            String sequence;
            String token;
            if (aq == null) {
                throw new IllegalArgumentException("AuthQuery cannot be null");
            }
            if (params == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            Object temp = params.get("token");
            String string = token = temp != null ? temp.toString() : "";
            if (!Utilities.isValidString(token)) {
                throw new IllegalArgumentException("Token cannot be null or \"\"");
            }
            temp = params.get("sequence");
            String string2 = sequence = temp != null ? temp.toString() : "";
            if (!Utilities.isValidString(sequence)) {
                throw new IllegalArgumentException("Sequence cannot be null or \"\"");
            }
            aq.setField("token", token);
            aq.setField("sequence", sequence);
        }
    };

    public String getUsername();

    public void setUsername(String var1);

    public void clearUsername();

    public String getResource();

    public void setResource(String var1);

    public void clearResource();

    public String getPassword();

    public void setPassword(String var1);

    public void clearPassword();

    public String getDigest();

    public void setDigest(String var1);

    public void clearDigest();

    public Set getFieldNames();

    public String getField(String var1) throws IllegalArgumentException;

    public void setField(String var1, String var2) throws IllegalArgumentException;

    public void unsetField(String var1) throws IllegalArgumentException;

    public static abstract class Method
    extends Enumerator {
        public Method(String name) throws IllegalArgumentException {
            super(name);
        }

        protected void resetAuth(AuthQuery aq) {
            String username = aq.getUsername();
            String resource = aq.getResource();
            aq.reset();
            aq.setUsername(username);
            aq.setResource(resource);
        }

        public abstract boolean isSupported(AuthQuery var1) throws IllegalArgumentException;

        public abstract Map setupAuthParams(AuthQuery var1) throws IllegalArgumentException, IllegalStateException;

        public abstract void setupAuth(AuthQuery var1, Map var2) throws IllegalArgumentException, IllegalStateException;

        public abstract Map setupFieldParams(AuthQuery var1) throws IllegalArgumentException;

        public abstract void setupFields(AuthQuery var1, Map var2) throws IllegalArgumentException;
    }
}

