/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.util.Map;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.event.MonitorListener;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.XPathMonitorEvent;
import org.jabberstudio.jso.util.Monitor;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.xpath.XPathSupport;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class XPathMonitor
extends Monitor {
    private XPath _XPath;

    public XPathMonitor() {
    }

    public XPathMonitor(XPathSupport support, String expr) throws IllegalArgumentException, SAXPathException {
        this(support, expr, null);
    }

    public XPathMonitor(XPathSupport support, String expr, Map nss) throws IllegalArgumentException, SAXPathException {
        this.setXPath(this.setupXPath(support, expr, nss));
    }

    public XPath getXPath() {
        return this._XPath;
    }

    public void setXPath(XPath xpath) {
        this._XPath = xpath;
    }

    public XPath setupXPath(XPathSupport support, String expr) throws IllegalArgumentException, SAXPathException {
        return this.setupXPath(support, expr, null);
    }

    public XPath setupXPath(XPathSupport support, String expr, Map nss) throws IllegalArgumentException, SAXPathException {
        if (support == null) {
            throw new IllegalArgumentException("XPathSupport cannot be null");
        }
        if (!Utilities.isValidString(expr)) {
            throw new IllegalArgumentException("XPath expression cannot be null or \"\"");
        }
        if (!expr.startsWith("./")) {
            expr = (expr.startsWith("/") ? "." : "./") + expr;
        }
        this.setXPath(support.createXPath(expr, nss));
        return this.getXPath();
    }

    protected Monitor.MonitorTask createMonitorTask(Packet p, MonitorListener l) throws IllegalStateException {
        PacketRouter router = this.getRouter();
        PacketDispatcher dispatch = this.getDispatcher();
        XPath xpath = this.getXPath();
        if (router == null) {
            throw new IllegalStateException("PacketRouter is not valid");
        }
        if (dispatch == null) {
            throw new IllegalStateException("PacketDispatcher is not valid");
        }
        if (xpath == null) {
            throw new IllegalArgumentException("XPath cannot be null");
        }
        return new Matcher(xpath, l);
    }

    public static final Packet sendAndWatch(Stream s, Packet p, XPath x) throws IllegalArgumentException, StreamException {
        return XPathMonitor.sendAndWatch(s, s, p, x, -1L, 10L);
    }

    public static final Packet sendAndWatch(Stream s, Packet p, XPath x, long t) throws IllegalArgumentException, StreamException {
        return XPathMonitor.sendAndWatch(s, s, p, x, t, 10L);
    }

    public static final Packet sendAndWatch(Stream s, Packet p, XPath x, long t, long i) throws IllegalArgumentException, StreamException {
        return XPathMonitor.sendAndWatch(s, s, p, x, t, i);
    }

    public static final Packet sendAndWatch(PacketRouter r, PacketDispatcher d, Packet p, XPath x) throws IllegalArgumentException, StreamException {
        return XPathMonitor.sendAndWatch(r, d, p, x, -1L, 10L);
    }

    public static final Packet sendAndWatch(PacketRouter r, PacketDispatcher d, Packet p, XPath x, long t) throws IllegalArgumentException, StreamException {
        return XPathMonitor.sendAndWatch(r, d, p, x, t, 10L);
    }

    public static final Packet sendAndWatch(PacketRouter r, PacketDispatcher d, Packet p, XPath x, long t, long i) throws IllegalArgumentException, StreamException {
        if (r == null) {
            throw new IllegalArgumentException("PacketRouter cannot be null");
        }
        if (d == null) {
            throw new IllegalArgumentException("PacketDispatcher cannot be null");
        }
        if (x == null) {
            throw new IllegalArgumentException("XPath cannot be null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Packet cannot be null");
        }
        XPathMonitor mon = new XPathMonitor();
        mon.setRouter(r);
        mon.setDispatcher(d);
        mon.setXPath(x);
        mon.setTimeout(t);
        mon.setProcessInterval(i);
        return mon.sendAndWatch(p);
    }

    private class Matcher
    extends Monitor.MonitorTask {
        private XPath _XPath;

        public Matcher(XPath expr, MonitorListener l) {
            super(l);
            this._XPath = expr;
        }

        public final XPath getXPath() {
            return this._XPath;
        }

        protected boolean matched(Packet target) {
            StreamContext ctx = this.getRouter().getInboundContext();
            StreamDataFactory sdf = ctx.getDataFactory();
            StreamElement base = sdf.createElementNode(sdf.createNSI("stream", ctx.getNamespaceURI("")));
            StreamElement parent = target.getParent();
            boolean result = false;
            target.setParent(null);
            base.add(target);
            try {
                result = this.getXPath().selectSingleNode(base) != null;
            }
            catch (Exception e) {
                XPathMonitor.this.obtainLogger().info("XPath could not be evaluated", e);
            }
            target.setParent(parent);
            return result;
        }

        protected void fireMonitorFound(Packet actual) {
            XPathMonitorEvent evt = XPathMonitorEvent.createFoundEvent(XPathMonitor.this, this.getXPath(), actual);
            MonitorListener l = this.getListener();
            this.stop(evt);
            if (l != null) {
                l.monitorFound(evt);
            }
        }

        protected void fireMonitorTimeout() {
            XPathMonitorEvent evt = XPathMonitorEvent.createTimeoutEvent(XPathMonitor.this, this.getXPath());
            MonitorListener l = this.getListener();
            this.stop(evt);
            if (l != null) {
                l.monitorTimeout(evt);
            }
        }

        protected void fireMonitorFailed(StreamException cause) {
            XPathMonitorEvent evt = XPathMonitorEvent.createFailedEvent(XPathMonitor.this, this.getXPath(), cause);
            MonitorListener l = this.getListener();
            this.stop(evt);
            if (l != null) {
                l.monitorFailed(evt);
            }
        }
    }
}

