/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jabberstudio.jso.StreamNamespace;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

public final class Utilities {
    public static final String VERSION = "0.13-DEV-20050427164736";
    public static final String CLIENT_NAMESPACE = "jabber:client";
    public static final String COMPONENT_ACCEPT_NAMESPACE = "jabber:component:accept";
    public static final String COMPONENT_CONNECT_NAMESPACE = "jabber:component:connect";
    public static final String SERVER_NAMESPACE = "jabber:server";
    public static final String STREAM_NAMESPACE = "http://etherx.jabber.org/streams";
    public static final String STREAM_PREFIX = "stream";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_PREFIX = "xml";

    private Utilities() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static final boolean isValidString(String test) {
        return test != null && test.length() > 0;
    }

    public static final boolean equateStrings(String cmp1, String cmp2) {
        boolean results;
        boolean bl = results = cmp1 == cmp2;
        if (!results) {
            results = cmp1 != null && cmp2 != null ? cmp1.equals(cmp2) : false;
        }
        return results;
    }

    public static final boolean equateStringsIgnoreCase(String cmp1, String cmp2) {
        boolean results;
        boolean bl = results = cmp1 == cmp2;
        if (!results) {
            results = cmp1 != null && cmp2 != null ? cmp1.equalsIgnoreCase(cmp2) : false;
        }
        return results;
    }

    public static final void setupNamespaces(XPath xpath, Set nss) throws IllegalArgumentException, RuntimeException {
        if (xpath == null) {
            throw new IllegalArgumentException("XPath cannot be null");
        }
        if (nss == null) {
            nss = Collections.EMPTY_SET;
        }
        try {
            Iterator itr = nss.iterator();
            while (itr.hasNext()) {
                StreamNamespace ns = (StreamNamespace)itr.next();
                if (ns == null) continue;
                xpath.addNamespace(ns.getPrefix(), ns.getURI());
            }
        }
        catch (JaxenException je) {
            throw new RuntimeException(je);
        }
    }

    public static final void setupNamespaces(XPath xpath, Map nss) throws IllegalArgumentException, RuntimeException {
        if (xpath == null) {
            throw new IllegalArgumentException("XPath cannot be null");
        }
        if (nss == null) {
            nss = Collections.EMPTY_MAP;
        }
        try {
            Iterator itr = nss.keySet().iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                Object value = nss.get(key);
                if (key == null || value == null) continue;
                xpath.addNamespace(key.toString(), value.toString());
            }
        }
        catch (JaxenException je) {
            throw new RuntimeException(je);
        }
    }

    public static final boolean matchLocales(Locale cmp1, Locale cmp2) throws NullPointerException {
        String test2;
        String test1;
        int result;
        int n = result = cmp1.equals(cmp2) ? 0 : 1;
        if (result != 0) {
            test1 = cmp1.getVariant();
            test2 = cmp2.getVariant();
            int n2 = result = !Utilities.isValidString(test1) ? 0 : test1.compareTo(test2);
        }
        if (result == 0) {
            test1 = cmp1.getCountry();
            test2 = cmp2.getCountry();
            int n3 = result = !Utilities.isValidString(test1) ? 0 : test1.compareTo(test2);
        }
        if (result == 0) {
            test1 = cmp1.getLanguage();
            test2 = cmp2.getLanguage();
            result = !Utilities.isValidString(test1) ? 0 : test1.compareTo(test2);
        }
        return result == 0;
    }
}

