/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabberstudio.jso.util.Utilities;

public class Service {
    private static final Pattern RE_CLASS = Pattern.compile("[a-zA-Z0-9_\\$\\.]+");
    private ClassLoader _Source;
    private Class _Target;
    private Map _Providers = new TreeMap();

    public Service(Class target, ClassLoader src) throws IllegalArgumentException {
        this.setTarget(target);
        this.setSource(src);
    }

    public Class getTarget() {
        return this._Target;
    }

    private void setTarget(Class target) throws IllegalArgumentException {
        if (target == null) {
            throw new IllegalArgumentException("Target class cannot be null");
        }
        this._Target = target;
    }

    public ClassLoader getSource() {
        return this._Source;
    }

    private void setSource(ClassLoader src) {
        this._Source = src == null ? this.getClass().getClassLoader() : src;
    }

    public synchronized Map getProviders() {
        if (this._Providers.isEmpty()) {
            this.load(this._Providers);
        }
        return Collections.unmodifiableMap(this._Providers);
    }

    public synchronized Object obtainProvider(String name) throws IllegalArgumentException {
        Object provInst = null;
        if (!Utilities.isValidString(name)) {
            throw new IllegalArgumentException("implementation name cannot be null");
        }
        Class provCls = (Class)this.getProviders().get(name);
        if (provCls == null) {
            throw new IllegalArgumentException("Provider " + name + " not available");
        }
        try {
            provInst = provCls.newInstance();
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException("Cannot instantiate provider " + name);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("Cannot access provider " + name);
        }
        return provInst;
    }

    private final void load(Map provs) {
        ClassLoader source = this.getSource();
        String svc = "services/" + this.getTarget().getName();
        try {
            provs.clear();
            Enumeration<URL> svcs = source.getResources(svc);
            while (svcs.hasMoreElements()) {
                URL url = svcs.nextElement();
                this.loadURL(url, provs);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private final void loadURL(URL url, Map provs) {
        try {
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = input.readLine()) != null) {
                Matcher match;
                if (line.startsWith("#") || !(match = RE_CLASS.matcher(line)).find()) continue;
                try {
                    String test = match.group().trim();
                    Class<?> provCls = this.getSource().loadClass(test);
                    Object provInst = provCls.newInstance();
                    provs.put(provCls.getName(), provCls);
                }
                catch (ClassNotFoundException cnfe) {
                }
                catch (InstantiationException ie) {
                }
                catch (IllegalAccessException iae) {}
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

