/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import org.jabberstudio.jso.util.ByteCodec;

public class DigestHash {
    public static final DigestHash SHA1;
    public static final DigestHash MD5;
    private MessageDigest _Digest;

    public DigestHash(MessageDigest digest) throws IllegalArgumentException {
        this.setDigest(digest);
    }

    protected MessageDigest getDigest() {
        return this._Digest;
    }

    private void setDigest(MessageDigest digest) throws IllegalArgumentException {
        if (digest == null) {
            throw new IllegalArgumentException("MessageDigest cannot be null");
        }
        this._Digest = digest;
    }

    public synchronized String hash(String input) {
        String val;
        try {
            val = this.hash(input, "UTF-8", null);
        }
        catch (UnsupportedEncodingException uee) {
            val = "";
        }
        return val;
    }

    public synchronized String hash(String input, String charset) throws UnsupportedEncodingException {
        return this.hash(input, charset, null);
    }

    public synchronized String hash(String input, String charset, ByteCodec codec) throws UnsupportedEncodingException {
        StringBuffer output = new StringBuffer();
        if (codec == null) {
            codec = ByteCodec.HEX;
        }
        byte[] outBytes = this.hashToBytes(input, charset);
        return codec.encode(outBytes);
    }

    public synchronized byte[] hashToBytes(String input) {
        byte[] data;
        try {
            data = this.hashToBytes(input, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            data = new byte[]{};
        }
        return data;
    }

    public synchronized byte[] hashToBytes(String input, String charset) throws UnsupportedEncodingException {
        StringBuffer output = new StringBuffer();
        if (input == null) {
            input = "";
        }
        this.getDigest().reset();
        byte[] inBytes = input.getBytes(charset);
        byte[] outBytes = this.getDigest().digest(inBytes);
        return outBytes;
    }

    static {
        DigestHash digest;
        try {
            digest = new DigestHash(MessageDigest.getInstance("sha1"));
        }
        catch (Exception e) {
            digest = null;
        }
        SHA1 = digest;
        try {
            digest = new DigestHash(MessageDigest.getInstance("md5"));
        }
        catch (Exception e) {
            digest = null;
        }
        MD5 = digest;
    }
}

