/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.tls;

import java.util.Collections;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamFeature;
import org.jabberstudio.jso.StreamFeatureset;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.features.AbstractFeatureConsumer;
import org.jabberstudio.jso.features.FeatureContext;
import org.jabberstudio.jso.tls.StartTLSFeature;
import org.jabberstudio.jso.tls.StartTLSPacket;
import org.jabberstudio.jso.tls.StartTLSSocketStreamSource;
import org.jabberstudio.jso.util.XPathListener;
import org.jabberstudio.jso.xpath.XPathSupport;
import org.saxpath.SAXPathException;

public class StartTLSSocketFeatureConsumer
extends AbstractFeatureConsumer {
    private StartTLSSocketStreamSource _Src;
    private FeatureContext _FC;

    public StartTLSSocketFeatureConsumer() {
    }

    public StartTLSSocketFeatureConsumer(StartTLSSocketStreamSource ss) {
        this.setStreamSource(ss);
    }

    public StartTLSSocketStreamSource getStreamSource() {
        return this._Src;
    }

    public void setStreamSource(StartTLSSocketStreamSource ss) {
        this._Src = ss;
    }

    public StreamFeature findFeature(StreamFeatureset fs) {
        return (StreamFeature)fs.getFirstElement(StartTLSFeature.NAME);
    }

    protected void startConsumption() throws IllegalStateException, StreamException {
        FeatureContext ctx = this.getFeatureContext();
        PacketRouter router = ctx.getRouter();
        PacketDispatcher dispatch = ctx.getDispatcher();
        StreamDataFactory sdf = router.getDataFactory();
        if (this.getStreamSource() == null) {
            throw new IllegalStateException("StartTLSSocketStreamSource cannot be null");
        }
        try {
            dispatch.addPacketListener(PacketEvent.RECEIVED, new StartTLSWatcher(sdf));
        }
        catch (SAXPathException spe) {
            throw new IllegalStateException("Could not register STARTTLS packet listener");
        }
        StartTLSPacket packet = (StartTLSPacket)sdf.createPacketNode(StartTLSPacket.NAME_STARTTLS, StartTLSPacket.class);
        router.send(packet);
    }

    public void reset() {
        super.reset();
        this.setStreamSource(null);
    }

    private class StartTLSWatcher
    extends XPathListener {
        public StartTLSWatcher(XPathSupport support) throws SAXPathException {
            super(support, "tls:*", Collections.singletonMap("tls", "urn:ietf:params:xml:ns:xmpp-tls"));
        }

        public void packetMatched(PacketEvent evt) {
            FeatureContext ctx = StartTLSSocketFeatureConsumer.this.getFeatureContext();
            StartTLSSocketStreamSource ss = StartTLSSocketFeatureConsumer.this.getStreamSource();
            PacketDispatcher dispatch = ctx.getDispatcher();
            try {
                ss.negotiateClientTLS();
                dispatch.removePacketListener(PacketEvent.RECEIVED, this);
                StartTLSSocketFeatureConsumer.this.completeSucceededConsumption(true);
            }
            catch (Throwable t) {
                dispatch.removePacketListener(PacketEvent.RECEIVED, this);
                StartTLSSocketFeatureConsumer.this.completeFailedConsumption(t);
            }
        }
    }
}

