/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.io.src;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;
import org.jabberstudio.jso.io.src.IOStreamSource;

public class SocketStreamSource
extends IOStreamSource {
    private Socket _Socket;
    private StatusWatcher _Watch;

    public SocketStreamSource(String host, int port) throws UnknownHostException, IllegalArgumentException, IOException {
        this(new Socket(host, port));
    }

    public SocketStreamSource(Socket s) throws IllegalArgumentException {
        this.setSocket(s);
    }

    protected Socket getSocket() {
        return this._Socket;
    }

    protected void setSocket(Socket s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("Socket cannot be null");
        }
        this._Socket = s;
    }

    protected InetAddress getInetAddress() {
        return this.getSocket().getInetAddress();
    }

    public int getPort() {
        return this.getSocket().getPort();
    }

    public String getHostname() {
        return this.getInetAddress().getHostName();
    }

    public void connect(Stream s) throws IOException, Exception {
        Socket sock = this.getSocket();
        this._Watch = new StatusWatcher();
        s.addStreamStatusListener(this._Watch);
        this.configureSocket(sock, s.getCurrentStatus());
        this.setInput(sock.getInputStream());
        this.setOutput(sock.getOutputStream());
        super.connect(s);
    }

    public void disconnect(Stream s) throws IOException, Exception {
        super.disconnect(s);
        s.removeStreamStatusListener(this._Watch);
        this._Socket.close();
        this._Watch = null;
    }

    protected void configureSocket(Socket sock, Stream.Status stat) throws SocketException {
        if (sock == null) {
            sock = this.getSocket();
        }
        if (stat == null) {
            stat = Stream.DISCONNECTED;
        }
        sock.setSoTimeout(100);
        sock.setKeepAlive(true);
    }

    private class StatusWatcher
    implements StreamStatusListener {
        private StatusWatcher() {
        }

        public void statusChanged(StreamStatusEvent evt) {
            try {
                SocketStreamSource.this.configureSocket(SocketStreamSource.this.getSocket(), evt.getStream().getCurrentStatus());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

