/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.io.src;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.util.ByteCodec;
import org.jabberstudio.jso.util.DigestHash;
import org.jabberstudio.jso.util.Utilities;

public class HttpPollingStreamSource
implements StreamSource {
    private static final int DEFAULT_ITERATIONS = 200;
    private static final String UNKNOWN_ERROR = "0:0";
    private static final String SERVER_ERROR = "-1:0";
    private static final String BAD_REQUEST = "-2:0";
    private URL _Loc;
    private String _ID;
    private String[] _Keys;
    private int _KeyIdx;
    private ByteBuffer _Buffer;

    public HttpPollingStreamSource(URL loc) throws IllegalArgumentException {
        this.setLocation(loc);
    }

    public URL getLocation() {
        return this._Loc;
    }

    private void setLocation(URL loc) throws IllegalArgumentException {
        if (loc == null) {
            throw new IllegalArgumentException("URL location cannot be null");
        }
        this._Loc = loc;
    }

    public String getHostname() {
        return this.getLocation().getHost();
    }

    public void connect(Stream s) throws IOException, Exception {
    }

    public void disconnect(Stream s) throws IOException, Exception {
    }

    public boolean ready() throws IOException {
        return true;
    }

    public int read(byte[] data, int offset, int length) throws IllegalArgumentException, IOException {
        ByteBuffer buffer = this.obtainBuffer();
        int amt = buffer.remaining();
        if (length < buffer.remaining()) {
            amt = length;
        }
        buffer.get(data, offset, amt);
        return length;
    }

    public int write(byte[] data, int offset, int length) throws IllegalArgumentException, IOException {
        byte[] in = this.poll(data, offset, length);
        if (in != null && in.length > 0) {
            this.fillBuffer(in);
        }
        return length;
    }

    private final synchronized ByteBuffer getBuffer() {
        if (this._Buffer == null) {
            this._Buffer = ByteBuffer.allocate(Short.MAX_VALUE);
            this._Buffer.position(0).limit(0);
        }
        return this._Buffer;
    }

    private final synchronized ByteBuffer obtainBuffer() throws IOException {
        ByteBuffer buffer = this.getBuffer();
        if (!buffer.hasRemaining()) {
            byte[] data = this.poll();
            buffer = this.fillBuffer(data);
        }
        return buffer;
    }

    private final synchronized ByteBuffer fillBuffer(byte[] data) throws IOException {
        int size = data.length + this._Buffer.remaining();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put(this._Buffer);
        buffer.put(data);
        this._Buffer = buffer;
        return this._Buffer;
    }

    private byte[] poll() throws IOException {
        return this.poll(null, 0, 0);
    }

    private byte[] poll(byte[] data, int offset, int length) throws IOException {
        HttpURLConnection conn = this.obtainConnection();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(Short.MAX_VALUE);
        OutputStream out = conn.getOutputStream();
        StringBuffer buffer = this.createHeader();
        bout.write(buffer.toString().getBytes("UTF8"));
        if (data != null && data.length > 0 && offset < data.length && length <= data.length) {
            bout.write(data, offset, length);
            bout.write("\r\n".getBytes("UTF8"));
        }
        out.write(bout.toByteArray());
        out.flush();
        out.close();
        bout.reset();
        InputStream in = conn.getInputStream();
        String cookie = conn.getHeaderField("Set-Cookie");
        if (Utilities.isValidString(cookie)) {
            if (Utilities.equateStrings(cookie = cookie.substring(cookie.indexOf(61) + 1, cookie.indexOf(59)), BAD_REQUEST)) {
                throw new IOException("server could not understand request");
            }
            if (Utilities.equateStrings(cookie, SERVER_ERROR)) {
                throw new IOException("server error");
            }
            if (Utilities.equateStrings(cookie, UNKNOWN_ERROR)) {
                throw new IOException("unknown error");
            }
            this.setConnectionID(cookie);
        }
        if (Utilities.equateStrings(conn.getContentType(), "text/xml")) {
            int amt;
            byte[] temp = new byte[Short.MAX_VALUE];
            while ((amt = in.read(temp, 0, temp.length)) != -1) {
                bout.write(temp, 0, amt);
            }
        } else {
            throw new IOException("content-type not acceptable");
        }
        return bout.toByteArray();
    }

    private HttpURLConnection obtainConnection() throws IOException {
        URL url = this.getLocation();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
        return conn;
    }

    private final String getConnectionID() {
        if (this._ID == null) {
            this._ID = "0";
        }
        return this._ID;
    }

    private final void setConnectionID(String id) {
        this._ID = id;
    }

    private final synchronized StringBuffer createHeader() {
        StringBuffer header = new StringBuffer(this.getConnectionID());
        String[] keys = this.getKeylist();
        header.append(';').append(this._Keys[this._KeyIdx--]);
        if (this._KeyIdx == 0) {
            keys = this.resetKeys();
            header.append(';');
            header.append(keys[this._KeyIdx]);
        }
        header.append(',');
        return header;
    }

    private final String[] getKeylist() {
        if (this._Keys == null) {
            this.resetKeys();
        }
        return this._Keys;
    }

    private final synchronized String[] resetKeys() {
        DigestHash sha1 = DigestHash.SHA1;
        ByteCodec b64 = ByteCodec.BASE64;
        SecureRandom random = new SecureRandom();
        byte[] working = new byte[20];
        this._Keys = new String[200];
        ((Random)random).nextBytes(working);
        for (int i = 0; i < this._Keys.length; ++i) {
            this._Keys[i] = b64.encode(working);
            try {
                working = sha1.hashToBytes(this._Keys[i], "UTF8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                this.obtainLogger().warn("UTF8 encoding not supported", e);
            }
        }
        this._KeyIdx = this._Keys.length - 1;
        return this._Keys;
    }

    private final Logger obtainLogger() {
        return Logger.getLogger(this.getClass());
    }
}

