/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.format;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabberstudio.jso.util.Utilities;

public class DateTimeProfileFormat
extends Format
implements Cloneable {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATETIME = 3;
    public static final Format.Field YEAR_FIELD = new Field("year");
    public static final Format.Field MONTH_FIELD = new Field("month");
    public static final Format.Field DAY_FIELD = new Field("day");
    public static final Format.Field HOUR_FIELD = new Field("hour");
    public static final Format.Field MINUTE_FIELD = new Field("minute");
    public static final Format.Field SECOND_FIELD = new Field("second");
    public static final Format.Field TIMEZONE_FIELD = new Field("timezone");
    private static final int YEAR_GROUP = 1;
    private static final int MONTH_GROUP = 2;
    private static final int DAY_GROUP = 3;
    private static final int HOUR_GROUP = 1;
    private static final int MINUTE_GROUP = 2;
    private static final int SECOND_GROUP = 3;
    private static final int TIMEZONE_GROUP = 5;
    private static final DateTimeProfileFormat DATE_INSTANCE;
    private static final DateTimeProfileFormat TIME_INSTANCE;
    private static final DateTimeProfileFormat DATETIME_INSTANCE;
    private int _Profile;
    private Pattern _Pattern;
    private Calendar _Cal;

    private DateTimeProfileFormat(int profile, Pattern ptn) {
        this._Profile = profile;
        this._Pattern = ptn;
    }

    public final int getProfile() {
        return this._Profile;
    }

    public TimeZone getTimeZone() {
        return this.getCalendar().getTimeZone();
    }

    public void setTimeZone(TimeZone tz) {
        this.getCalendar().setTimeZone(tz != null ? tz : TimeZone.getDefault());
    }

    private final Pattern getPattern() {
        return this._Pattern;
    }

    private Calendar getCalendar() {
        if (this._Cal == null) {
            this._Cal = Calendar.getInstance();
        }
        return this._Cal;
    }

    private Calendar resetCalendar() {
        Calendar cal = this.getCalendar();
        this._Cal.set(0, 0, 0, 0, 0, 0);
        this._Cal.set(0, 1);
        this._Cal.set(14, 0);
        return cal;
    }

    public String format(Date obj) throws IllegalArgumentException {
        return this.format((Object)obj);
    }

    public StringBuffer format(Object obj, StringBuffer buffer, FieldPosition pos) throws IllegalArgumentException, NullPointerException {
        AttributedCharacterIterator itr = this.formatToCharacterIterator(obj, buffer);
        if (pos != null) {
            if (pos.getFieldAttribute() == YEAR_FIELD) {
                pos.setBeginIndex(itr.getRunStart(YEAR_FIELD));
                pos.setEndIndex(itr.getRunLimit(YEAR_FIELD));
            }
            itr.setIndex(itr.getRunStart(YEAR_FIELD));
            if (pos.getFieldAttribute() == MONTH_FIELD) {
                pos.setBeginIndex(itr.getRunStart(MONTH_FIELD));
                pos.setEndIndex(itr.getRunLimit(MONTH_FIELD));
            }
            itr.setIndex(itr.getRunStart(MONTH_FIELD));
            if (pos.getFieldAttribute() == DAY_FIELD) {
                pos.setBeginIndex(itr.getRunStart(DAY_FIELD));
                pos.setEndIndex(itr.getRunLimit(DAY_FIELD));
            }
            itr.setIndex(itr.getRunStart(DAY_FIELD));
            if (pos.getFieldAttribute() == HOUR_FIELD) {
                pos.setBeginIndex(itr.getRunStart(HOUR_FIELD));
                pos.setEndIndex(itr.getRunLimit(HOUR_FIELD));
            }
            itr.setIndex(itr.getRunStart(HOUR_FIELD));
            if (pos.getFieldAttribute() == MINUTE_FIELD) {
                pos.setBeginIndex(itr.getRunStart(MINUTE_FIELD));
                pos.setEndIndex(itr.getRunLimit(MINUTE_FIELD));
            }
            itr.setIndex(itr.getRunStart(MINUTE_FIELD));
            if (pos.getFieldAttribute() == SECOND_FIELD) {
                pos.setBeginIndex(itr.getRunStart(SECOND_FIELD));
                pos.setEndIndex(itr.getRunLimit(SECOND_FIELD));
            }
            itr.setIndex(itr.getRunStart(SECOND_FIELD));
            if (pos.getFieldAttribute() == TIMEZONE_FIELD) {
                pos.setBeginIndex(itr.getRunStart(TIMEZONE_FIELD));
                pos.setEndIndex(itr.getRunLimit(TIMEZONE_FIELD));
            }
            itr.setIndex(itr.getRunStart(TIMEZONE_FIELD));
        }
        return buffer;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object obj) throws IllegalArgumentException {
        return this.formatToCharacterIterator(obj, new StringBuffer());
    }

    private AttributedCharacterIterator formatToCharacterIterator(Object obj, StringBuffer toAppendTo) throws IllegalArgumentException {
        String value;
        FieldPosition pos;
        Format.Field key;
        Map.Entry entry;
        StringBuffer buffer = new StringBuffer();
        Date date = null;
        if (obj instanceof Number) {
            date = new Date(((Number)obj).longValue());
        } else if (obj instanceof Date) {
            date = (Date)obj;
        } else {
            throw new IllegalArgumentException("cannot parse object");
        }
        date = (Date)obj;
        HashMap attrPos = new HashMap();
        HashMap<Format.Field, String> attrMap = new HashMap<Format.Field, String>();
        Calendar cal = this.resetCalendar();
        cal.setTime(date);
        int start = toAppendTo.length();
        if ((this.getProfile() & 1) == 1) {
            attrPos.putAll(this.formatDate(cal, buffer));
        }
        if ((this.getProfile() & 2) == 2) {
            attrPos.putAll(this.formatTime(cal, buffer));
        }
        toAppendTo.append(buffer);
        int finish = toAppendTo.length();
        Iterator itr = attrPos.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            key = (Format.Field)entry.getKey();
            pos = (FieldPosition)entry.getValue();
            value = buffer.substring(pos.getBeginIndex(), pos.getEndIndex());
            attrMap.put(key, value);
        }
        AttributedString attrStr = new AttributedString(buffer.toString(), attrMap);
        itr = attrPos.entrySet().iterator();
        while (itr.hasNext()) {
            entry = itr.next();
            key = (Format.Field)entry.getKey();
            pos = (FieldPosition)entry.getValue();
            value = buffer.substring(pos.getBeginIndex(), pos.getEndIndex());
            attrStr.addAttribute(key, value, start + pos.getBeginIndex(), start + pos.getEndIndex());
        }
        return attrStr.getIterator();
    }

    private final FieldPosition formatField(StringBuffer buffer, int val, int size, String prefix, String suffix, FieldPosition pos) {
        pos.setBeginIndex(buffer.length());
        if (Utilities.isValidString(prefix)) {
            buffer.append(prefix);
        }
        for (int idx = size - 1; idx > 0; --idx) {
            int place = (int)Math.pow(10.0, idx);
            if (val / place != 0) continue;
            buffer.append("0");
        }
        buffer.append(val);
        if (Utilities.isValidString(suffix)) {
            buffer.append(suffix);
        }
        pos.setEndIndex(buffer.length());
        return pos;
    }

    private final FieldPosition formatField(StringBuffer buffer, double val, int size, String prefix, String suffix, FieldPosition pos) {
        pos.setBeginIndex(buffer.length());
        if (Utilities.isValidString(prefix)) {
            buffer.append(prefix);
        }
        for (int idx = size - 1; idx > 0; --idx) {
            int place = (int)Math.pow(10.0, idx);
            if ((int)(val / (double)place) != 0) continue;
            buffer.append("0");
        }
        buffer.append(val);
        if (Utilities.isValidString(suffix)) {
            buffer.append(suffix);
        }
        pos.setEndIndex(buffer.length());
        return pos;
    }

    private final Map formatDate(Calendar cal, StringBuffer buffer) {
        HashMap<Format.Field, FieldPosition> attrs = new HashMap<Format.Field, FieldPosition>();
        FieldPosition pos = this.formatField(buffer, cal.get(1), 1, "", "-", new FieldPosition(YEAR_FIELD));
        attrs.put(YEAR_FIELD, pos);
        pos = this.formatField(buffer, cal.get(2) + 1, 2, "", "-", new FieldPosition(MONTH_FIELD));
        attrs.put(MONTH_FIELD, pos);
        this.formatField(buffer, cal.get(5), 2, "", "", new FieldPosition(DAY_FIELD));
        attrs.put(DAY_FIELD, pos);
        return attrs;
    }

    private final Map formatTime(Calendar cal, StringBuffer buffer) {
        HashMap<Format.Field, FieldPosition> attrs = new HashMap<Format.Field, FieldPosition>();
        long time = cal.getTimeInMillis();
        double sec = (double)cal.get(13) + (double)cal.get(14) / 1000.0;
        TimeZone tz = cal.getTimeZone();
        FieldPosition pos = this.formatField(buffer, cal.get(11), 2, this.getProfile() == 3 ? "T" : "", ":", new FieldPosition(HOUR_FIELD));
        attrs.put(HOUR_FIELD, pos);
        pos = this.formatField(buffer, cal.get(12), 2, "", ":", new FieldPosition(MINUTE_FIELD));
        attrs.put(MINUTE_FIELD, pos);
        pos = this.formatField(buffer, sec, 2, "", "", new FieldPosition(SECOND_FIELD));
        attrs.put(SECOND_FIELD, pos);
        pos = new FieldPosition(TIMEZONE_FIELD);
        pos.setBeginIndex(buffer.length());
        if (tz.equals(TimeZone.getTimeZone("UTC"))) {
            buffer.append("Z");
        } else {
            int offset = tz.getOffset(time);
            buffer.append(offset < 0 ? "-" : "+");
            offset = Math.abs(offset);
            int hour = offset / 3600000;
            int min = offset % 3600000 / 60000;
            if (hour < 10) {
                buffer.append("0");
            }
            buffer.append(hour);
            buffer.append(":");
            if (min < 10) {
                buffer.append("0");
            }
            buffer.append(min);
        }
        pos.setEndIndex(buffer.length());
        return attrs;
    }

    public Date parse(String src) throws ParseException {
        return (Date)this.parseObject(src);
    }

    public Object parseObject(String src, ParsePosition pos) throws NullPointerException {
        Calendar cal = this.resetCalendar();
        Date obj = null;
        Matcher m = this.getPattern().matcher(src != null ? src : "");
        if (m.find(pos.getIndex())) {
            pos.setIndex(m.end());
            if ((this.getProfile() & 1) == 1) {
                this.parseDate(cal, m);
            }
            if ((this.getProfile() & 2) == 2) {
                this.parseTime(cal, m);
            }
            obj = cal.getTime();
        } else {
            pos.setErrorIndex(pos.getIndex());
        }
        return obj;
    }

    private final void parseDate(Calendar cal, Matcher m) {
        String val = m.group(1);
        cal.set(1, Integer.parseInt(val));
        val = m.group(2);
        cal.set(2, Integer.parseInt(val) - 1);
        val = m.group(3);
        cal.set(5, Integer.parseInt(val));
    }

    private final void parseTime(Calendar cal, Matcher m) {
        int offset = this.getProfile() == 3 ? 3 : 0;
        double raw = Double.parseDouble(m.group(offset + 3));
        int sec = (int)raw;
        int ms = (int)((raw - (double)sec) * 1000.0);
        String val = m.group(offset + 1);
        cal.set(11, Integer.parseInt(val));
        val = m.group(offset + 2);
        cal.set(12, Integer.parseInt(val));
        cal.set(13, sec);
        cal.set(14, ms);
        val = m.group(offset + 5);
        TimeZone tz = Utilities.equateStrings(val, "Z") ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone("GMT" + val);
        cal.setTimeZone(tz);
        cal.set(15, tz.getRawOffset());
    }

    public Object clone() {
        DateTimeProfileFormat fmt = new DateTimeProfileFormat(this.getProfile(), this.getPattern());
        fmt._Cal = this._Cal;
        return fmt;
    }

    public static DateTimeProfileFormat getInstance(int profile) throws IllegalArgumentException {
        DateTimeProfileFormat fmt = null;
        switch (profile) {
            case 1: {
                fmt = DATE_INSTANCE;
                break;
            }
            case 2: {
                fmt = TIME_INSTANCE;
                break;
            }
            case 3: {
                fmt = DATETIME_INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("profile is not valid");
            }
        }
        return (DateTimeProfileFormat)fmt.clone();
    }

    static {
        String reDate = "(\\d{1,})-(\\d{2})-(\\d{2})";
        String reTime = "(\\d{2}):(\\d{2}):(\\d{2}(\\.\\d+)?)(Z|[-+]\\d{2}:\\d{2})";
        DATE_INSTANCE = new DateTimeProfileFormat(1, Pattern.compile(reDate));
        TIME_INSTANCE = new DateTimeProfileFormat(2, Pattern.compile(reTime));
        DATETIME_INSTANCE = new DateTimeProfileFormat(3, Pattern.compile(reDate + "T" + reTime));
    }

    private static class Field
    extends Format.Field {
        public Field(String name) {
            super(name);
        }
    }
}

