/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.features;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamError;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamFeature;
import org.jabberstudio.jso.StreamFeatureset;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.StreamFeaturesEvent;
import org.jabberstudio.jso.event.StreamFeaturesListener;
import org.jabberstudio.jso.features.FeatureConsumer;
import org.jabberstudio.jso.features.FeatureContext;
import org.jabberstudio.jso.util.Enumerator;

public class FeaturesetConsumerManager
implements Runnable {
    public static final ConsumerStatus READY = new ConsumerStatus("ready", false, false);
    public static final ConsumerStatus IN_PROGRESS = new ConsumerStatus("in progress", true, false);
    public static final ConsumerStatus FAILED = new ConsumerStatus("failed", true, true);
    public static final ConsumerStatus SUCCEEDED = new ConsumerStatus("succeeded", true, true);
    private Stream _Conn;
    private boolean _Pending;
    private StreamFeatureset _Featureset;
    private Throwable _Failure;
    private Context _Ctx;
    private List _Consumers = new LinkedList();
    private Map _Armed = new TreeMap();

    public synchronized Stream getConnection() {
        return this._Conn;
    }

    public synchronized void attach(Stream conn) throws IllegalArgumentException, IllegalStateException {
        if (conn == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        if (this._Conn != null) {
            throw new IllegalStateException("FeaturesetConsumerManager is already attached");
        }
        this._Conn = conn;
        if (this._Ctx == null) {
            this._Ctx = new Context();
        }
        this._Conn.addStreamFeaturesListener(PacketEvent.RECEIVED, this._Ctx);
    }

    public synchronized void detach() {
        this.reset();
        this._Conn.removeStreamFeaturesListener(PacketEvent.RECEIVED, this._Ctx);
        this._Conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void reset() {
        void var1_2;
        FeaturesetConsumerManager featuresetConsumerManager = this;
        synchronized (featuresetConsumerManager) {
            Iterator itr = this.listFeatureConsumers().iterator();
            this._Failure = null;
            this._Ctx = null;
            this._Armed.clear();
        }
        while (var1_2.hasNext()) {
            ((FeatureConsumer)var1_2.next()).reset();
        }
    }

    public synchronized List listFeatureConsumers() {
        return new ArrayList(this._Consumers);
    }

    public synchronized void registerFeatureConsumer(FeatureConsumer fc) {
        if (fc != null && !this._Consumers.contains(fc)) {
            this._Consumers.add(fc);
        }
    }

    public synchronized void unregisterFeatureConsumer(FeatureConsumer fc) {
        if (fc != null) {
            this._Consumers.remove(fc);
            this._Armed.remove(fc.toString());
        }
    }

    public synchronized ConsumerStatus getConsumerStatus(FeatureConsumer fc) throws IllegalArgumentException {
        ConsumerStatus stat = null;
        if (!this._Consumers.contains(fc)) {
            throw new IllegalArgumentException("FeatureConsumer is not registered");
        }
        if (fc != null) {
            stat = (ConsumerStatus)this._Armed.get(fc.toString());
        }
        if (stat == null) {
            stat = READY;
        }
        return stat;
    }

    private final synchronized void updateConsumerStatus(FeatureConsumer fc, ConsumerStatus stat) throws IllegalArgumentException {
        if (!this._Consumers.contains(fc)) {
            throw new IllegalArgumentException("FeatureConsumer is not registered");
        }
        String id = fc.toString();
        if (stat != null && stat != READY) {
            this._Armed.put(id, stat);
        } else {
            this._Armed.remove(id);
        }
    }

    public boolean isFeatureConsumerStarted(FeatureConsumer fc) throws IllegalArgumentException {
        return this.getConsumerStatus(fc).isStarted();
    }

    public boolean isFeatureConsumerCompleted(FeatureConsumer fc) throws IllegalArgumentException {
        return this.getConsumerStatus(fc).isComplete();
    }

    private final synchronized Context getFeatureContext() {
        return this._Ctx;
    }

    private final synchronized Context startFeatureContext(FeatureConsumer fc, StreamFeature feat) {
        if (this._Ctx == null) {
            this._Ctx = new Context();
        }
        this._Ctx.start(fc, feat);
        return this._Ctx;
    }

    private final synchronized StreamFeatureset getFeatureset() {
        return this._Featureset;
    }

    private final synchronized void setFeatureset(StreamFeatureset fs) {
        this._Featureset = fs;
    }

    public boolean isStarted() {
        return !this._Armed.isEmpty() || this.getFailure() != null;
    }

    public boolean isCompleted() {
        return this.isCompleted(false);
    }

    public boolean isCompleted(boolean all) {
        boolean completed;
        Iterator itr = this._Armed.values().iterator();
        boolean bl = completed = !this._Armed.isEmpty();
        if (this.getFailure() != null) {
            return true;
        }
        if (all) {
            boolean bl2 = completed = completed && this._Consumers.size() == this._Armed.size();
        }
        while (completed && itr.hasNext()) {
            completed = completed && ((ConsumerStatus)itr.next()).isComplete();
        }
        return completed;
    }

    public synchronized Throwable getFailure() {
        return this._Failure;
    }

    private final synchronized void setFailure(Throwable t) {
        this._Failure = t;
    }

    protected void process(StreamFeatureset fs) {
        Iterator fcItr = this.listFeatureConsumers().iterator();
        FeatureConsumer fc = null;
        StreamFeature feat = null;
        this.setFeatureset(fs);
        while (feat == null && fcItr.hasNext()) {
            fc = (FeatureConsumer)fcItr.next();
            feat = fc.findFeature(fs);
        }
        try {
            if (feat != null) {
                Context ctx = this.startFeatureContext(fc, feat);
                fc.consume(ctx);
            } else if (!this.isCompleted()) {
                StreamError se = this.getConnection().getDataFactory().createStreamError("policy-violation");
                throw new StreamException(se);
            }
        }
        catch (Throwable t) {
            this.setFailure(t);
        }
    }

    public synchronized void run() {
        try {
            this.setFeaturesPending(true);
            do {
                this.getConnection().process();
                try {
                    this.wait(10L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (this.isFeaturesPending() || !this.isCompleted());
            this.setFeaturesPending(false);
        }
        catch (Throwable t) {
            this.setFailure(t);
        }
    }

    private boolean isFeaturesPending() {
        return this._Pending;
    }

    private void setFeaturesPending(boolean pending) {
        this._Pending = pending;
    }

    private class Context
    implements FeatureContext,
    StreamFeaturesListener {
        private FeatureConsumer _Consumer;
        private StreamFeature _Feature;
        private boolean _Pending;

        public FeatureConsumer getConsumer() {
            return this._Consumer;
        }

        public StreamFeature getFeature() {
            return this._Feature;
        }

        public void start(FeatureConsumer fc, StreamFeature feat) {
            this._Consumer = fc;
            this._Feature = feat;
            FeaturesetConsumerManager.this.updateConsumerStatus(this.getConsumer(), IN_PROGRESS);
        }

        public PacketRouter getRouter() {
            return FeaturesetConsumerManager.this._Conn;
        }

        public PacketDispatcher getDispatcher() {
            return FeaturesetConsumerManager.this._Conn;
        }

        public void completeFailed(Throwable t) {
            FeaturesetConsumerManager.this.setFailure(t);
            FeaturesetConsumerManager.this.updateConsumerStatus(this.getConsumer(), FAILED);
        }

        public void completeSucceeded(boolean restart) {
            FeaturesetConsumerManager.this.updateConsumerStatus(this.getConsumer(), SUCCEEDED);
            try {
                if (restart) {
                    FeaturesetConsumerManager.this.setFeaturesPending(true);
                    FeaturesetConsumerManager.this.getConnection().drop();
                    FeaturesetConsumerManager.this.getConnection().open();
                } else {
                    FeaturesetConsumerManager.this.getFeatureset().remove(this.getFeature());
                    FeaturesetConsumerManager.this.process(FeaturesetConsumerManager.this.getFeatureset());
                }
            }
            catch (Throwable t) {
                FeaturesetConsumerManager.this.setFailure(t);
            }
        }

        public void featuresReported(StreamFeaturesEvent evt) {
            FeaturesetConsumerManager.this.setFeaturesPending(false);
            FeaturesetConsumerManager.this.process(evt.getFeatureset());
        }
    }

    public static class ConsumerStatus
    extends Enumerator {
        private boolean _Started;
        private boolean _Complete;

        private ConsumerStatus(String name, boolean started, boolean complete) {
            super(name);
            this._Started = started;
            this._Complete = complete;
        }

        public final boolean isStarted() {
            return this._Started;
        }

        public final boolean isComplete() {
            return this._Complete;
        }
    }
}

