/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.features;

import org.jabberstudio.jso.features.FeatureConsumer;
import org.jabberstudio.jso.features.FeatureContext;

public abstract class AbstractFeatureConsumer
implements FeatureConsumer {
    private FeatureContext _Ctx;

    protected FeatureContext getFeatureContext() {
        return this._Ctx;
    }

    protected void setFeatureContext(FeatureContext ctx) {
        this._Ctx = ctx;
    }

    public void consume(FeatureContext ctx) throws Exception {
        this.setFeatureContext(ctx);
        try {
            this.startConsumption();
        }
        catch (Throwable t) {
            this.completeFailedConsumption(t);
        }
    }

    public void reset() {
        this.setFeatureContext(null);
    }

    protected abstract void startConsumption() throws Throwable;

    protected void completeSucceededConsumption(boolean restart) throws IllegalStateException {
        FeatureContext ctx = this.getFeatureContext();
        if (ctx == null) {
            throw new IllegalStateException("FeatureContext has not been initialized");
        }
        ctx.completeSucceeded(restart);
        this.setFeatureContext(null);
    }

    protected void completeFailedConsumption(Throwable t) {
        FeatureContext ctx = this.getFeatureContext();
        if (ctx == null) {
            throw new IllegalStateException("FeatureContext has not been initialized");
        }
        ctx.completeFailed(t);
        this.setFeatureContext(null);
    }
}

