/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.xpath;

import java.util.Iterator;
import net.outer_planes.jso.xpath.JSOXPath;
import org.jabberstudio.jso.StreamAttribute;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNamespace;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.StreamText;
import org.jaxen.DefaultNavigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.util.SingleObjectIterator;
import org.saxpath.SAXPathException;

public class StreamNavigator
extends DefaultNavigator {
    public boolean isText(Object obj) {
        return obj instanceof StreamText;
    }

    public boolean isProcessingInstruction(Object obj) {
        return false;
    }

    public boolean isNamespace(Object obj) {
        return obj instanceof StreamNamespace;
    }

    public boolean isElement(Object obj) {
        return obj instanceof StreamElement;
    }

    public boolean isDocument(Object obj) {
        return obj instanceof StreamContext;
    }

    public boolean isComment(Object obj) {
        return false;
    }

    public boolean isAttribute(Object obj) {
        return obj instanceof StreamAttribute;
    }

    public String getAttributeStringValue(Object obj) {
        return ((StreamAttribute)obj).getValue();
    }

    public String getAttributeQName(Object obj) {
        return ((StreamAttribute)obj).getQualifiedName();
    }

    public String getAttributeNamespaceUri(Object obj) {
        return ((StreamAttribute)obj).getNamespaceURI();
    }

    public String getAttributeName(Object obj) {
        return ((StreamAttribute)obj).getLocalName();
    }

    public String getElementStringValue(Object obj) {
        StreamElement elem = (StreamElement)obj;
        Iterator nodeItr = elem.listNodes().iterator();
        StringBuffer buffer = new StringBuffer();
        while (nodeItr.hasNext()) {
            StreamNode node = (StreamNode)nodeItr.next();
            if (node instanceof StreamText) {
                buffer.append(((StreamText)node).getValue());
                continue;
            }
            if (!(node instanceof StreamElement)) continue;
            buffer.append(this.getElementStringValue(node));
        }
        return buffer.toString();
    }

    public String getElementQName(Object obj) {
        return ((StreamElement)obj).getQualifiedName();
    }

    public String getElementNamespaceUri(Object obj) {
        return ((StreamElement)obj).getNamespaceURI();
    }

    public String getElementName(Object obj) {
        return ((StreamElement)obj).getLocalName();
    }

    public String getTextStringValue(Object obj) {
        return ((StreamText)obj).getValue();
    }

    public String getCommentStringValue(Object obj) {
        return null;
    }

    public String getNamespaceStringValue(Object obj) {
        return ((StreamNamespace)obj).getURI();
    }

    public String getNamespacePrefix(Object obj) {
        return ((StreamNamespace)obj).getPrefix();
    }

    public Object getDocumentNode(Object obj) {
        StreamContext ctx = null;
        if (obj instanceof StreamObject) {
            ctx = ((StreamObject)obj).getContext();
        }
        return ctx;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new JSOXPath(xpath, this);
    }

    public Iterator getParentAxisIterator(Object obj) throws UnsupportedAxisException {
        StreamElement parent = null;
        SingleObjectIterator itr = null;
        if (obj instanceof StreamObject) {
            parent = ((StreamObject)obj).getParent();
            itr = new SingleObjectIterator(parent);
        }
        return itr;
    }

    public Iterator getChildAxisIterator(Object obj) throws UnsupportedAxisException {
        Iterator itr = null;
        if (obj instanceof StreamNode) {
            itr = ((StreamNode)obj).listNodes().iterator();
        }
        return itr;
    }

    public Iterator getAttributeAxisIterator(Object obj) throws UnsupportedAxisException {
        Iterator itr = null;
        if (obj instanceof StreamElement) {
            itr = ((StreamElement)obj).getAttributes().values().iterator();
        }
        return itr;
    }

    public Iterator getNamespaceAxisIterator(Object obj) throws UnsupportedAxisException {
        Iterator itr = null;
        if (obj instanceof StreamElement) {
            itr = ((StreamElement)obj).getDeclaredNamespaces().iterator();
        }
        return itr;
    }

    public String translateNamespacePrefixToUri(String prefix, Object obj) {
        StreamElement elem = null;
        String uri = null;
        if (obj instanceof StreamAttribute) {
            elem = ((StreamAttribute)obj).getParent();
        }
        if (obj instanceof StreamElement) {
            elem = (StreamElement)obj;
        }
        if (elem != null) {
            uri = elem.getNamespaceURI(prefix);
        }
        return uri;
    }
}

