/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.info;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.TimeZone;
import net.outer_planes.jso.AbstractElementFactory;
import net.outer_planes.jso.x.info.DelayExtensionNode;
import net.outer_planes.jso.x.info.ExpireExtensionNode;
import net.outer_planes.jso.x.info.LastQueryNode;
import net.outer_planes.jso.x.info.OOBExtensionNode;
import net.outer_planes.jso.x.info.TimeQueryNode;
import net.outer_planes.jso.x.info.VersionQueryNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;

public class InfoExtensionFactory
extends AbstractElementFactory {
    public static final String OS_STRING = MessageFormat.format("{0}/{1} ({2})", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"));

    public InfoExtensionFactory() {
        super(NSI.STRICT_COMPARATOR);
    }

    protected void registerSupportedElements() throws IllegalArgumentException {
        this.putSupportedElement(new DelayExtensionNode(null));
        this.putSupportedElement(new ExpireExtensionNode(null));
        this.putSupportedElement(new LastQueryNode(null));
        this.putSupportedElement(OOBExtensionNode.createOutOfBandIQ(null));
        this.putSupportedElement(OOBExtensionNode.createOutOfBandX(null));
        this.putSupportedElement(new TimeQueryNode(null));
        this.putSupportedElement(new VersionQueryNode(null));
    }

    public StreamElement createElementNode(NSI name, Class iface, StreamDataFactory sdf) {
        StreamElement elem = super.createElementNode(name, iface, sdf);
        if (NSI.STRICT_COMPARATOR.compare(name = elem.getNSI(), DelayExtensionNode.NAME) == 0) {
            DelayExtensionNode delay = (DelayExtensionNode)elem;
            Date now = new Date();
            delay.setStamp(now);
        } else if (NSI.STRICT_COMPARATOR.compare(name, TimeQueryNode.NAME) == 0) {
            TimeQueryNode time = (TimeQueryNode)elem;
            DateFormat fmt = DateFormat.getDateTimeInstance(1, 1);
            Date now = new Date();
            time.setTime(now);
            time.setTimezone(TimeZone.getDefault().getDisplayName());
            time.setDisplay(fmt.format(now));
        } else if (NSI.STRICT_COMPARATOR.compare(name, VersionQueryNode.NAME) == 0) {
            VersionQueryNode ver = (VersionQueryNode)elem;
            ver.setName("JSO-based Application");
            ver.setOS(OS_STRING);
            ver.setVersion("0.13-DEV-20050427164736");
        }
        return elem;
    }
}

