/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.disco;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.outer_planes.jso.ExtensionNode;
import net.outer_planes.jso.x.disco.IdentityNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.disco.DiscoIdentity;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoUtilities;
import org.jaxen.JaxenException;
import org.jaxen.SimpleVariableContext;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class InfoNode
extends ExtensionNode
implements DiscoInfoQuery {
    public static final NSI ATTRNAME_VAR = new NSI("var", null);
    public static final NSI ELEMNAME_FEATURE = new NSI("feature", "http://jabber.org/protocol/disco#info");
    public static final Map NSS = Collections.unmodifiableMap(Collections.singletonMap("dinfo", "http://jabber.org/protocol/disco#info"));
    private String _Name = null;
    private XPath _IdentPath;
    private XPath _FeatPath;

    public InfoNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected InfoNode(StreamElement parent, InfoNode base) {
        super(parent, base);
    }

    protected XPath getIdentityXPath() {
        if (this._IdentPath == null) {
            try {
                this._IdentPath = this.getDataFactory().createXPath("dinfo:identity[($category='' or @category=$category and ($type='' or @type=$type)]", NSS);
            }
            catch (SAXPathException sAXPathException) {
                // empty catch block
            }
        }
        return this._IdentPath;
    }

    public String getNode() {
        String node = this.getAttributeValue(DiscoUtilities.ATTRNAME_NODE);
        return node != null ? node : "";
    }

    public void setNode(String node) {
        this.setAttributeValue(DiscoUtilities.ATTRNAME_NODE, Utilities.isValidString(node) ? node : null);
    }

    public String getName() {
        DiscoIdentity ident;
        if (!Utilities.isValidString(this._Name) && (ident = (DiscoIdentity)this.getFirstElement(DiscoIdentity.class)) != null) {
            this._Name = ident.getName();
        }
        return this._Name != null ? this._Name : "";
    }

    public void setName(String name) {
        Iterator itr = this.listElements(DiscoIdentity.class).iterator();
        String string = this._Name = Utilities.isValidString(name) ? name : null;
        if (this._Name != null) {
            while (itr.hasNext()) {
                DiscoIdentity ident = (DiscoIdentity)itr.next();
                ident.setName(name);
            }
        }
    }

    public List listIdentities() {
        return this.listIdentities(null, null);
    }

    public List listIdentities(String cat, String type) {
        List idents;
        try {
            XPath xpath = this.getIdentityXPath();
            SimpleVariableContext varCtx = new SimpleVariableContext();
            varCtx.setVariableValue("category", cat != null ? cat : "");
            varCtx.setVariableValue("type", type != null ? type : "");
            xpath.setVariableContext(varCtx);
            idents = xpath.selectNodes(this);
        }
        catch (JaxenException je) {
            idents = Collections.EMPTY_LIST;
        }
        return idents;
    }

    public DiscoIdentity getIdentity(String cat, String type) throws IllegalArgumentException {
        DiscoIdentity ident = null;
        if (!Utilities.isValidString(cat)) {
            throw new IllegalArgumentException("Category cannot be null or \"\"");
        }
        if (!Utilities.isValidString(type)) {
            throw new IllegalArgumentException("Type cannot be null or \"\"");
        }
        Iterator itr = this.listIdentities(cat, type).iterator();
        ident = itr.hasNext() ? itr.next() : null;
        return ident;
    }

    public DiscoIdentity addIdentity(String cat, String type) throws IllegalArgumentException {
        return this.addIdentity(cat, type, this.getName());
    }

    public DiscoIdentity addIdentity(String cat, String type, String name) throws IllegalArgumentException {
        DiscoIdentity ident = this.getIdentity(cat, type);
        if (ident == null) {
            IdentityNode temp = (IdentityNode)this.addElement(IdentityNode.NAME, IdentityNode.class);
            temp.setCategory(cat);
            temp.setType(type);
            temp.setName(name);
            ident = temp;
        }
        return ident;
    }

    public void removeIdentity(String cat, String type) throws IllegalArgumentException {
        DiscoIdentity ident = this.getIdentity(cat, type);
        if (ident != null) {
            ident.detach();
        }
    }

    public void clearIdentities() {
        this.clearElements(DiscoIdentity.class);
    }

    public Set getFeatures() {
        List elems = this.listElements(ELEMNAME_FEATURE);
        HashSet<String> feats = new HashSet<String>();
        Iterator itr = elems.iterator();
        while (itr.hasNext()) {
            StreamElement elem = (StreamElement)itr.next();
            feats.add(elem.getAttributeValue(ATTRNAME_VAR));
        }
        return feats;
    }

    public void addFeature(String feat) {
        if (!Utilities.isValidString(feat)) {
            return;
        }
        if (!this.getFeatures().contains(feat)) {
            this.addElement(ELEMNAME_FEATURE).setAttributeValue(ATTRNAME_VAR, feat);
        }
    }

    public void removeFeature(String feat) {
        if (!Utilities.isValidString(feat)) {
            return;
        }
        Iterator itr = this.listElements(ELEMNAME_FEATURE).iterator();
        while (itr.hasNext()) {
            StreamElement elem = (StreamElement)itr.next();
            if (!Utilities.equateStrings(elem.getAttributeValue(ATTRNAME_VAR), feat)) continue;
            elem.detach();
        }
    }

    public void clearFeatures() {
        this.clearElements(ELEMNAME_FEATURE);
    }

    public StreamObject copy(StreamElement parent) {
        return new InfoNode(parent, this);
    }
}

