/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl.mechanisms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import net.outer_planes.jso.sasl.AbstractMechanismProvider;
import net.outer_planes.jso.sasl.ClientMechanism;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.sasl.SASLAuthPacket;
import org.jabberstudio.jso.sasl.SASLClientInfo;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.sasl.SASLPacket;
import org.jabberstudio.jso.sasl.callback.AuthorizationIDCallback;

public class ClientPLAINMechanism
extends ClientMechanism {
    public static final String NAME = "PLAIN";
    public static final Map POLICY;

    public ClientPLAINMechanism(SASLClientInfo ci) {
        super(ci);
    }

    public String getMechanismName() {
        return NAME;
    }

    protected SASLPacket generateAuth() {
        SASLAuthPacket sasl = (SASLAuthPacket)this.getDataFactory().createPacketNode(SASLAuthPacket.NAME, SASLAuthPacket.class);
        sasl.setMechanismName(this.getMechanismName());
        this.setCurrentStatus(AUTHENTICATING);
        return this.generateResponse(sasl);
    }

    protected SASLPacket evaluateChallenge(SASLPacket challenge) {
        return this.generateResponse((SASLPacket)this.getDataFactory().createPacketNode(SASLPacket.NAME_RESPONSE, SASLPacket.class));
    }

    private final SASLPacket generateResponse(SASLPacket input) {
        CallbackHandler cbh = this.getCallbackHandler();
        ArrayList<Callback> calls = new ArrayList<Callback>();
        AuthorizationIDCallback cbAzid = null;
        Object cbUser = null;
        Object cbPass = null;
        SASLPacket output = null;
        JID azid = this.getAuthorizationID();
        Object user = this.getProperty("javax.security.sasl.username");
        Object pass = this.getProperty("javax.security.sasl.password");
        if (cbh != null) {
            if (user == null) {
                user = new NameCallback("username");
                calls.add((Callback)user);
            }
            if (pass == null) {
                pass = new PasswordCallback("password", false);
                calls.add((Callback)pass);
            }
            if (azid == null) {
                cbAzid = new AuthorizationIDCallback("authorization id");
                calls.add(cbAzid);
            }
            if (!calls.isEmpty()) {
                try {
                    Callback[] cbs = new Callback[calls.size()];
                    cbs = calls.toArray(cbs);
                    cbh.handle(cbs);
                    Iterator itr = calls.iterator();
                    while (itr.hasNext()) {
                        Callback cb = (Callback)itr.next();
                        if (cb instanceof NameCallback) {
                            user = ((NameCallback)cb).getName();
                        }
                        if (cb instanceof PasswordCallback) {
                            pass = new String(((PasswordCallback)cb).getPassword());
                        }
                        if (!(cb instanceof AuthorizationIDCallback)) continue;
                        azid = ((AuthorizationIDCallback)cb).getAuthorizationID();
                    }
                }
                catch (Exception e) {
                    this.obtainLogger().warn("Could not process all calbacks", e);
                    output = (SASLPacket)this.getDataFactory().createPacketNode(SASLPacket.NAME_ABORT, SASLPacket.class);
                }
            }
        }
        if (output == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            output = input;
            try {
                if (azid != null) {
                    this.writeParameter(bout, azid);
                }
                bout.write(0);
                if (user != null) {
                    this.writeParameter(bout, user);
                }
                bout.write(0);
                if (pass != null) {
                    this.writeParameter(bout, pass);
                }
            }
            catch (IOException ioe) {
                this.obtainLogger().fatal("Could not convert string to UTF-8", ioe);
            }
            output.setData(bout.toByteArray());
        }
        this.setCurrentStatus(AUTHENTICATING);
        return output;
    }

    private final void writeParameter(ByteArrayOutputStream bout, Object param) throws IOException {
        byte[] data = param.toString().getBytes("UTF-8");
        bout.write(data, 0, data.length);
    }

    static {
        TreeMap<String, String> temp = new TreeMap<String, String>();
        temp.put("javax.security.sasl.policy.forward", "false");
        temp.put("javax.security.sasl.policy.noanonymous", "true");
        temp.put("javax.security.sasl.policy.noactive", "false");
        temp.put("javax.security.sasl.policy.nodictionary", "false");
        temp.put("javax.security.sasl.policy.noplaintext", "false");
        temp.put("javax.security.sasl.policy.credentials", "false");
        POLICY = Collections.unmodifiableMap(temp);
    }

    public static class Entry
    extends AbstractMechanismProvider.ClientEntry {
        public Entry() {
            super(ClientPLAINMechanism.NAME, POLICY);
        }

        public SASLMechanism createMechanism(SASLClientInfo info) {
            return new ClientPLAINMechanism(info);
        }
    }
}

