/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.sasl.SASLClientInfo;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.sasl.SASLMechanismProvider;
import org.jabberstudio.jso.sasl.SASLServerInfo;

public abstract class AbstractMechanismProvider
implements SASLMechanismProvider {
    private static final List POLICY_KEYS = Arrays.asList("javax.security.sasl.policy.noanonymous", "javax.security.sasl.policy.noactive", "javax.security.sasl.policy.noplaintext", "javax.security.sasl.policy.nodictionary", "javax.security.sasl.policy.forward");
    private List _ClientOrder = new ArrayList();
    private Map _ClientMechs = new TreeMap();
    private List _ServerOrder = new ArrayList();
    private Map _ServerMechs = new TreeMap();

    public AbstractMechanismProvider() {
        this.registerSupportedMechanisms();
    }

    protected Logger obtainLogger() {
        return Logger.getLogger(this.getClass());
    }

    protected abstract void registerSupportedMechanisms();

    protected void addSupportedClientMechanism(ClientEntry entry) {
        Map mechs = this.getClientManchanisms();
        List order = this.getClientOrdering();
        if (entry != null && !mechs.containsKey(entry.getName())) {
            order.add(entry.getName());
            mechs.put(entry.getName(), entry);
        }
    }

    protected void addSupportedServerMechanism(ServerEntry entry) {
        Map mechs = this.getServerManchanisms();
        List order = this.getServerOrdering();
        if (entry != null && !mechs.containsKey(entry.getName())) {
            order.add(entry.getName());
            mechs.put(entry.getName(), entry);
        }
    }

    protected List getClientOrdering() {
        return this._ClientOrder;
    }

    protected Map getClientManchanisms() {
        return this._ClientMechs;
    }

    public List getClientMechanismNames(Map props) {
        Map mechs = this.getClientManchanisms();
        ArrayList names = new ArrayList(this.getClientOrdering());
        Iterator itr = names.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            ClientEntry entry = (ClientEntry)mechs.get(name);
            if (entry.meetsPolicy(props)) continue;
            itr.remove();
        }
        return names;
    }

    public SASLMechanism createClientMechanism(SASLClientInfo ci) throws IllegalArgumentException {
        Map mechs = this.getClientManchanisms();
        Map props = ci.getProperties();
        List supported = ci.getMechanismNames();
        Iterator itr = this.getClientOrdering().iterator();
        SASLMechanism mech = null;
        while (mech == null && itr.hasNext()) {
            ClientEntry entry;
            String name = (String)itr.next();
            if (!supported.contains(name) || !(entry = (ClientEntry)mechs.get(name)).meetsPolicy(props)) continue;
            mech = entry.createMechanism(ci);
        }
        return mech;
    }

    protected Map getServerManchanisms() {
        return this._ServerMechs;
    }

    protected List getServerOrdering() {
        return this._ServerOrder;
    }

    public List getServerMechanismNames(Map props) {
        Map mechs = this.getServerManchanisms();
        ArrayList names = new ArrayList(this.getServerOrdering());
        Iterator itr = names.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            ServerEntry entry = (ServerEntry)mechs.get(name);
            if (entry.meetsPolicy(props)) continue;
            itr.remove();
        }
        return names;
    }

    public SASLMechanism createServerMechanism(SASLServerInfo si) throws IllegalArgumentException {
        Map mechs = this.getServerManchanisms();
        Map props = si.getProperties();
        ServerEntry entry = (ServerEntry)mechs.get(si.getMechanismName());
        SASLMechanism mech = null;
        if (entry != null && entry.meetsPolicy(props)) {
            mech = entry.createMechanism(si);
        }
        return mech;
    }

    public static abstract class ServerEntry {
        private String _Name;
        private Map _Policy;

        public ServerEntry(String name, Map policy) {
            this._Name = name;
            this._Policy = policy != null ? policy : Collections.EMPTY_MAP;
        }

        public final String getName() {
            return this._Name;
        }

        public final Map getPolicy() {
            return this._Policy;
        }

        public final boolean meetsPolicy(Map expect) {
            Map actual = this.getPolicy();
            Iterator itr = POLICY_KEYS.iterator();
            boolean result = true;
            if (expect == null) {
                expect = Collections.EMPTY_MAP;
            }
            while (result && itr.hasNext()) {
                Boolean actualVal;
                Object key = itr.next();
                Object val1 = expect.get(key);
                Object val2 = actual.get(key);
                Boolean expectVal = val1 == null ? Boolean.FALSE : Boolean.valueOf(val1.toString());
                Boolean bl = actualVal = val2 == null ? Boolean.FALSE : Boolean.valueOf(val2.toString());
                result = expectVal == false ? true : expectVal != false && actualVal != false;
            }
            return result;
        }

        public abstract SASLMechanism createMechanism(SASLServerInfo var1);
    }

    public static abstract class ClientEntry {
        private String _Name;
        private Map _Policy;

        public ClientEntry(String name, Map policy) {
            this._Name = name;
            this._Policy = policy != null ? policy : Collections.EMPTY_MAP;
        }

        public final String getName() {
            return this._Name;
        }

        public final Map getPolicy() {
            return this._Policy;
        }

        public final boolean meetsPolicy(Map expect) {
            Map actual = this.getPolicy();
            Iterator itr = POLICY_KEYS.iterator();
            boolean result = true;
            if (expect == null) {
                expect = Collections.EMPTY_MAP;
            }
            while (result && itr.hasNext()) {
                Boolean actualVal;
                Object key = itr.next();
                Object val1 = expect.get(key);
                Object val2 = actual.get(key);
                Boolean expectVal = val1 == null ? Boolean.FALSE : Boolean.valueOf(val1.toString());
                Boolean bl = actualVal = val2 == null ? Boolean.FALSE : Boolean.valueOf(val2.toString());
                result = expectVal == false ? true : expectVal != false && actualVal != false;
            }
            return result;
        }

        public abstract SASLMechanism createMechanism(SASLClientInfo var1);
    }
}

