/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.util.Utilities;

public abstract class AbstractMechanism
implements SASLMechanism {
    private SASLMechanism.Status _CurrStatus;
    private String _Server;
    private StreamDataFactory _SDF;
    private CallbackHandler _CBH;
    private Map _Props = new TreeMap();

    public AbstractMechanism(StreamDataFactory sdf, String srv, CallbackHandler cbh, Map props) {
        this._CurrStatus = READY;
        this._Server = srv;
        this._CBH = cbh;
        this._SDF = sdf;
        if (props != null) {
            this._Props.putAll(props);
        }
    }

    protected Logger obtainLogger() {
        return Logger.getLogger(this.getClass());
    }

    public SASLMechanism.Status getCurrentStatus() {
        return this._CurrStatus;
    }

    public void setCurrentStatus(SASLMechanism.Status stat) {
        this._CurrStatus = stat;
    }

    public CallbackHandler getCallbackHandler() {
        return this._CBH;
    }

    public String getServer() {
        return this._Server;
    }

    public StreamDataFactory getDataFactory() {
        return this._SDF;
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this._Props);
    }

    public Object getProperty(String key) {
        if (!Utilities.isValidString(key)) {
            throw new IllegalArgumentException("key cannot be null or \"\"");
        }
        return this._Props.get(key);
    }

    public void setProperty(String key, Object val) {
        if (!Utilities.isValidString(key)) {
            throw new IllegalArgumentException("key cannot be null or \"\"");
        }
        if (val != null) {
            this._Props.put(key, val);
        } else {
            this._Props.remove(key);
        }
    }

    public SASLMechanism.Status reset() {
        this.setCurrentStatus(READY);
        return this.getCurrentStatus();
    }

    public byte[] wrap(byte[] input) throws IllegalStateException {
        return input;
    }

    public byte[] unwrap(byte[] input) throws IllegalStateException {
        return input;
    }
}

