/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.ixp;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jabberstudio.jso.util.Utilities;

public class NamespaceManager {
    private NamespaceManager _Parent;
    private Map _NSS;

    public NamespaceManager(NamespaceManager parent, Map nss) {
        this._Parent = parent;
        this._NSS = nss != null ? nss : Collections.EMPTY_MAP;
    }

    public NamespaceManager getParent() {
        return this._Parent;
    }

    public NamespaceManager getManager(int depth) {
        return depth == this.getDepth() ? this : (this.getParent() != null ? this.getParent().getManager(depth) : null);
    }

    public int getDepth() {
        return (this.getParent() != null ? this.getParent().getDepth() : -1) + 1;
    }

    public Map getNamespaces() {
        return this._NSS;
    }

    public void setNamespaces(Map nss) {
        this._NSS.clear();
        this._NSS.putAll(nss);
    }

    public Map getNamespaces(int depth) {
        return depth == this.getDepth() ? this._NSS : (this.getParent() != null ? this.getParent().getNamespaces(depth) : null);
    }

    public Set getNamespaceURIs(int depth) {
        Map mapping = this.getNamespaces(depth);
        TreeSet uris = new TreeSet();
        if (mapping != null) {
            uris.addAll(mapping.values());
        }
        return uris;
    }

    public Set getNamespacePrefixes(int depth) {
        Map mapping = this.getNamespaces(depth);
        TreeSet prefixes = new TreeSet();
        if (mapping != null) {
            prefixes.addAll(mapping.keySet());
        }
        return prefixes;
    }

    public String getNamespaceURI(String prefix) {
        String uri = null;
        Iterator itr = this._NSS.entrySet().iterator();
        if (prefix == null) {
            prefix = "";
        }
        if (Utilities.equateStrings("xml", prefix)) {
            uri = "http://www.w3.org/XML/1998/namespace";
        }
        while (uri == null && itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (!entry.getKey().equals(prefix)) continue;
            uri = (String)entry.getValue();
        }
        return uri != null ? uri : (this.getParent() != null ? this.getParent().getNamespaceURI(prefix) : null);
    }

    public String getNamespacePrefix(String uri) {
        String prefix = null;
        Iterator itr = this._NSS.entrySet().iterator();
        if (uri == null) {
            uri = "";
        }
        if (Utilities.equateStrings("http://www.w3.org/XML/1998/namespace", uri)) {
            prefix = "xml";
        }
        while (prefix == null && itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (!entry.getValue().equals(uri)) continue;
            prefix = (String)entry.getKey();
        }
        return prefix != null ? prefix : (this.getParent() != null ? this.getParent().getNamespacePrefix(uri) : null);
    }

    public String toString() {
        return "namespace manager (depth=" + this.getDepth() + ";nss=" + this.getNamespaces() + ")";
    }
}

