/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.io;

import net.outer_planes.jso.BasicStreamContext;
import net.outer_planes.jso.NamespaceNode;
import org.jabberstudio.jso.StreamAttribute;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNamespace;
import org.jabberstudio.jso.StreamText;
import org.jabberstudio.jso.io.XMLExporter;
import org.jabberstudio.jso.util.BasicStreamObjectVisitor;
import org.jabberstudio.jso.util.Utilities;

public class XMLWriter
implements XMLExporter {
    private StreamElement _Ctx;
    private StringBuffer _Buffer;

    public XMLWriter() {
    }

    public XMLWriter(StreamElement ctx) throws IllegalArgumentException {
        this.configure(ctx);
    }

    public StreamElement getContext() {
        return this._Ctx;
    }

    private void setContext(StreamElement ctx) throws IllegalArgumentException {
        if (ctx == null) {
            ctx = new BasicStreamContext();
        }
        this._Ctx = ctx;
    }

    public synchronized String write(StreamElement in) throws RuntimeException {
        this._Buffer = new StringBuffer();
        in.accept(new Visitor());
        return this._Buffer.toString();
    }

    public void configure(StreamElement ctx) throws IllegalArgumentException, IllegalStateException, RuntimeException {
        if (this.getContext() != null) {
            throw new IllegalStateException("This exporter is already configured");
        }
        this.setContext(ctx);
    }

    public Object execute(StreamElement in) throws RuntimeException {
        return this.write(in);
    }

    private class Visitor
    extends BasicStreamObjectVisitor {
        private Visitor() {
        }

        public String encodeTextValue(String in) {
            StringBuffer out = new StringBuffer();
            block4: for (int idx = 0; idx < in.length(); ++idx) {
                char ch = in.charAt(idx);
                switch (ch) {
                    case '&': {
                        out.append("&amp;");
                        continue block4;
                    }
                    case '<': {
                        out.append("&lt;");
                        continue block4;
                    }
                    default: {
                        out.append(ch);
                    }
                }
            }
            return out.toString();
        }

        public String encodeAttributeValue(String in) {
            StringBuffer out = new StringBuffer();
            block7: for (int idx = 0; idx < in.length(); ++idx) {
                char ch = in.charAt(idx);
                switch (ch) {
                    case '&': {
                        out.append("&amp;");
                        continue block7;
                    }
                    case '<': {
                        out.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        out.append("&gt;");
                        continue block7;
                    }
                    case '\'': {
                        out.append("&apos;");
                        continue block7;
                    }
                    case '\"': {
                        out.append("&quot;");
                        continue block7;
                    }
                    default: {
                        out.append(ch);
                    }
                }
            }
            return out.toString();
        }

        public String generateQName(StreamElement elem) {
            String local = elem.getLocalName();
            String prefix = elem.getNamespacePrefix();
            StringBuffer qname = new StringBuffer();
            if (Utilities.isValidString(prefix)) {
                qname.append(prefix).append(":");
            }
            qname.append(local);
            return qname.toString();
        }

        public String generateQName(StreamAttribute attr) {
            String local = attr.getLocalName();
            String prefix = attr.getNamespacePrefix();
            StringBuffer qname = new StringBuffer();
            if (Utilities.isValidString(prefix)) {
                qname.append(prefix).append(":");
            }
            qname.append(local);
            return qname.toString();
        }

        public void visit(StreamElement in) {
            StreamElement parent = in.getParent();
            String qname = this.generateQName(in);
            String pURI = parent != null ? parent.getNamespaceURI() : null;
            XMLWriter.this._Buffer.append("<").append(qname);
            if (in.getNamespaceURI() != null && in.getNamespacePrefix() == null && !Utilities.equateStrings(in.getNamespaceURI(), pURI)) {
                this.visit(new NamespaceNode(in, "", in.getNamespaceURI()));
            }
            super.visitNamespaces(in);
            super.visitAttributes(in);
            if (in.listNodes().isEmpty()) {
                XMLWriter.this._Buffer.append("/>");
            } else {
                XMLWriter.this._Buffer.append(">");
                super.visitChildren(in);
                XMLWriter.this._Buffer.append("</").append(qname).append(">");
            }
        }

        public void visit(StreamNamespace in) {
            String prefix = in.getPrefix();
            String uri = this.encodeAttributeValue(in.getURI());
            if (Utilities.equateStrings(uri, "http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            XMLWriter.this._Buffer.append(" ");
            if (Utilities.isValidString(prefix)) {
                XMLWriter.this._Buffer.append("xmlns:").append(prefix);
            } else {
                XMLWriter.this._Buffer.append("xmlns");
            }
            XMLWriter.this._Buffer.append("='").append(uri).append("'");
        }

        public void visit(StreamAttribute in) {
            String qname = this.generateQName(in);
            String value = this.encodeAttributeValue(in.getValue());
            XMLWriter.this._Buffer.append(" ").append(qname).append("='").append(value).append("'");
        }

        public void visit(StreamText in) {
            String out = this.encodeTextValue(in.getValue());
            XMLWriter.this._Buffer.append(out);
        }
    }
}

