/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.io;

import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jabberstudio.jso.StreamAttribute;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNamespace;
import org.jabberstudio.jso.StreamText;
import org.jabberstudio.jso.io.DOMExporter;
import org.jabberstudio.jso.util.BasicStreamObjectVisitor;
import org.jabberstudio.jso.util.Utilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DOMWriter
implements DOMExporter {
    private StreamElement _Ctx;

    public DOMWriter() {
    }

    public DOMWriter(StreamElement ctx) throws IllegalArgumentException {
        this.configure(ctx);
    }

    public StreamElement getContext() {
        return this._Ctx;
    }

    private void setContext(StreamElement ctx) throws IllegalArgumentException {
        if (ctx == null) {
            throw new IllegalArgumentException("context StreamElement cannot be null");
        }
        this._Ctx = ctx;
    }

    public Element write(StreamElement in) throws RuntimeException {
        Visitor v;
        try {
            DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            v = new Visitor(b.newDocument());
            StreamElement parent = in.getParent();
            if (!(in instanceof StreamContext)) {
                in.setParent(this.getContext());
            }
            in.accept(v);
            if (!(in instanceof StreamContext)) {
                in.setParent(parent);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return v.getCurrent();
    }

    public void configure(StreamElement ctx) throws IllegalArgumentException, IllegalStateException, RuntimeException {
        if (this.getContext() != null) {
            throw new IllegalStateException("This exporter is already configured");
        }
        this.setContext(ctx);
    }

    public Object execute(StreamElement in) throws RuntimeException {
        return this.write(in);
    }

    private class Visitor
    extends BasicStreamObjectVisitor {
        Document _Doc;
        Element _Current;

        public Visitor(Document doc) {
            this._Doc = doc;
        }

        public Document getDocument() {
            return this._Doc;
        }

        public Element getCurrent() {
            return this._Current;
        }

        public void setCurrent(Element curr) {
            this._Current = curr;
        }

        public String generateQName(StreamElement elem) {
            String local = elem.getLocalName();
            String prefix = elem.getNamespacePrefix();
            StringBuffer qname = new StringBuffer();
            if (Utilities.isValidString(prefix)) {
                qname.append(prefix).append(":");
            }
            qname.append(local);
            return qname.toString();
        }

        public String generateQName(StreamAttribute attr) {
            String local = attr.getLocalName();
            String prefix = attr.getNamespacePrefix();
            StringBuffer qname = new StringBuffer();
            if (Utilities.isValidString(prefix)) {
                qname.append(prefix).append(":");
            }
            qname.append(local);
            return qname.toString();
        }

        public void visit(StreamElement in) {
            String qname = this.generateQName(in);
            String uri = in.getNamespaceURI();
            Iterator nss = in.getDeclaredNamespaces().iterator();
            Element out = this.getDocument().createElementNS(uri, qname);
            Element parent = this.getCurrent();
            while (nss.hasNext()) {
                StreamNamespace nsObj = (StreamNamespace)nss.next();
                String nsURI = nsObj.getURI();
                String nsPrefix = nsObj.getPrefix();
                Attr nsAttr = this.getDocument().createAttribute(!Utilities.isValidString(nsPrefix) ? "xmlns" : "xmlns:" + nsPrefix);
                nsAttr.setValue(nsURI);
                out.setAttributeNode(nsAttr);
            }
            this.setCurrent(out);
            super.visit(in);
            this.setCurrent(parent);
            if (parent == null) {
                this.setCurrent(out);
            } else {
                parent.appendChild(out);
            }
        }

        public void visit(StreamAttribute in) {
            String qname = this.generateQName(in);
            String uri = in.getNamespaceURI();
            Element out = this.getCurrent();
            Attr attr = this.getDocument().createAttributeNS(uri, qname);
            attr.setValue(in.getValue());
            out.setAttributeNodeNS(attr);
        }

        public void visit(StreamText in) {
            Element out = this.getCurrent();
            Text txt = this.getDocument().createTextNode(in.getValue());
            out.appendChild(txt);
        }
    }
}

