/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.io;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.outer_planes.jso.io.DOMParseState;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.io.DOMImporter;
import org.jabberstudio.jso.io.StreamBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMReader
implements DOMImporter {
    private StreamElement _Ctx;
    private StreamElement _Output;
    private List _BuildStack = new LinkedList();

    public DOMReader() {
    }

    public DOMReader(StreamElement ctx) throws IllegalArgumentException {
        this.configure(ctx);
    }

    public StreamElement getContext() {
        return this._Ctx;
    }

    private void setContext(StreamElement ctx) throws IllegalArgumentException {
        if (ctx == null) {
            throw new IllegalArgumentException("context StreamElement cannot be null");
        }
        this._Ctx = ctx;
    }

    public StreamElement read(Element in) {
        this.setOutput(null);
        this.readElement(null, null, in);
        return this.getOutput();
    }

    private void readElement(DOMParseState parent, DOMParseState current, Element in) {
        if (current == null) {
            current = DOMParseState.createForElement(this.getContext(), parent, in);
        }
        StreamBuilder b = this.setupBuilder(current, this.topBuilder());
        Iterator itr = current.getNodes().iterator();
        current.setType(DOMParseState.ELEMENT_START);
        if (b.processElementStart(current) == StreamBuilder.EXTENDED_DATA) {
            this.pushBuilder(b.buildExtendedData());
            this.readElement(parent, current, in);
            return;
        }
        while (itr.hasNext()) {
            Node child = (Node)itr.next();
            if (child instanceof Element) {
                this.readElement(current, null, (Element)child);
                continue;
            }
            if (!(child instanceof Text)) continue;
            this.readText(current, (Text)child);
        }
        current.setType(DOMParseState.ELEMENT_END);
        if (b != null && b.processElementEnd(current) == StreamBuilder.COMPLETE) {
            StreamNode node = b.getNode();
            this.popBuilder();
            b = this.topBuilder();
            if (b == null) {
                this.setOutput((StreamElement)node);
            } else {
                b.addExtendedData(node);
            }
        }
    }

    private void readText(DOMParseState parent, Text in) {
        DOMParseState current = DOMParseState.createForText(this.getContext(), parent, in);
        StreamBuilder b = this.topBuilder();
        b.processText(current);
    }

    private StreamElement getOutput() {
        return this._Output;
    }

    private void setOutput(StreamElement out) {
        this._Output = out;
    }

    private StreamBuilder setupBuilder(DOMParseState current, StreamBuilder b) {
        if (b == null) {
            StreamElement ctx = this.getContext();
            NSI name = current.getName();
            b = name.equals(ctx.getNSI()) ? ctx.createBuilder() : ctx.getDataFactory().createElementBuilder(name, null);
            this.pushBuilder(b);
        }
        return b;
    }

    private StreamBuilder topBuilder() {
        return this._BuildStack.isEmpty() ? null : this._BuildStack.get(0);
    }

    private void pushBuilder(StreamBuilder b) {
        this._BuildStack.add(0, b);
    }

    private StreamBuilder popBuilder() {
        return this._BuildStack.isEmpty() ? null : this._BuildStack.remove(0);
    }

    public void configure(StreamElement ctx) throws IllegalArgumentException, IllegalStateException, RuntimeException {
        if (this.getContext() != null) {
            throw new IllegalStateException("This importer is already configured");
        }
        this.setContext(ctx);
    }

    public StreamElement execute(Object in) throws RuntimeException {
        return this.read((Element)in);
    }
}

