/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Iterator;
import java.util.Locale;
import net.outer_planes.jso.BasicPacketNode;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;

public class MessagePacket
extends BasicPacketNode
implements Message {
    public static final NSI NAME = new NSI("message", null);
    public static final NSI NAME_BODY = new NSI("body", null);
    public static final NSI NAME_SUBJECT = new NSI("subject", null);
    public static final NSI NAME_THREAD = new NSI("thread", null);

    public MessagePacket(StreamDataFactory sdf) {
        this(sdf, NAME);
    }

    public MessagePacket(StreamDataFactory sdf, NSI name) {
        super(sdf, name);
    }

    public MessagePacket(StreamElement parent, MessagePacket base) {
        super(parent, base);
    }

    public void checkNSI(NSI check) throws IllegalArgumentException {
        if (NSI.NS_LOOSE_COMPARATOR.compare(check, NAME) != 0) {
            throw new IllegalArgumentException("Name must be 'message'");
        }
    }

    public StreamObject copy(StreamElement p) {
        return new MessagePacket(p, this);
    }

    public void setType(Packet.Type type) throws IllegalArgumentException {
        if (type != null && type != ERROR && !(type instanceof Message.Type)) {
            throw new IllegalArgumentException("Only ERROR or message types permitted");
        }
        super.setType(type);
    }

    protected Packet.Type determineType(String name) {
        Packet.Type type = Utilities.equateStrings(CHAT.toString(), name) ? CHAT : (Utilities.equateStrings(GROUPCHAT.toString(), name) ? GROUPCHAT : (Utilities.equateStrings(HEADLINE.toString(), name) ? HEADLINE : (Utilities.equateStrings(NORMAL.toString(), name) ? NORMAL : super.determineType(name))));
        return type;
    }

    public boolean hasBody() {
        return this.hasBody(null);
    }

    public boolean hasBody(Locale l) {
        return !this.findElementsForLocale(NAME_BODY.getLocalName(), this.getNamespaceURI(), l).isEmpty();
    }

    public String getBody() {
        return this.getBody(null);
    }

    public String getBody(Locale l) {
        Iterator itr = this.findElementsForLocale(NAME_BODY.getLocalName(), this.getNamespaceURI(), l).iterator();
        String body = "";
        if (itr.hasNext()) {
            body = ((StreamElement)itr.next()).normalizeText();
        }
        return body;
    }

    public void setBody(String b) {
        this.setBody(null, b);
    }

    public void setBody(Locale l, String b) {
        Iterator itr = this.findElementsForLocale(NAME_BODY.getLocalName(), this.getNamespaceURI(), l).iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
        if (b != null) {
            StreamElement elem = this.addElement(NAME_BODY.getLocalName());
            elem.addText(b);
            if (l != null) {
                elem.setDeclaredLocale(l);
            }
        }
    }

    public String getThread() {
        StreamElement elem = this.getFirstElement(NAME_THREAD.getLocalName(), this.getNamespaceURI());
        String thread = "";
        if (elem != null) {
            thread = elem.normalizeTrimText();
        }
        return thread;
    }

    public void setThread(String t) {
        this.clearElements(NAME_THREAD.getLocalName(), this.getNamespaceURI());
        if (t != null) {
            this.addElement(NAME_THREAD.getLocalName()).addText(t);
        }
    }

    public boolean hasSubject() {
        return this.hasSubject(null);
    }

    public boolean hasSubject(Locale l) {
        return !this.findElementsForLocale(NAME_SUBJECT.getLocalName(), this.getNamespaceURI(), l).isEmpty();
    }

    public String getSubject() {
        return this.getSubject(null);
    }

    public String getSubject(Locale l) {
        Iterator itr = this.findElementsForLocale(NAME_SUBJECT.getLocalName(), this.getNamespaceURI(), l).iterator();
        String subject = "";
        if (itr.hasNext()) {
            subject = ((StreamElement)itr.next()).normalizeTrimText();
        }
        return subject;
    }

    public void setSubject(String s) {
        this.setSubject(null, s);
    }

    public void setSubject(Locale l, String s) {
        Iterator itr = this.findElementsForLocale(NAME_SUBJECT.getLocalName(), this.getNamespaceURI(), l).iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
        if (s != null) {
            StreamElement elem = this.addElement(NAME_SUBJECT.getLocalName());
            elem.addText(s);
            if (l != null) {
                elem.setDeclaredLocale(l);
            }
        }
    }
}

