/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Iterator;
import java.util.Map;
import net.outer_planes.jso.BasicStream;
import net.outer_planes.jso.BasicStreamContext;
import net.outer_planes.jso.ComponentStream;
import net.outer_planes.jso.DataFactory;
import net.outer_planes.jso.UnknownFactory;
import net.outer_planes.jso.io.DOMReader;
import net.outer_planes.jso.io.DOMWriter;
import net.outer_planes.jso.io.XMLReader;
import net.outer_planes.jso.io.XMLWriter;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamElementFactory;
import org.jabberstudio.jso.io.DOMExporter;
import org.jabberstudio.jso.io.DOMImporter;
import org.jabberstudio.jso.io.Exporter;
import org.jabberstudio.jso.io.Importer;
import org.jabberstudio.jso.io.XMLExporter;
import org.jabberstudio.jso.io.XMLImporter;
import org.jabberstudio.jso.util.Service;
import org.jabberstudio.jso.util.Utilities;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class JSO
extends JSOImplementation {
    private DataFactory _SDF;
    private Service _Exporters;
    private Service _Importers;

    public JSO() {
        Service svc = new Service(StreamElementFactory.class, null);
        Iterator found = svc.getProviders().keySet().iterator();
        this._SDF = new DataFactory();
        this.getDataFactory().registerElementFactory(new UnknownFactory());
        while (found.hasNext()) {
            try {
                StreamElementFactory sdf = (StreamElementFactory)svc.obtainProvider((String)found.next());
                this.getDataFactory().registerElementFactory(sdf);
            }
            catch (Exception e) {}
        }
    }

    public StreamDataFactory getDataFactory() {
        return this._SDF;
    }

    public StreamDataFactory createDataFactory() {
        return new DataFactory((DataFactory)this.getDataFactory());
    }

    public StreamDataFactory createDataFactory(String ns) {
        DataFactory df = new DataFactory(ns, (DataFactory)this.getDataFactory());
        return df;
    }

    public void registerElementFactory(StreamElementFactory sef) {
        this.getDataFactory().registerElementFactory(sef);
    }

    public void registerElementFactory(NSI name, StreamElementFactory sef) {
        this.getDataFactory().registerElementFactory(name, sef);
    }

    public void unregisterElementFactory(StreamElementFactory sef) {
        this.getDataFactory().unregisterElementFactory(sef);
    }

    public void unregisterElementFactory(NSI name, StreamElementFactory sef) {
        this.getDataFactory().unregisterElementFactory(name, sef);
    }

    public Map getNamespaceMappings() {
        return this.getDataFactory().getNamespaceMappings();
    }

    public void setNamespaceMappings(Map nss) {
        this.getDataFactory().setNamespaceMappings(nss);
    }

    public void putNamespaceMapping(String prefix, String uri) {
        this.getDataFactory().putNamespaceMapping(prefix, uri);
    }

    public void removeNamespaceMapping(String prefix) {
        this.getDataFactory().removeNamespaceMapping(prefix);
    }

    public XPath createXPath(String expr) throws SAXPathException {
        return this.getDataFactory().createXPath(expr);
    }

    public XPath createXPath(String expr, Map nss) throws SAXPathException {
        return this.getDataFactory().createXPath(expr, nss);
    }

    public StreamContext createStreamContext() {
        return this.createStreamContext(null, null);
    }

    public StreamContext createStreamContext(NSI name, String prefix) throws IllegalArgumentException {
        StreamContext ctx;
        if (name == null) {
            name = BasicStreamContext.NAME;
        }
        if (!Utilities.isValidString(name.getLocalName())) {
            throw new IllegalArgumentException("Local name cannot be null or \"\"");
        }
        if (name.getNamespaceURI() == null) {
            name = new NSI(name.getLocalName(), "http://etherx.jabber.org/streams");
        }
        if (prefix == null) {
            prefix = "stream";
        }
        try {
            ctx = (StreamContext)this.getDataFactory().createElementNode(name, StreamContext.class);
            ctx.addNamespace(prefix, ctx.getNamespaceURI());
        }
        catch (IllegalArgumentException iae) {
            BasicStreamContext bsc = new BasicStreamContext(name, prefix);
            bsc.setDataFactory(this.createDataFactory());
            ctx = bsc;
        }
        return ctx;
    }

    public Stream createStream(String ns) throws IllegalArgumentException {
        return this.createStream(ns, null, null);
    }

    public Stream createStream(String ns, StreamContext in, StreamContext out) throws IllegalArgumentException {
        if (ns == null) {
            ns = "";
        }
        if (in == null) {
            in = this.createStreamContext();
        }
        if (out == null) {
            out = this.createStreamContext();
        }
        if (ns.equals("jabber:component:accept") || ns.equals("jabber:component:connect")) {
            return new ComponentStream(this, (DataFactory)this.createDataFactory(ns), ns, in, out);
        }
        return new BasicStream(this, (DataFactory)this.createDataFactory(ns), ns, in, out);
    }

    private synchronized Service getExporterService() {
        if (this._Exporters == null) {
            this._Exporters = new Service(Exporter.class, null);
        }
        return this._Exporters;
    }

    public Exporter createExporter(String type, StreamElement ctx) throws IllegalArgumentException, RuntimeException {
        Exporter exp = (Exporter)this.getExporterService().obtainProvider(type);
        exp.configure(ctx);
        return exp;
    }

    public DOMExporter createDOMExporter(StreamElement ctx) throws IllegalArgumentException {
        DOMExporter exp;
        try {
            exp = (DOMExporter)this.createExporter(DOMExporter.class.getName(), ctx);
        }
        catch (IllegalArgumentException iae) {
            exp = new DOMWriter(ctx);
        }
        return exp;
    }

    public XMLExporter createXMLExporter(StreamElement ctx) throws IllegalArgumentException {
        XMLExporter exp;
        try {
            exp = (XMLExporter)this.createExporter(XMLExporter.class.getName(), ctx);
        }
        catch (IllegalArgumentException iae) {
            exp = new XMLWriter(ctx);
        }
        return exp;
    }

    private synchronized Service getImporterService() {
        if (this._Importers == null) {
            this._Importers = new Service(Importer.class, null);
        }
        return this._Importers;
    }

    public Importer createImporter(String type, StreamElement ctx) throws IllegalArgumentException, RuntimeException {
        Importer imp = (Importer)this.getImporterService().obtainProvider(type);
        imp.configure(ctx);
        return imp;
    }

    public DOMImporter createDOMImporter(StreamElement ctx) throws IllegalArgumentException {
        DOMImporter imp;
        try {
            imp = (DOMImporter)this.createImporter(DOMImporter.class.getName(), ctx);
        }
        catch (IllegalArgumentException iae) {
            imp = new DOMReader(ctx);
        }
        return imp;
    }

    public XMLImporter createXMLImporter(StreamElement ctx) throws IllegalArgumentException {
        XMLImporter imp;
        try {
            imp = (XMLImporter)this.createImporter(XMLImporter.class.getName(), ctx);
        }
        catch (IllegalArgumentException iae) {
            imp = new XMLReader(ctx);
        }
        return imp;
    }
}

